/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.BaseDestinationDefinition;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.admin.ForeignBusDefinition;
import com.ibm.ws.sib.admin.VirtualLinkDefinition;
import com.ibm.ws.sib.mfp.ProtocolType;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.gd.TargetStreamManager;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.PtoPInputHandler;
import com.ibm.ws.sib.processor.impl.destination.LinkState;
import com.ibm.ws.sib.processor.impl.interfaces.OutputHandler;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPXmitMsgsItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SIMPItemStream;
import com.ibm.ws.sib.processor.runtime.SIMPLinkRemoteMessagePointControllable;
import com.ibm.ws.sib.processor.runtime.impl.VirtualLinkControl;
import com.ibm.ws.sib.transactions.LocalTransaction;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class LinkHandler
extends BaseDestinationHandler {
    private static final TraceComponent tc = SibTr.register(LinkHandler.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private String _name;
    private SIBUuid12 _uuid;
    private String _busName;
    private String _outboundUserid = null;
    private String _inboundUserid = null;
    private String _type = null;
    private String _exceptionDestination = null;
    private Reliability _exceptionDiscardReliability = null;
    private boolean _preferLocal;
    private LinkState _linkState = null;

    public LinkHandler() {
    }

    public LinkHandler(VirtualLinkDefinition virtualLinkDefinition, MessageProcessor messageProcessor, SIMPItemStream parentItemStream, TransactionCommon transaction, HashMap durableSubscriptionsTable) throws SIResourceException {
        super(messageProcessor, parentItemStream, transaction, durableSubscriptionsTable, messageProcessor.getMessagingEngineBus());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"LinkHandler", (Object)new Object[]{virtualLinkDefinition, messageProcessor, parentItemStream, transaction, durableSubscriptionsTable});
        }
        this._name = virtualLinkDefinition.getName();
        this._uuid = virtualLinkDefinition.getUuid();
        this._outboundUserid = virtualLinkDefinition.getOutboundUserid();
        this._inboundUserid = virtualLinkDefinition.getInboundUserid();
        this._type = virtualLinkDefinition.getType();
        this._exceptionDestination = virtualLinkDefinition.getExceptionDestination();
        this._exceptionDiscardReliability = virtualLinkDefinition.getExceptionDiscardReliability();
        this._preferLocal = virtualLinkDefinition.getPreferLocal();
        ForeignBusDefinition busDef = virtualLinkDefinition.getForeignBus();
        if (busDef == null) {
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_LINK_CONFIGURATION_ERROR_CWSIP0007", new Object[]{this._name, this._uuid}, null));
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.LinkHandler.LinkHandler", (String)"1:191:1.116", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"LinkHandler", (Object)((Object)e));
            }
            throw e;
        }
        this._busName = busDef.getName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"LinkHandler", (Object)this);
        }
    }

    @Override
    protected void createRealizationAndState(MessageProcessor messageProcessor, TransactionCommon transaction) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createRealizationAndState", (Object)new Object[]{messageProcessor, transaction});
        }
        this._ptoPRealization = new LinkState(this, messageProcessor, this.getLocalisationManager());
        this._protoRealization = this._ptoPRealization;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createRealizationAndState");
        }
    }

    @Override
    protected void createRealizationAndState(MessageProcessor messageProcessor) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createRealizationAndState", (Object)new Object[]{messageProcessor});
        }
        this._ptoPRealization = new LinkState(this, messageProcessor, this.getLocalisationManager());
        this._protoRealization = this._ptoPRealization;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createRealizationAndState");
        }
    }

    @Override
    public boolean isPubSub() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isPubSub");
            SibTr.exit((TraceComponent)tc, (String)"isPubSub", (Object)false);
        }
        return false;
    }

    @Override
    public boolean isLink() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isLink");
            SibTr.exit((TraceComponent)tc, (String)"isLink", (Object)true);
        }
        return true;
    }

    @Override
    public boolean isTargetedAtLink() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isTargetedAtLink");
            SibTr.exit((TraceComponent)tc, (String)"isTargetedAtLink", (Object)true);
        }
        return true;
    }

    protected void initializePtoPStats(ConsumerDispatcher consumerDispatcher) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"initializePtoPStats", (Object)consumerDispatcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cleanupDestination() throws SIRollbackException, SIConnectionLostException, SIIncorrectCallException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"cleanupDestination");
        }
        boolean cleanedUp = super.cleanupLocalisations();
        LinkHandler linkHandler = this;
        synchronized (linkHandler) {
            if (this.isToBeDeleted()) {
                this.messageProcessor.getProxyHandler().cleanupLinkNeighbour(this._busName);
                PtoPInputHandler ptoPInputHandler = (PtoPInputHandler)this.getInputHandler(ProtocolType.UNICASTINPUT, null, null);
                TargetStreamManager targetStreamManager = ptoPInputHandler.getTargetStreamManager();
                if (targetStreamManager.isEmpty()) {
                    cleanedUp = super.cleanupDestination();
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"cleanupDestination", (Object)new Boolean(cleanedUp));
        }
        return cleanedUp;
    }

    @Override
    public String getName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getName");
            SibTr.exit((TraceComponent)tc, (String)"getName", (Object)this._name);
        }
        return this._name;
    }

    @Override
    public final SIBUuid12 getUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getUuid");
            SibTr.exit((TraceComponent)tc, (String)"getUuid", (Object)this._uuid);
        }
        return this._uuid;
    }

    public SIBUuid8 getRemoteMEUuid() throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteMEUuid");
        }
        SIBUuid8 remoteMEUuid = this.getLinkStateHandler().getRemoteMEUuid(this.getUuid());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRemoteMEUuid", (Object)remoteMEUuid);
        }
        return remoteMEUuid;
    }

    public synchronized SIBUuid8 updateLocalisationSet(SIBUuid8 newLocalisingMEUuid, SIBUuid8 newRoutingMEUuid) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateLocalisationSet", (Object)new Object[]{newLocalisingMEUuid, newRoutingMEUuid});
        }
        SIBUuid8 existingUuid = this.getLinkStateHandler().updateLocalisationSet(newLocalisingMEUuid, newRoutingMEUuid);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateLocalisationSet", (Object)existingUuid);
        }
        return existingUuid;
    }

    @Override
    public void getPersistentData(ObjectOutputStream oos) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPersistentData", (Object)oos);
        }
        try {
            HashMap hm = new HashMap();
            this.addPersistentLinkData(hm);
            oos.writeObject(hm);
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.LinkHandler.getPersistentData", (String)"1:471:1.116", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)e);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.LinkHandler", "1:478:1.116", e});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getPersistentData", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.LinkHandler", "1:488:1.116", e}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPersistentData");
        }
    }

    public void addPersistentLinkData(HashMap hm) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addPersistentLinkData", (Object)hm);
        }
        hm.put("uuid", this._uuid.toByteArray());
        hm.put("name", this._name);
        hm.put("busName", this._busName);
        hm.put("hasLocal", new Boolean(this.hasLocal()));
        hm.put("type", this._type);
        hm.put("inboundUserid", this._inboundUserid);
        hm.put("outboundUserid", this._outboundUserid);
        hm.put("TBD", new Boolean(this.isToBeDeleted()));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addPersistentLinkData");
        }
    }

    @Override
    public void restore(ObjectInputStream ois, int dataVersion) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restore", (Object)new Object[]{ois, new Integer(dataVersion)});
        }
        this.checkPersistentVersionId(dataVersion);
        try {
            HashMap hm = (HashMap)ois.readObject();
            this.restorePersistentLinkData(hm);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.LinkHandler.restore", (String)"1:558:1.116", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)e);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.LinkHandler", "1:565:1.116", e});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"restore", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.LinkHandler", "1:575:1.116", e}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restore");
        }
    }

    public void restorePersistentLinkData(HashMap hm) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restorePersistentLinkData", (Object)new Object[]{hm});
        }
        this._name = (String)hm.get("name");
        this._busName = (String)hm.get("busName");
        this._uuid = new SIBUuid12((byte[])hm.get("uuid"));
        if (((Boolean)hm.get("hasLocal")).booleanValue()) {
            this.setLocal();
        }
        this._type = (String)hm.get("type");
        this._inboundUserid = (String)hm.get("inboundUserid");
        this._outboundUserid = (String)hm.get("outboundUserid");
        if (((Boolean)hm.get("TBD")).booleanValue()) {
            this.setToBeDeleted(true);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restorePersistentLinkData");
        }
    }

    @Override
    public void xmlWriteOn(FormattedWriter writer) throws IOException {
        super.xmlWriteOn(writer);
        writer.newLine();
        writer.taggedValue("busName", (Object)this._busName);
        writer.newLine();
        writer.taggedValue("type", (Object)this._type);
        writer.newLine();
        writer.taggedValue("userIds", (Object)(this._inboundUserid + "," + this._outboundUserid));
    }

    public void updateUuid(SIBUuid12 uuid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateUuid", (Object)uuid);
        }
        this._uuid = uuid;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateUuid");
        }
    }

    public void updateLinkDefinition(VirtualLinkDefinition virtualLinkDefinition, LocalTransaction transaction) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateLinkDefinition", (Object)virtualLinkDefinition);
        }
        this._outboundUserid = virtualLinkDefinition.getOutboundUserid();
        this._inboundUserid = virtualLinkDefinition.getInboundUserid();
        this._exceptionDestination = virtualLinkDefinition.getExceptionDestination();
        this._preferLocal = virtualLinkDefinition.getPreferLocal();
        ForeignBusDefinition busDef = virtualLinkDefinition.getForeignBus();
        if (busDef != null) {
            this._busName = busDef.getName();
        }
        Transaction msTran = this.messageProcessor.resolveAndEnlistMsgStoreTransaction((TransactionCommon)transaction);
        try {
            this.requestUpdate(msTran);
            this.registerControlAdapters();
        }
        catch (MessageStoreException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateLinkDefinition");
        }
    }

    @Override
    public OutputHandler choosePtoPOutputHandler(SIBUuid8 fixedMEUuid, SIBUuid8 preferredMEUuid, boolean localMessage, boolean forcePut, HashSet<SIBUuid8> scopedMEs) throws SIRollbackException, SIConnectionLostException, SIResourceException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"choosePtoPOutputHandler", (Object)new Object[]{fixedMEUuid, preferredMEUuid, localMessage, forcePut, scopedMEs});
        }
        OutputHandler result = this.getLinkStateHandler().choosePtoPOutputHandler(this.getUuid());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"choosePtoPOutputHandler", (Object)result);
        }
        return result;
    }

    @Override
    public int checkPtoPOutputHandlers(SIBUuid8 fixedMEUuid, HashSet<SIBUuid8> scopedMEs) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkPtoPOutputHandlers", (Object)new Object[]{fixedMEUuid, scopedMEs});
        }
        int result = super.checkPtoPOutputHandlers(null, null);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkPtoPOutputHandlers", (Object)result);
        }
        return result;
    }

    @Override
    public void createControlAdapter() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createControlAdapter");
        }
        this.controlAdapter = new VirtualLinkControl(this.messageProcessor, this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createControlAdapter");
        }
    }

    @Override
    public void registerControlAdapterAsMBean() {
    }

    @Override
    public void deregisterControlAdapterMBean() {
    }

    void initializeNonPersistent(MessageProcessor messageProcessor, HashMap durableSubscriptionsTable, TransactionCommon transaction) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initializeNonPersistent", (Object)new Object[]{messageProcessor, durableSubscriptionsTable, transaction});
        }
        super.initializeNonPersistent(messageProcessor, durableSubscriptionsTable, transaction);
        this.getLinkStateHandler().setLinkManager(messageProcessor.getLinkManager());
        DestinationDefinition linkDestDefinition = messageProcessor.createDestinationDefinition(DestinationType.QUEUE, this._name);
        linkDestDefinition.setMaxReliability(Reliability.ASSURED_PERSISTENT);
        linkDestDefinition.setDefaultReliability(Reliability.ASSURED_PERSISTENT);
        this.updateDefinition((BaseDestinationDefinition)linkDestDefinition);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initializeNonPersistent");
        }
    }

    @Override
    void registerDestination() {
    }

    @Override
    void deregisterDestination() {
    }

    public String getType() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getType");
            SibTr.exit((TraceComponent)tc, (String)"getType", (Object)this._type);
        }
        return this._type;
    }

    public String getInboundUserid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getInboundUserid");
            SibTr.exit((TraceComponent)tc, (String)"getInboundUserid", (Object)this._inboundUserid);
        }
        return this._inboundUserid;
    }

    public String getOutboundUserid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getOutboundUserid");
            SibTr.exit((TraceComponent)tc, (String)"getOutboundUserid", (Object)this._outboundUserid);
        }
        return this._outboundUserid;
    }

    public String getBusName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBusName");
            SibTr.exit((TraceComponent)tc, (String)"getBusName", (Object)this._busName);
        }
        return this._busName;
    }

    @Override
    public void updateGetRegistration(boolean advertise) {
    }

    @Override
    public void updatePostRegistration(boolean advertise) {
    }

    @Override
    public void updatePreRegistration(boolean advertise) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestReallocation() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"requestReallocation");
        }
        if (!this.isCorruptOrIndoubt()) {
            LinkHandler linkHandler = this;
            synchronized (linkHandler) {
                this._isToBeReallocated = true;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"requestReallocation", (Object)"Have set reallocation flag");
                }
            }
            this.destinationManager.getLinkIndex().cleanup(this);
            this.destinationManager.startAsynchDeletion();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"requestReallocation");
        }
    }

    public LinkState getLinkStateHandler() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLinkStateHandler", (Object)this);
        }
        if (this._linkState == null) {
            this._linkState = (LinkState)this._protoRealization;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getLinkStateHandler", (Object)this._linkState);
        }
        return this._linkState;
    }

    protected void reconstitute(MessageProcessor processor, HashMap durableSubscriptionsTable, int startMode) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reconstitute", (Object)new Object[]{processor, durableSubscriptionsTable, new Integer(startMode)});
        }
        this.getLocalisationManager().setMessageProcessor(processor);
        super.reconstitute(processor, durableSubscriptionsTable, startMode);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reconstitute");
        }
    }

    public Iterator getLinkRemoteQueuePoints() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLinkRemoteQueuePoints");
        }
        Iterator<PtoPMessageItemStream> it = this._localisationManager.getXmitQueueIterator();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getLinkRemoteQueuePoints", it);
        }
        return it;
    }

    public boolean preferLocalTargetQueuePoint() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"preferLocalTargetQueuePoint");
            SibTr.exit((TraceComponent)tc, (String)"preferLocalTargetQueuePoint", (Object)this._preferLocal);
        }
        return this._preferLocal;
    }

    public SIMPLinkRemoteMessagePointControllable getLinkRemoteQueuePointControl() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLinkRemoteQueuePointControl");
        }
        SIMPLinkRemoteMessagePointControllable rqp = null;
        Iterator it = this.getLinkRemoteQueuePoints();
        if (it.hasNext()) {
            rqp = (SIMPLinkRemoteMessagePointControllable)((PtoPXmitMsgsItemStream)it.next()).getControlAdapter();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getLinkRemoteQueuePointControl", (Object)rqp);
        }
        return rqp;
    }

    @Override
    public String getExceptionDestination() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getExceptionDestination");
            SibTr.exit((TraceComponent)tc, (String)"getExceptionDestination", (Object)this._exceptionDestination);
        }
        return this._exceptionDestination;
    }

    @Override
    public Reliability getExceptionDiscardReliability() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getExceptionDiscardReliability");
            SibTr.exit((TraceComponent)tc, (String)"getExceptionDiscardReliability", (Object)this._exceptionDiscardReliability);
        }
        return this._exceptionDiscardReliability;
    }
}

