/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.matchspace.Selector;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.Filter;
import com.ibm.ws.sib.msgstore.LockingCursor;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.JSConsumerClassifications;
import com.ibm.ws.sib.processor.impl.JSConsumerSet;
import com.ibm.ws.sib.processor.impl.LocalQPConsumerKey;
import com.ibm.ws.sib.processor.impl.LocalQPConsumerKeyFilter;
import com.ibm.ws.sib.processor.impl.interfaces.ConsumableKey;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.DispatchableConsumerPoint;
import com.ibm.ws.sib.processor.impl.interfaces.DispatchableKey;
import com.ibm.ws.sib.processor.impl.interfaces.JSConsumerKey;
import com.ibm.ws.sib.processor.impl.interfaces.JSConsumerManager;
import com.ibm.ws.sib.processor.impl.interfaces.JSKeyGroup;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.processor.utils.linkedlist.SimpleEntry;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;

public class LocalQPConsumerKeyGroup
extends SimpleEntry
implements JSKeyGroup,
Filter,
DispatchableKey {
    private static final TraceComponent tc = SibTr.register(LocalQPConsumerKeyGroup.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private ReentrantLock _lock;
    private boolean ready;
    private boolean specificReady;
    private boolean groupReady;
    private long version;
    private int memberCount;
    private int startedCount;
    private int generalMemberCount;
    private LocalQPConsumerKey singleMember;
    private ArrayList<LocalQPConsumerKey> generalKeyMembers;
    private ArrayList<LocalQPConsumerKey> specificKeyMembers;
    private int generalMemberIndex;
    private JSConsumerManager consumerDispatcher;
    private SIBUuid12 connectionUuid;
    private boolean currentMatch;
    private LocalQPConsumerKey currentMatchingMember;
    private ConsumableKey msgAttachedMember;
    protected Object asynchGroupLock;
    private boolean consumerThreadActive = false;
    private long consumerThreadID = 0L;
    private boolean classifyingMessages = false;
    private JSConsumerSet consumerSet = null;
    private LocalQPConsumerKeyFilter[] consumerKeyFilter = null;
    private boolean pendingFlowReset = false;

    public LocalQPConsumerKeyGroup(ConsumerDispatcher consumerDispatcher, JSConsumerSet consumerSet) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"LocalQPConsumerKeyGroup", (Object)new Object[]{consumerDispatcher, consumerSet});
        }
        this._lock = new ReentrantLock();
        if (consumerDispatcher.isPubSub()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"LocalQPConsumerKeyGroup", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.LocalQPConsumerKeyGroup", "1:156:1.6.1.14"}, null));
        }
        this.consumerSet = consumerSet;
        if (consumerSet != null) {
            this.classifyingMessages = true;
            consumerSet.registerKey(this);
        }
        this.ready = false;
        this.groupReady = false;
        this.version = 0L;
        this.generalKeyMembers = null;
        this.specificKeyMembers = null;
        this.consumerDispatcher = consumerDispatcher;
        this.connectionUuid = null;
        this.memberCount = 0;
        this.startedCount = 0;
        this.generalMemberCount = 0;
        this.asynchGroupLock = new Object();
        this.singleMember = null;
        this.msgAttachedMember = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"LocalQPConsumerKeyGroup", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMember(JSConsumerKey key) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addMember", (Object)key);
        }
        this.lock();
        try {
            if (this.connectionUuid == null) {
                this.connectionUuid = key.getConnectionUuid();
            } else if (!this.connectionUuid.equals((Object)key.getConnectionUuid())) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"addMember", (Object)"SIErrorException");
                }
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.LocalQPConsumerKeyGroup", "1:216:1.6.1.14"}, null));
            }
            if (key.getForwardScanning()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"addMember", (Object)"SIErrorException");
                }
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.LocalQPConsumerKeyGroup", "1:242:1.6.1.14"}, null));
            }
            try {
                if (this.consumerKeyFilter != null) {
                    if (this.classifyingMessages) {
                        this.consumerSet.takeClassificationReadLock();
                        int numFilters = this.consumerKeyFilter.length;
                        for (int i = 0; i < numFilters; ++i) {
                            this.consumerKeyFilter[i].discard();
                        }
                        this.createNewFiltersAndCursors();
                        this.consumerSet.freeClassificationReadLock();
                    } else {
                        this.consumerKeyFilter[0].discard();
                        this.createNewFiltersAndCursors();
                    }
                } else if (this.classifyingMessages) {
                    this.consumerSet.takeClassificationReadLock();
                    this.createNewFiltersAndCursors();
                    this.consumerSet.freeClassificationReadLock();
                } else {
                    this.createNewFiltersAndCursors();
                }
            }
            catch (MessageStoreException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.LocalQPConsumerKeyGroup.addMember", (String)"1:307:1.6.1.14", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                SIResourceException newE = new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.LocalQPConsumerKeyGroup", "1:317:1.6.1.14", e}, null), (Throwable)e);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"addMember", (Object)((Object)newE));
                }
                throw newE;
            }
            Object object = this.consumerDispatcher.getDestination().getReadyConsumerPointLock();
            synchronized (object) {
                if (this.ready) {
                    this.ready = false;
                    this.consumerDispatcher.removeReadyConsumer(this, this.specificReady);
                }
            }
            if (this.memberCount == 0) {
                this.singleMember = (LocalQPConsumerKey)key;
                if (!key.isSpecific()) {
                    ++this.generalMemberCount;
                }
            } else {
                if (this.singleMember != null) {
                    if (this.generalMemberCount == 1) {
                        this.addMemberToList(this.singleMember, false);
                    } else {
                        this.addMemberToList(this.singleMember, true);
                    }
                    this.singleMember = null;
                }
                if (key.isSpecific()) {
                    this.addMemberToList(key, true);
                } else {
                    ++this.generalMemberCount;
                    this.addMemberToList(key, false);
                }
            }
            ++this.memberCount;
        }
        finally {
            this.unlock();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addMember", (Object)this.memberCount);
        }
    }

    private void addMemberToList(JSConsumerKey key, boolean specificList) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addMemberToList", (Object)new Object[]{key, specificList});
        }
        if (specificList) {
            if (this.specificKeyMembers == null) {
                this.specificKeyMembers = new ArrayList();
            }
            this.specificKeyMembers.add((LocalQPConsumerKey)key);
        } else {
            if (this.generalKeyMembers == null) {
                this.generalKeyMembers = new ArrayList();
            }
            this.generalKeyMembers.add((LocalQPConsumerKey)key);
            this.generalMemberIndex = 0;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addMemberToList");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void removeMember(JSConsumerKey key) {
        LocalQPConsumerKey anyKey;
        block16: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"removeMember", (Object)key);
            }
            anyKey = null;
            Object object = this.consumerDispatcher.getDestination().getReadyConsumerPointLock();
            // MONITORENTER : object
            if (this.singleMember != null) {
                if (!key.isSpecific()) {
                    --this.generalMemberCount;
                }
                if (this.singleMember == key) {
                    this.singleMember = null;
                    break block16;
                } else {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEntryEnabled()) throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.LocalQPConsumerKeyGroup", "1:453:1.6.1.14"}, null));
                    SibTr.exit((TraceComponent)tc, (String)"removeMember", (Object)"SIErrorException");
                    throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.LocalQPConsumerKeyGroup", "1:453:1.6.1.14"}, null));
                }
            }
            if (key.isSpecific()) {
                this.specificKeyMembers.remove(key);
            } else {
                this.generalKeyMembers.remove(key);
                --this.generalMemberCount;
                this.generalMemberIndex = 0;
            }
        }
        --this.memberCount;
        if (this.memberCount == 0) {
            this.consumerDispatcher.removeKeyGroup(this);
            if (this.classifyingMessages) {
                this.consumerSet.takeClassificationReadLock();
                int numFilters = this.consumerKeyFilter.length;
                for (int i = 0; i < numFilters; ++i) {
                    this.consumerKeyFilter[i].detach();
                }
                this.consumerSet.freeClassificationReadLock();
            } else {
                this.consumerKeyFilter[0].detach();
            }
        } else if (this.memberCount == this.startedCount) {
            anyKey = this.generalMemberCount > 0 ? this.generalKeyMembers.get(0) : this.specificKeyMembers.get(0);
        }
        // MONITOREXIT : object
        if (anyKey != null) {
            anyKey.getConsumerPoint().checkForMessages();
        }
        if (!TraceComponent.isAnyTracingEnabled()) return;
        if (!tc.isEntryEnabled()) return;
        SibTr.exit((TraceComponent)tc, (String)"removeMember");
    }

    @Override
    public void startMember() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"startMember");
            SibTr.exit((TraceComponent)tc, (String)"startMember", (Object)new Object[]{this.startedCount, this.memberCount});
        }
        ++this.startedCount;
    }

    @Override
    public void stopMember() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stopMember");
            SibTr.exit((TraceComponent)tc, (String)"stopMember", (Object)new Object[]{this.startedCount, this.memberCount});
        }
        --this.startedCount;
    }

    @Override
    public boolean isStarted() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isStarted", (Object)new Object[]{this.startedCount, this.memberCount});
        }
        if (this.startedCount == this.memberCount) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"isStarted", (Object)true);
            }
            return true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isStarted", (Object)false);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ready(Reliability unrecoverableReliability) throws SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"ready");
        }
        Object object = this.consumerDispatcher.getDestination().getReadyConsumerPointLock();
        synchronized (object) {
            if (!this.ready && this.startedCount == this.memberCount) {
                this.ready = true;
                this.specificReady = this.generalMemberCount == 0;
                this.version = this.consumerDispatcher.newReadyConsumer(this, this.specificReady);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"ready");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notReady() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"notReady");
        }
        Object object = this.consumerDispatcher.getDestination().getReadyConsumerPointLock();
        synchronized (object) {
            if (this.ready) {
                this.ready = false;
                this.consumerDispatcher.removeReadyConsumer(this, this.specificReady);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"notReady");
        }
    }

    @Override
    public void markNotReady() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"markNotReady");
            SibTr.exit((TraceComponent)tc, (String)"markNotReady");
        }
        this.ready = false;
    }

    @Override
    public boolean isKeyReady() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isKeyReady");
            SibTr.exit((TraceComponent)tc, (String)"isKeyReady", (Object)this.ready);
        }
        return this.ready;
    }

    @Override
    public long getVersion() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getVersion");
            SibTr.exit((TraceComponent)tc, (String)"getVersion", (Object)this.version);
        }
        return this.version;
    }

    @Override
    public LocalQPConsumerKey resolvedKey() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resolvedKey");
        }
        LocalQPConsumerKey key = null;
        if (this.generalMemberCount > 0) {
            if (this.singleMember != null) {
                key = this.singleMember;
            } else {
                key = this.generalKeyMembers.get(this.generalMemberIndex);
                if (++this.generalMemberIndex == this.generalMemberCount) {
                    this.generalMemberIndex = 0;
                }
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"resolvedKey", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.LocalQPConsumerKeyGroup", "1:688:1.6.1.14"}, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resolvedKey", (Object)key);
        }
        return key;
    }

    @Override
    public void groupReady() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"groupReady", (Object)this.groupReady);
        }
        if (this.startedCount == this.memberCount) {
            this.groupReady = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"groupReady", (Object)this.groupReady);
        }
    }

    @Override
    public void groupNotReady() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"groupNotReady", (Object)this.groupReady);
            SibTr.exit((TraceComponent)tc, (String)"groupNotReady");
        }
        this.groupReady = false;
    }

    @Override
    public boolean isGroupReady() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isGroupReady");
            SibTr.exit((TraceComponent)tc, (String)"isGroupReady", (Object)this.groupReady);
        }
        return this.groupReady;
    }

    @Override
    public LockingCursor getDefaultGetCursor() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDefaultGetCursor");
        }
        LockingCursor cursor = this.consumerKeyFilter[0].getGetCursor();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDefaultGetCursor", (Object)cursor);
        }
        return cursor;
    }

    @Override
    public LockingCursor getGetCursor(int classification) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getGetCursor", (Object)classification);
        }
        if (this.pendingFlowReset) {
            this.pendingFlowReset = false;
            this.resetFlowProperties();
        }
        LockingCursor cursor = this.consumerKeyFilter[classification].getGetCursor();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getGetCursor", (Object)cursor);
        }
        return cursor;
    }

    @Override
    public LockingCursor getGetCursor(SIMPMessage msg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getGetCursor");
        }
        this.consumerSet.takeClassificationReadLock();
        if (this.pendingFlowReset) {
            this.pendingFlowReset = false;
            this.resetFlowProperties();
        }
        LockingCursor cursor = this.consumerKeyFilter[0].getGetCursor();
        this.consumerSet.freeClassificationReadLock();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getGetCursor", (Object)cursor);
        }
        return cursor;
    }

    @Override
    public SIBUuid12 getConnectionUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getConnectionUuid");
            SibTr.exit((TraceComponent)tc, (String)"getConnectionUuid", (Object)this.connectionUuid);
        }
        return this.connectionUuid;
    }

    @Override
    public boolean getForwardScanning() {
        return false;
    }

    @Override
    public void setConsumerActive(boolean active) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setConsumerActive", (Object)active);
        }
        this.consumerThreadID = active ? Thread.currentThread().getId() : 0L;
        this.consumerThreadActive = active;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setConsumerActive", (Object)this.consumerThreadID);
        }
    }

    public boolean filterMatches(AbstractItem item) {
        boolean onConsumerThread;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"filterMatches", (Object)item);
        }
        boolean match = false;
        LocalQPConsumerKey matchingMember = null;
        if (this.generalMemberCount > 0) {
            matchingMember = null;
            match = true;
        } else if (this.singleMember != null) {
            if (this.singleMember.filterMatches(item)) {
                match = true;
                matchingMember = this.singleMember;
            }
        } else {
            int size = this.specificKeyMembers.size();
            for (int index = 0; index < size && !match; ++index) {
                LocalQPConsumerKey keyMember = this.specificKeyMembers.get(index);
                if (!keyMember.filterMatches(item)) continue;
                match = true;
                matchingMember = keyMember;
            }
        }
        boolean bl = onConsumerThread = this.consumerThreadActive && Thread.currentThread().getId() == this.consumerThreadID;
        if (onConsumerThread) {
            this.currentMatch = match;
            this.currentMatchingMember = matchingMember;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"filterMatches", (Object)new Object[]{match, matchingMember});
        }
        return match;
    }

    @Override
    public ConsumableKey getMatchingMember(ConsumableKey preferedKey) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMatchingMember");
        }
        ConsumableKey key = null;
        if (this.currentMatch) {
            if (this.currentMatchingMember == null) {
                if (!preferedKey.isSpecific()) {
                    key = preferedKey;
                } else if (this.generalMemberCount > 0) {
                    key = this.resolvedKey();
                }
            } else {
                key = this.currentMatchingMember;
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getMatchingMember", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.LocalQPConsumerKeyGroup", "1:982:1.6.1.14"}, null));
        }
        if (key == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getMatchingMember", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.LocalQPConsumerKeyGroup", "1:995:1.6.1.14"}, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMatchingMember", (Object)key);
        }
        return key;
    }

    @Override
    public void attachMessage(ConsumableKey consumerKey) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"attachMessage", (Object)this.msgAttachedMember);
            SibTr.exit((TraceComponent)tc, (String)"attachMessage", (Object)consumerKey);
        }
        if (this.msgAttachedMember != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"attachMessage", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.LocalQPConsumerKeyGroup", "1:1027:1.6.1.14"}, null));
        }
        this.msgAttachedMember = consumerKey;
    }

    @Override
    public ConsumableKey getAttachedMember() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAttachedMember");
            SibTr.exit((TraceComponent)tc, (String)"getAttachedMember", (Object)this.msgAttachedMember);
        }
        ConsumableKey key = this.msgAttachedMember;
        this.msgAttachedMember = null;
        return key;
    }

    @Override
    public JSConsumerManager getConsumerManager() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getConsumerManager");
            SibTr.exit((TraceComponent)tc, (String)"getConsumerManager", (Object)this.consumerDispatcher);
        }
        return this.consumerDispatcher;
    }

    @Override
    public boolean isSpecific() {
        return false;
    }

    @Override
    public DispatchableConsumerPoint getConsumerPoint() {
        return null;
    }

    @Override
    public JSConsumerKey getParent() {
        return null;
    }

    @Override
    public Selector getSelector() {
        return null;
    }

    @Override
    public void notifyConsumerPointAboutException(SIException e) {
    }

    @Override
    public void notifyReceiveAllowed(boolean newReceiveAllowed, DestinationHandler handler) {
    }

    @Override
    public boolean requiresRecovery(SIMPMessage message) throws SIResourceException {
        return false;
    }

    @Override
    public Object getAsynchGroupLock() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAsynchGroupLock");
            SibTr.exit((TraceComponent)tc, (String)"getAsynchGroupLock", (Object)this.asynchGroupLock);
        }
        return this.asynchGroupLock;
    }

    private void createNewFiltersAndCursors() throws SIResourceException, MessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createNewFiltersAndCursors");
        }
        LockingCursor cursor = null;
        if (this.classifyingMessages) {
            JSConsumerClassifications classifications = this.consumerSet.getClassifications();
            int numClasses = classifications.getNumberOfClasses();
            this.consumerKeyFilter = new LocalQPConsumerKeyFilter[numClasses + 1];
            for (int i = 0; i < numClasses + 1; ++i) {
                String classificationName = null;
                if (i > 0) {
                    classificationName = classifications.getClassification(i);
                }
                this.consumerKeyFilter[i] = new LocalQPConsumerKeyFilter(this, i, classificationName);
                cursor = ((ConsumerDispatcher)this.consumerDispatcher).getItemStream().newLockingItemCursor((Filter)this.consumerKeyFilter[i]);
                this.consumerKeyFilter[i].setLockingCursor(cursor);
            }
        } else {
            this.consumerKeyFilter = new LocalQPConsumerKeyFilter[1];
            this.consumerKeyFilter[0] = new LocalQPConsumerKeyFilter(this, 0, null);
            cursor = ((ConsumerDispatcher)this.consumerDispatcher).getItemStream().newLockingItemCursor((Filter)this.consumerKeyFilter[0]);
            this.consumerKeyFilter[0].setLockingCursor(cursor);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createNewFiltersAndCursors");
        }
    }

    public void notifyResetFlowProperties() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"notifyResetFlowProperties");
        }
        this.pendingFlowReset = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"notifyResetFlowProperties");
        }
    }

    private void resetFlowProperties() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resetFlowProperties");
        }
        int numFilters = this.consumerKeyFilter.length;
        for (int i = 0; i < numFilters; ++i) {
            this.consumerKeyFilter[i].discard();
        }
        try {
            this.createNewFiltersAndCursors();
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.sib.processor.impl.LocalQPConsumerKeyGroup.resetFlowProperties", (String)"1:1197:1.6.1.14", (Object)this);
            SIErrorException finalE = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.LocalQPConsumerKeyGroup", "1:1204:1.6.1.14", ex}, null), (Throwable)ex);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.LocalQPConsumerKeyGroup", "1:1210:1.6.1.14", SIMPUtils.getStackTrace(ex)});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"resetFlowProperties", (Object)((Object)finalE));
            }
            throw finalE;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resetFlowProperties");
        }
    }

    public boolean hasNonSpecificConsumers() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"hasNonSpecificConsumers");
        }
        boolean value = this.generalMemberCount > 0;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"hasNonSpecificConsumers", (Object)value);
        }
        return value;
    }

    @Override
    public void lock() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"lock");
        }
        this._lock.lock();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"lock");
        }
    }

    @Override
    public void unlock() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"unlock");
        }
        this._lock.unlock();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"unlock");
        }
    }
}

