/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.store.items;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.ItemStream;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.SevereMessageStoreException;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.impl.interfaces.ControllableResource;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.store.items.SIMPItem;
import com.ibm.ws.sib.processor.impl.store.itemstreams.AOProtocolItemStream;
import com.ibm.ws.sib.processor.runtime.impl.ControlAdapter;
import com.ibm.ws.sib.processor.runtime.impl.QueuedMessage;
import com.ibm.ws.sib.processor.utils.am.BatchedTimeoutEntry;
import com.ibm.ws.sib.processor.utils.am.BatchedTimeoutManager;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public final class AOValue
extends SIMPItem
implements BatchedTimeoutEntry,
ControllableResource {
    private static final TraceComponent tc = SibTr.register(AOValue.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final int PERSISTENT_VERSION = 2;
    private long tick;
    private long msgId;
    private int storagePolicy;
    private long plockId;
    private long waitTime;
    private long prevTick;
    private SIBUuid8 sourceMEUuid;
    private int reliability = -1;
    private int priority = -1;
    private BatchedTimeoutManager.LinkedListEntry entry;
    private ControlAdapter controlAdapter;
    private long aiRequestTick;
    private boolean isFlushing;
    public boolean removing;
    public boolean restored = true;
    public long rmeUnlockCount;

    public AOValue(long tick, SIMPMessage msg, long msgId, int storagePolicy, long plockId, long waitTime, long prevTick) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AOValue", (Object)new Object[]{tick, msg, msgId, storagePolicy, plockId, waitTime, prevTick});
        }
        this.tick = tick;
        this.msgId = msgId;
        this.reliability = msg.getMessage().getReliability().getIndex();
        this.priority = msg.getMessage().getPriority();
        this.sourceMEUuid = msg.getLocalisingMEUuid();
        this.aiRequestTick = msg.getMessage().getGuaranteedRemoteGetValueTick();
        this.storagePolicy = storagePolicy;
        this.plockId = plockId;
        this.waitTime = waitTime;
        this.prevTick = prevTick;
        this.removing = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AOValue", (Object)this);
        }
    }

    public AOValue() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AOValue");
            SibTr.exit((TraceComponent)tc, (String)"AOValue", (Object)this);
        }
        this.removing = false;
    }

    public final long getTick() {
        return this.tick;
    }

    public final long getMsgId() {
        return this.msgId;
    }

    public final long getPLockId() {
        return this.plockId;
    }

    public final long getWaitTime() {
        return this.waitTime;
    }

    public final long getPrevTick() {
        return this.prevTick;
    }

    @Override
    public BatchedTimeoutManager.LinkedListEntry getEntry() {
        return this.entry;
    }

    @Override
    public void setEntry(BatchedTimeoutManager.LinkedListEntry entry) {
        this.entry = entry;
    }

    @Override
    public void cancel() {
    }

    public long getMaximumTimeInStore() {
        return -2L;
    }

    @Override
    public int getPersistentVersion() {
        return 2;
    }

    @Override
    public void getPersistentData(ObjectOutputStream dout) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPersistentData", (Object)dout);
        }
        try {
            dout.writeLong(this.tick);
            dout.writeLong(this.msgId);
            dout.writeInt(this.storagePolicy);
            dout.writeLong(this.plockId);
            dout.writeLong(this.prevTick);
            dout.writeLong(this.waitTime);
            dout.writeInt(this.priority);
            dout.writeInt(this.reliability);
            dout.writeLong(this.aiRequestTick);
            dout.writeUTF(this.sourceMEUuid.toString());
        }
        catch (IOException e) {
            SIErrorException e2 = new SIErrorException((Throwable)e);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getPersistentData", (Object)((Object)e2));
            }
            throw e2;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPersistentData");
        }
    }

    public int getStorageStrategy() {
        return this.storagePolicy;
    }

    @Override
    public void restore(ObjectInputStream din, int dataVersion) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restore", (Object)new Object[]{din, dataVersion});
        }
        this.checkPersistentVersionId(dataVersion);
        try {
            this.tick = din.readLong();
            this.msgId = din.readLong();
            this.storagePolicy = din.readInt();
            this.plockId = din.readLong();
            this.prevTick = din.readLong();
            this.waitTime = din.readLong();
            if (dataVersion >= 2) {
                this.priority = din.readInt();
                this.reliability = din.readInt();
                this.aiRequestTick = din.readLong();
                this.sourceMEUuid = new SIBUuid8(din.readUTF());
            }
        }
        catch (Exception e) {
            SIErrorException e2 = new SIErrorException((Throwable)e);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"restore", (Object)((Object)e2));
            }
            throw e2;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restore");
        }
    }

    public void eventPostRollbackRemove(Transaction transaction) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostRollbackRemove", (Object)transaction);
        }
        super.eventPostRollbackRemove(transaction);
        try {
            this.unlock(this.getLockID());
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.items.AOValue.eventPostRollbackRemove", (String)"1:337:1.28.1.5", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostRollbackRemove");
        }
    }

    @Override
    public void createControlAdapter() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createControlAdapter");
        }
        DestinationHandler dh = null;
        try {
            ItemStream is = this.getItemStream();
            dh = ((AOProtocolItemStream)is).getDestinationHandler();
            SIMPMessage msg = (SIMPMessage)is.findById(this.msgId);
            this.controlAdapter = new QueuedMessage(msg, dh, is);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.items.AOValue.createControlAdapter", (String)"1:371:1.28.1.5", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createControlAdapter");
        }
    }

    @Override
    public void dereferenceControlAdapter() {
    }

    @Override
    public void deregisterControlAdapterMBean() {
    }

    @Override
    public ControlAdapter getControlAdapter() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getControlAdapter");
        }
        if (this.controlAdapter == null) {
            this.createControlAdapter();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getControlAdapter", (Object)this.controlAdapter);
        }
        return this.controlAdapter;
    }

    @Override
    public void registerControlAdapterAsMBean() {
    }

    public SIBUuid8 getSourceMEUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSourceMEUuid");
            SibTr.exit((TraceComponent)tc, (String)"getSourceMEUuid", (Object)this.sourceMEUuid);
        }
        return this.sourceMEUuid;
    }

    public void setMsgId(long msgId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setMsgId", (Object)msgId);
        }
        this.msgId = msgId;
        this.restored = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setMsgId");
        }
    }

    public void setPLockId(long lockID) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setPLockId", (Object)lockID);
        }
        this.plockId = lockID;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setPLockId");
        }
    }

    public long getAIRequestTick() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAIRequestTick");
            SibTr.exit((TraceComponent)tc, (String)"getAIRequestTick", (Object)this.aiRequestTick);
        }
        return this.aiRequestTick;
    }

    public int getMsgPriority() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMsgPriority");
            SibTr.exit((TraceComponent)tc, (String)"getMsgPriority", (Object)this.priority);
        }
        return this.priority;
    }

    public int getMsgReliability() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMsgReliability");
            SibTr.exit((TraceComponent)tc, (String)"getMsgReliability", (Object)this.reliability);
        }
        return this.reliability;
    }

    public void setToBeFlushed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setToBeFlushed");
            SibTr.exit((TraceComponent)tc, (String)"setToBeFlushed");
        }
        this.isFlushing = true;
    }

    public boolean isFlushing() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isFlushing");
            SibTr.exit((TraceComponent)tc, (String)"isFlushing", (Object)this.isFlushing);
        }
        return this.isFlushing;
    }

    public void xmlWriteOn(FormattedWriter writer) throws IOException {
        writer.newLine();
        writer.taggedValue("referencedMsg", this.msgId);
        writer.newLine();
        writer.taggedValue("AOTicks", (Object)(this.tick + "," + this.prevTick));
        writer.newLine();
        writer.taggedValue("gatheredMEUuid", (Object)this.sourceMEUuid);
    }

    public String toString() {
        return super.toString() + "[" + this.msgId + ", " + this.sourceMEUuid + ", " + this.tick + ", " + this.prevTick + "]";
    }

    public boolean isRestored() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isRestored");
            SibTr.exit((TraceComponent)tc, (String)"isRestored", (Object)this.restored);
        }
        return this.restored;
    }
}

