/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.Controllable;
import com.ibm.ws.sib.admin.ControllableRegistrationService;
import com.ibm.ws.sib.admin.ControllableType;
import com.ibm.ws.sib.admin.RuntimeEvent;
import com.ibm.ws.sib.admin.RuntimeEventListener;
import com.ibm.ws.sib.admin.SIBExceptionInvalidValue;
import com.ibm.ws.sib.admin.exception.AlreadyRegisteredException;
import com.ibm.ws.sib.admin.exception.NotRegisteredException;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.runtime.impl.AbstractControlAdapter;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.utils.ras.SibTr;

public abstract class AbstractRegisteredControlAdapter
extends AbstractControlAdapter
implements Controllable {
    private static TraceComponent tc = SibTr.register(AbstractRegisteredControlAdapter.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private RuntimeEventListener _runtimeEventListener = null;
    private boolean _isRegistered = false;
    private MessageProcessor _messageProcessor = null;
    private ControllableType _type = null;

    public AbstractRegisteredControlAdapter(MessageProcessor messageProcessor, ControllableType type) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AbstractRegisteredControlAdapter", (Object)new Object[]{messageProcessor, type});
        }
        this._messageProcessor = messageProcessor;
        this._type = type;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AbstractRegisteredControlAdapter", (Object)this);
        }
    }

    protected RuntimeEventListener getRuntimeEventListener() {
        return this._runtimeEventListener;
    }

    protected MessageProcessor getMessageProcessor() {
        return this._messageProcessor;
    }

    protected boolean isRegistered() {
        return this._isRegistered;
    }

    protected void setType(ControllableType type) {
        this._type = type;
    }

    @Override
    public synchronized void registerControlAdapterAsMBean() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerControlAdapterAsMBean", (Object)this);
        }
        if (!this._isRegistered) {
            ControllableRegistrationService regService = (ControllableRegistrationService)this._messageProcessor.getMEInstance("JsMBeanFactory");
            if (regService == null) {
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{AbstractRegisteredControlAdapter.class, "1:128:1.9"});
            } else {
                try {
                    this._runtimeEventListener = regService.register((Controllable)this, this._type);
                    this._isRegistered = true;
                }
                catch (AlreadyRegisteredException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.AbstractRegisteredControlAdapter.registerControlAdapterAsMBean", (String)"1:145:1.9", (Object)this);
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.runtime.AbstractRegisteredControlAdapter.registerControlAdapterAsMBean", "1:150:1.9", SIMPUtils.getStackTrace(e)});
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                }
                catch (SIBExceptionInvalidValue e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.AbstractRegisteredControlAdapter.registerControlAdapterAsMBean", (String)"1:160:1.9", (Object)this);
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.runtime.AbstractRegisteredControlAdapter.registerControlAdapterAsMBean", "1:165:1.9", SIMPUtils.getStackTrace(e)});
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.AbstractRegisteredControlAdapter.registerControlAdapterAsMBean", (String)"1:175:1.9", (Object)this);
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.runtime.AbstractRegisteredControlAdapter.registerControlAdapterAsMBean", "1:180:1.9", SIMPUtils.getStackTrace(e)});
                    SibTr.exception((TraceComponent)tc, (Exception)e);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerControlAdapterAsMBean");
        }
    }

    @Override
    public synchronized void deregisterControlAdapterMBean() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deregisterControlAdapterMBean", (Object)this);
        }
        if (this._isRegistered) {
            ControllableRegistrationService regService = (ControllableRegistrationService)this._messageProcessor.getMEInstance("JsMBeanFactory");
            if (regService == null) {
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{AbstractRegisteredControlAdapter.class, "1:208:1.9"});
            } else {
                try {
                    regService.deregister((Controllable)this, this._type);
                    this._isRegistered = false;
                    this._runtimeEventListener = null;
                }
                catch (NotRegisteredException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.AbstractRegisteredControlAdapter.deregisterControlAdapterMBean", (String)"1:228:1.9", (Object)this);
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.runtime.AbstractRegisteredControlAdapter.deregisterControlAdapterMBean", "1:233:1.9", SIMPUtils.getStackTrace(e)});
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                }
                catch (SIBExceptionInvalidValue e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.AbstractRegisteredControlAdapter.deregisterControlAdapterMBean", (String)"1:243:1.9", (Object)this);
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.runtime.AbstractRegisteredControlAdapter.deregisterControlAdapterMBean", "1:248:1.9", SIMPUtils.getStackTrace(e)});
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.AbstractRegisteredControlAdapter.deregisterControlAdapterMBean", (String)"1:258:1.9", (Object)this);
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.runtime.AbstractRegisteredControlAdapter.deregisterControlAdapterMBean", "1:263:1.9", SIMPUtils.getStackTrace(e)});
                    SibTr.exception((TraceComponent)tc, (Exception)e);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deregisterControlAdapterMBean");
        }
    }

    @Override
    public void dereferenceControllable() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dereferenceControllable");
        }
        if (this._isRegistered) {
            this.deregisterControlAdapterMBean();
        }
        this._messageProcessor = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dereferenceControllable");
        }
    }

    @Override
    public synchronized void runtimeEventOccurred(RuntimeEvent event) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"runtimeEventOccurred", (Object)new Object[]{event, this});
        }
        if (this._isRegistered) {
            if (this._runtimeEventListener != null) {
                if (!this._messageProcessor.getMessagingEngine().isEventNotificationEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Eventing is disabled, cannot fire event");
                }
            } else if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Null RuntimeEventListener, cannot fire event");
            }
        } else if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Not registered, cannot fire event");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"runtimeEventOccurred");
        }
    }
}

