/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.ControllableType;
import com.ibm.ws.sib.admin.LocalizationDefinition;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.exceptions.SIMPException;
import com.ibm.ws.sib.processor.gd.TargetStreamManager;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.interfaces.ProducerInputHandler;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PubSubMessageItemStream;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.runtime.SIMPLocalTopicSpaceControllable;
import com.ibm.ws.sib.processor.runtime.SIMPMessageHandlerControllable;
import com.ibm.ws.sib.processor.runtime.SIMPTopicSpaceControllable;
import com.ibm.ws.sib.processor.runtime.impl.AbstractRegisteredControlAdapter;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.utils.ras.SibTr;

public class LocalTopicSpaceControl
extends AbstractRegisteredControlAdapter
implements SIMPLocalTopicSpaceControllable {
    private final BaseDestinationHandler destinationHandler;
    private PubSubMessageItemStream itemStream;
    private String id;
    private static TraceComponent tc = SibTr.register(LocalTopicSpaceControl.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");

    public LocalTopicSpaceControl(MessageProcessor messageProcessor, PubSubMessageItemStream itemStream) {
        super(messageProcessor, ControllableType.PUBLICATION_POINT);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"LocalTopicSpaceControl", (Object)new Object[]{messageProcessor, itemStream});
        }
        this.itemStream = itemStream;
        this.destinationHandler = itemStream.getDestinationHandler();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"LocalTopicSpaceControl");
        }
    }

    private ProducerInputHandler getInputHandler() {
        return (ProducerInputHandler)this.destinationHandler.getInputHandler();
    }

    public SIMPTopicSpaceControllable getTopicSpace() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTopicSpace");
        }
        SIMPTopicSpaceControllable tsControl = (SIMPTopicSpaceControllable)this.getMessageHandler();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTopicSpace", (Object)tsControl);
        }
        return tsControl;
    }

    public SIMPMessageHandlerControllable getMessageHandler() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessageHandler");
        }
        SIMPMessageHandlerControllable messageHandlerControl = (SIMPMessageHandlerControllable)this.destinationHandler.getControlAdapter();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMessageHandler", (Object)messageHandlerControl);
        }
        return messageHandlerControl;
    }

    public SIMPIterator getPubSubInboundReceiverIterator() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPubSubInboundReceiverIterator");
        }
        TargetStreamManager tsm = this.getInputHandler().getTargetStreamManager();
        SIMPIterator itr = tsm.getTargetStreamSetControlIterator();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPubSubInboundReceiverIterator", (Object)itr);
        }
        return itr;
    }

    public String getId() {
        try {
            if (this.id == null) {
                this.id = "" + this.itemStream.getID();
            }
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.LocalTopicSpaceControl.getId", (String)"1:176:1.34", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        return this.id;
    }

    public String getName() {
        return this.getMessageHandler().getName();
    }

    @Override
    public void assertValidControllable() throws SIMPControllableNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkValidControllable");
        }
        if (this.itemStream == null || !this.itemStream.isInStore()) {
            SIMPControllableNotFoundException finalE = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"LocalTopicSpaceControl.assertValidControllable", "1:207:1.34", this.id}, null));
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            }
            throw finalE;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkValidControllable");
        }
    }

    @Override
    public void dereferenceControllable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dereferenceControllable");
        }
        super.dereferenceControllable();
        this.itemStream = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dereferenceControllable");
        }
    }

    public boolean isSendAllowed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isSendAllowed");
        }
        boolean isSendAllowed = this.itemStream.isSendAllowed();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isSendAllowed", (Object)new Boolean(isSendAllowed));
        }
        return isSendAllowed;
    }

    public long getNumberOfQueuedMessages() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNumberOfQueuedMessages");
        }
        long depth = this.itemStream.getTotalMsgCount();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getNumberOfQueuedMessages", (Object)depth);
        }
        return depth;
    }

    public void setDestinationHighMsgs(long newDestHighMsgs) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDestinationHighMsgs", (Object)new Long(newDestHighMsgs));
        }
        this.itemStream.setDestHighMsgs(newDestHighMsgs);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setDestinationHighMsgs");
        }
    }

    public long getDestinationHighMsgs() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationHighMsgs");
        }
        long destHighMsgs = this.itemStream.getDestHighMsgs();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDestinationHighMsgs", (Object)new Long(destHighMsgs));
        }
        return destHighMsgs;
    }

    public void setSendAllowed(boolean newSendAllowedValue) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setSendAllowed", (Object)new Boolean(newSendAllowedValue));
        }
        this.itemStream.setSendAllowed(newSendAllowedValue);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setSendAllowed", (Object)new Boolean(newSendAllowedValue));
        }
    }

    @Override
    public String getUuid() {
        LocalizationDefinition def = this.itemStream.getLocalizationDefinition();
        String uuid = null;
        if (def != null) {
            uuid = def.getUuid();
        }
        return uuid;
    }

    @Override
    public String getRemoteEngineUuid() {
        return this.getMessageProcessor().getMessagingEngineUuid().toString();
    }

    @Override
    public synchronized void registerControlAdapterAsMBean() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerControlAdapterAsMBean");
        }
        if (!this.isRegistered() && !this.getMessageHandler().isTemporary()) {
            super.registerControlAdapterAsMBean();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerControlAdapterAsMBean");
        }
    }

    public SIMPIterator getPubSubInboundReceiverStreamSets() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPubSubInboundReceiverIterator");
        }
        TargetStreamManager tsm = this.getInputHandler().getTargetStreamManager();
        SIMPIterator itr = tsm.getTargetStreamSetControlIterator();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPubSubInboundReceiverIterator", (Object)itr);
        }
        return itr;
    }

    public SIMPIterator getLocalSubscriptions() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLocalSubscriptions");
        }
        SIMPIterator iterator = null;
        try {
            iterator = this.getTopicSpace().getLocalSubscriptionIterator();
        }
        catch (SIMPException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.LocalTopicSpaceControl", (String)"1:409:1.34", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.runtime.LocalTopicSpaceControl", "1:414:1.34", SIMPUtils.getStackTrace(e)});
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getLocalSubscriptions", (Object)iterator);
        }
        return iterator;
    }

    public SIMPIterator getPubSubDeliveryStreamSetReceiverIterator() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPubSubDeliveryStreamSetReceiverIterator");
        }
        SIMPIterator iterator = this.getInputHandler().getTargetStreamManager().getTargetStreamSetControlIterator();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPubSubDeliveryStreamSetReceiverIterator");
        }
        return iterator;
    }
}

