/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.utils;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public final class DataSlice
implements Serializable {
    private static final long serialVersionUID = 417882903364528383L;
    private byte[] _bytes;
    private int _offset;
    private int _length;

    public DataSlice() {
    }

    public DataSlice(byte[] bytes) {
        this._bytes = bytes;
        this._offset = 0;
        this._length = this._bytes != null ? bytes.length : 0;
    }

    public DataSlice(byte[] bytes, int offset, int length) {
        this._bytes = bytes;
        this._offset = offset;
        this._length = length;
    }

    public byte[] getBytes() {
        return this._bytes;
    }

    public int getOffset() {
        return this._offset;
    }

    public int getLength() {
        return this._length;
    }

    public String toString() {
        StringBuilder retval = new StringBuilder("DataSlice@");
        retval.append(this.hashCode());
        retval.append("[");
        retval.append(this._offset);
        retval.append("/");
        retval.append(this._length);
        retval.append("]");
        return retval.toString();
    }

    public String toPayloadString() {
        String digits = "0123456789ABCDEF";
        StringBuilder retval = new StringBuilder("DataSlice@");
        retval.append(this.hashCode());
        retval.append("[");
        for (int i = this._offset; i < this._offset + this._length; ++i) {
            retval.append(digits.charAt(this._bytes[i] >> 4 & 0xF));
            retval.append(digits.charAt(this._bytes[i] & 0xF));
        }
        retval.append("]");
        return retval.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this._length);
        out.write(this._bytes, this._offset, this._length);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this._offset = 0;
        this._length = in.readInt();
        this._bytes = new byte[this._length];
        in.readFully(this._bytes, this._offset, this._length);
    }
}

