/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.metrics.writer;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.metrics.Constants;
import com.ibm.ws.microprofile.metrics.exceptions.EmptyRegistryException;
import com.ibm.ws.microprofile.metrics.exceptions.NoSuchMetricException;
import com.ibm.ws.microprofile.metrics.exceptions.NoSuchRegistryException;
import com.ibm.ws.microprofile.metrics.helper.PrometheusBuilder;
import com.ibm.ws.microprofile.metrics.helper.Util;
import com.ibm.ws.microprofile.metrics.writer.OutputWriter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.io.Writer;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricType;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class PrometheusMetricWriter
implements OutputWriter {
    private static final TraceComponent tc = Tr.register(PrometheusMetricWriter.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
    private final Writer writer;
    protected final Locale locale;
    protected final Set<Metadata> improperMetadataSet = new HashSet<Metadata>();
    static final long serialVersionUID = -5245588434579643491L;

    public PrometheusMetricWriter(Writer writer, Locale locale) {
        this.writer = writer;
        this.locale = locale;
    }

    @Override
    public void write(String registryName, String metricName) throws NoSuchMetricException, NoSuchRegistryException, IOException, EmptyRegistryException {
        StringBuilder builder = new StringBuilder();
        this.writeMetricsAsPrometheus(builder, registryName, metricName);
        this.serialize(builder);
    }

    @Override
    public void write(String registryName) throws NoSuchRegistryException, EmptyRegistryException, IOException {
        StringBuilder builder = new StringBuilder();
        this.writeMetricsAsPrometheus(builder, registryName);
        this.serialize(builder);
    }

    @Override
    @FFDCIgnore(value={EmptyRegistryException.class, NoSuchRegistryException.class})
    public void write() throws IOException {
        StringBuilder builder = new StringBuilder();
        for (String registryName : Constants.REGISTRY_NAMES_LIST) {
            try {
                this.writeMetricsAsPrometheus(builder, registryName);
            }
            catch (NoSuchRegistryException noSuchRegistryException) {
            }
            catch (EmptyRegistryException emptyRegistryException) {}
        }
        this.serialize(builder);
    }

    protected void writeMetricsAsPrometheus(StringBuilder builder, String registryName) throws NoSuchRegistryException, EmptyRegistryException {
        this.writeMetricMapAsPrometheus(builder, registryName, Util.getMetricsAsMap(registryName), Util.getMetricsMetadataAsMap(registryName));
    }

    protected void writeMetricsAsPrometheus(StringBuilder builder, String registryName, String metricName) throws NoSuchRegistryException, NoSuchMetricException, EmptyRegistryException {
        this.writeMetricMapAsPrometheus(builder, registryName, Util.getMetricsAsMap(registryName, metricName), Util.getMetricsMetadataAsMap(registryName));
    }

    protected void writeMetricMapAsPrometheus(StringBuilder builder, String registryName, Map<MetricID, Metric> metricMap, Map<String, Metadata> metricMetadataMap) {
        for (Map.Entry<String, Metadata> metadataEntry : metricMetadataMap.entrySet()) {
            String metricName = metadataEntry.getKey();
            String metricNamePrometheus = registryName + "_" + metricName;
            Metadata metricMetadata = metadataEntry.getValue();
            HashMap<MetricID, Metric> currentMetricMap = new HashMap<MetricID, Metric>();
            for (Map.Entry<MetricID, Metric> metricEntry : metricMap.entrySet()) {
                if (!metricEntry.getKey().getName().equals(metricName)) continue;
                currentMetricMap.put(metricEntry.getKey(), metricEntry.getValue());
            }
            if (currentMetricMap.isEmpty()) continue;
            String description = !metricMetadata.getDescription().isPresent() || ((String)metricMetadata.getDescription().get()).trim().isEmpty() ? "" : Tr.formatMessage((TraceComponent)tc, (Locale)this.locale, (String)((String)metricMetadata.getDescription().get()), (Object[])new Object[0]);
            String unit = (String)metricMetadata.getUnit().get();
            Map.Entry<String, Double> conversionAppendEntry = this.resolveConversionFactorXappendUnitEntry(unit);
            double conversionFactor = conversionAppendEntry.getValue();
            String appendUnit = conversionAppendEntry.getKey();
            if (metricMetadata.getTypeRaw().equals((Object)MetricType.COUNTER)) {
                PrometheusBuilder.buildCounter(builder, metricNamePrometheus, description, currentMetricMap);
                continue;
            }
            if (metricMetadata.getTypeRaw().equals((Object)MetricType.CONCURRENT_GAUGE)) {
                PrometheusBuilder.buildConcurrentGauge(builder, metricNamePrometheus, description, currentMetricMap);
                continue;
            }
            if (metricMetadata.getTypeRaw().equals((Object)MetricType.GAUGE)) {
                PrometheusBuilder.buildGauge(builder, metricNamePrometheus, description, currentMetricMap, conversionFactor, appendUnit);
                continue;
            }
            if (metricMetadata.getTypeRaw().equals((Object)MetricType.TIMER)) {
                PrometheusBuilder.buildTimer(builder, metricNamePrometheus, description, currentMetricMap);
                continue;
            }
            if (metricMetadata.getTypeRaw().equals((Object)MetricType.HISTOGRAM)) {
                PrometheusBuilder.buildHistogram(builder, metricNamePrometheus, description, currentMetricMap, conversionFactor, appendUnit);
                continue;
            }
            if (metricMetadata.getTypeRaw().equals((Object)MetricType.METERED)) {
                PrometheusBuilder.buildMeter(builder, metricNamePrometheus, description, currentMetricMap);
                continue;
            }
            if (this.improperMetadataSet.contains(metricMetadata)) continue;
            Tr.event((TraceComponent)tc, (String)("Metadata " + metricMetadata.toString() + " does not have an appropriate Metric Type"), (Object[])new Object[0]);
            this.improperMetadataSet.add(metricMetadata);
        }
    }

    protected Map.Entry<String, Double> resolveConversionFactorXappendUnitEntry(String unit) {
        if (unit == null || unit.trim().isEmpty() || unit.equals("none")) {
            return new AbstractMap.SimpleEntry<Object, Double>(null, Double.NaN);
        }
        if (unit.equals("nanoseconds")) {
            return new AbstractMap.SimpleEntry<String, Double>("_seconds", 1.0E-9);
        }
        if (unit.equals("microseconds")) {
            return new AbstractMap.SimpleEntry<String, Double>("_seconds", 1.0E-6);
        }
        if (unit.equals("seconds")) {
            return new AbstractMap.SimpleEntry<String, Double>("_seconds", 1.0);
        }
        if (unit.equals("minutes")) {
            return new AbstractMap.SimpleEntry<String, Double>("_seconds", 60.0);
        }
        if (unit.equals("hours")) {
            return new AbstractMap.SimpleEntry<String, Double>("_seconds", 3600.0);
        }
        if (unit.equals("days")) {
            return new AbstractMap.SimpleEntry<String, Double>("_seconds", 86400.0);
        }
        if (unit.equals("percent")) {
            return new AbstractMap.SimpleEntry<String, Double>("_percent", Double.NaN);
        }
        if (unit.equals("bytes")) {
            return new AbstractMap.SimpleEntry<String, Double>("_bytes", 1.0);
        }
        if (unit.equals("kilobytes")) {
            return new AbstractMap.SimpleEntry<String, Double>("_bytes", 1024.0);
        }
        if (unit.equals("megabytes")) {
            return new AbstractMap.SimpleEntry<String, Double>("_bytes", 1048576.0);
        }
        if (unit.equals("gigabytes")) {
            return new AbstractMap.SimpleEntry<String, Double>("_bytes", 1.073741824E9);
        }
        if (unit.equals("kilobits")) {
            return new AbstractMap.SimpleEntry<String, Double>("_bytes", 125.0);
        }
        if (unit.equals("megabits")) {
            return new AbstractMap.SimpleEntry<String, Double>("_bytes", 125000.0);
        }
        if (unit.equals("gigabits")) {
            return new AbstractMap.SimpleEntry<String, Double>("_bytes", 1.25E8);
        }
        if (unit.equals("kibibits")) {
            return new AbstractMap.SimpleEntry<String, Double>("_bytes", 128.0);
        }
        if (unit.equals("mebibits")) {
            return new AbstractMap.SimpleEntry<String, Double>("_bytes", 131072.0);
        }
        if (unit.equals("gibibits")) {
            return new AbstractMap.SimpleEntry<String, Double>("_bytes", 1.342E8);
        }
        if (unit.equals("milliseconds")) {
            return new AbstractMap.SimpleEntry<String, Double>("_seconds", 0.001);
        }
        return new AbstractMap.SimpleEntry<String, Double>("_" + unit, Double.NaN);
    }

    protected void serialize(StringBuilder builder) throws IOException {
        try {
            this.writer.write(builder.toString());
        }
        finally {
            this.writer.flush();
        }
    }
}

