/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.core.converter;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotationMap;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.openapi.impl.core.converter.ModelConverter;
import com.ibm.ws.microprofile.openapi.impl.core.converter.ModelConverterContext;
import com.ibm.ws.microprofile.openapi.impl.model.media.SchemaImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.microprofile.openapi.models.media.Schema;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ModelConverterContextImpl
implements ModelConverterContext {
    private final List<ModelConverter> converters;
    private final Map<String, Schema> modelByName;
    private final HashMap<Type, Schema> modelByType;
    private final Set<Type> processedTypes;
    static final long serialVersionUID = -5196637210577683080L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ModelConverterContextImpl(List<ModelConverter> converters) {
        this.converters = converters;
        this.modelByName = new TreeMap<String, Schema>();
        this.modelByType = new HashMap();
        this.processedTypes = new HashSet<Type>();
    }

    public ModelConverterContextImpl(ModelConverter converter) {
        this(new ArrayList<ModelConverter>());
        this.converters.add(converter);
    }

    @Override
    public Iterator<ModelConverter> getConverters() {
        return this.converters.iterator();
    }

    @Override
    public void defineModel(String name, Schema model) {
        this.defineModel(name, model, null, null);
    }

    @Override
    public void defineModel(String name, Schema model, Type type, String prevName) {
        this.modelByName.put(name, model);
        if (StringUtils.isNotBlank((CharSequence)prevName) && !prevName.equals(name)) {
            this.modelByName.remove(prevName);
        }
        if (type != null) {
            this.modelByType.put(type, model);
        }
    }

    public Map<String, Schema> getDefinedModels() {
        return Collections.unmodifiableMap(this.modelByName);
    }

    @Override
    public Schema resolve(Type type) {
        if (this.processedTypes.contains(type)) {
            return this.modelByType.get(type);
        }
        this.processedTypes.add(type);
        Iterator<ModelConverter> converters = this.getConverters();
        Schema resolved = null;
        if (converters.hasNext()) {
            ModelConverter converter = converters.next();
            resolved = converter.resolve(type, this, converters);
        }
        if (resolved != null) {
            this.modelByType.put(type, resolved);
            SchemaImpl resolvedImpl = (SchemaImpl)resolved;
            if (resolvedImpl.getName() != null) {
                this.modelByName.put(resolvedImpl.getName(), resolved);
            }
        }
        return resolved;
    }

    @Override
    public Schema resolve(Type type, Annotation[] annotations) {
        Iterator<ModelConverter> converters = this.getConverters();
        if (converters.hasNext()) {
            ModelConverter converter = converters.next();
            return converter.resolve(type, this, annotations, converters);
        }
        return null;
    }

    @Override
    public Schema resolveAnnotatedType(Type type, List<Annotation> annotations, String elementName) {
        AnnotationMap map = new AnnotationMap();
        annotations.forEach(a -> map.add(a));
        AnnotatedMember annotated = new AnnotatedMember(null, map){
            static final long serialVersionUID = -6088617298378842368L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public Annotated withAnnotations(AnnotationMap annotationMap) {
                return this;
            }

            public Class<?> getDeclaringClass() {
                return null;
            }

            public Member getMember() {
                return null;
            }

            public void setValue(Object o, Object o1) throws UnsupportedOperationException, IllegalArgumentException {
            }

            public Object getValue(Object o) throws UnsupportedOperationException, IllegalArgumentException {
                return null;
            }

            public AnnotatedElement getAnnotated() {
                return null;
            }

            protected int getModifiers() {
                return 0;
            }

            public String getName() {
                return null;
            }

            public JavaType getType() {
                return null;
            }

            public Class<?> getRawType() {
                return null;
            }

            public boolean equals(Object o) {
                return false;
            }

            public int hashCode() {
                return 0;
            }

            public String toString() {
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.openapi.impl.core.converter.ModelConverterContextImpl$1", 1.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
            }
        };
        Iterator<ModelConverter> converters = this.getConverters();
        if (converters.hasNext()) {
            ModelConverter converter = converters.next();
            return converter.resolveAnnotatedType(type, (Annotated)annotated, elementName, this, converters);
        }
        return null;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.openapi.impl.core.converter.ModelConverterContextImpl", ModelConverterContextImpl.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
    }
}

