/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.microprofile.openapi.impl.validation.OASValidationResult;
import com.ibm.ws.microprofile.openapi.impl.validation.ReferenceValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.TypeValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.ValidationHelper;
import com.ibm.ws.microprofile.openapi.utils.OpenAPIModelWalker;
import com.ibm.ws.microprofile.openapi.utils.OpenAPIUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;

public class PathItemValidator
extends TypeValidator<PathItem> {
    private static final TraceComponent tc = Tr.register(PathItemValidator.class);
    private static final PathItemValidator INSTANCE = new PathItemValidator();

    public static PathItemValidator getInstance() {
        return INSTANCE;
    }

    private PathItemValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, PathItem t) {
        if (t != null) {
            String ref = t.getRef();
            if (ref != null && ref.startsWith("#")) {
                String message = Tr.formatMessage((TraceComponent)tc, (String)"pathItemInvalidRef", (Object[])new Object[]{ref, key});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            }
            if (key.contains("{$")) {
                if (OpenAPIUtils.isDebugEnabled(tc)) {
                    Tr.debug((TraceComponent)tc, (String)("Path contains variables. Skip validation: " + key), (Object[])new Object[0]);
                }
                return;
            }
            this.validateParameters(helper, context, key, t);
        }
    }

    private void validateParameters(ValidationHelper helper, OpenAPIModelWalker.Context context, String pathStr, PathItem path) {
        Map operationMap;
        Set<String> declaredPathParameters;
        HashSet<String> definedSharedPathParameters = new HashSet<String>();
        HashSet<String> definedSharedQueryParameters = new HashSet<String>();
        HashSet<String> definedSharedHeaderParameters = new HashSet<String>();
        HashSet<String> definedSharedCookieParameters = new HashSet<String>();
        List sharedParameters = path.getParameters();
        if (sharedParameters != null) {
            for (Parameter param : sharedParameters) {
                String message;
                Parameter parameter = param;
                String reference = parameter.getRef();
                if (reference != null && !reference.isEmpty()) {
                    Object componentItem = ReferenceValidator.getInstance().validate(helper, context, null, reference);
                    if (parameter.getClass().isInstance(componentItem)) {
                        parameter = (Parameter)componentItem;
                    }
                }
                if (this.isPathParameter(parameter) && !parameter.getRequired().booleanValue()) {
                    message = Tr.formatMessage((TraceComponent)tc, (String)"pathItemRequiredField", (Object[])new Object[]{parameter.getName(), pathStr});
                    helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
                }
                if (!(this.isPathParameter(parameter) && !definedSharedPathParameters.add(parameter.getName()) || this.isQueryParameter(parameter) && !definedSharedQueryParameters.add(parameter.getName()) || this.isHeaderParameter(parameter) && !definedSharedHeaderParameters.add(parameter.getName())) && (!this.isCookieParameter(parameter) || definedSharedCookieParameters.add(parameter.getName()))) continue;
                message = Tr.formatMessage((TraceComponent)tc, (String)"pathItemDuplicate", (Object[])new Object[]{pathStr, parameter.getIn(), parameter.getName()});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            }
        }
        if (!(declaredPathParameters = this.validatePathAndRetrievePathParams(helper, context, pathStr)).containsAll(definedSharedPathParameters)) {
            HashSet undeclaredParameters = new HashSet(definedSharedPathParameters);
            undeclaredParameters.removeAll(declaredPathParameters);
            boolean isMultiple = undeclaredParameters.size() > 1;
            String message = isMultiple ? Tr.formatMessage((TraceComponent)tc, (String)"pathItemParameterNotDeclaredMultiple", (Object[])new Object[]{pathStr, undeclaredParameters.size(), undeclaredParameters}) : Tr.formatMessage((TraceComponent)tc, (String)"pathItemParameterNotDeclaredSingle", (Object[])new Object[]{pathStr, undeclaredParameters});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.WARNING, context.getLocation(), message));
        }
        if ((operationMap = path.readOperationsMap()) != null) {
            for (PathItem.HttpMethod httpMethod : operationMap.keySet()) {
                Operation operation = (Operation)operationMap.get(httpMethod);
                this.validateOperationParameters(helper, context, operation, declaredPathParameters, definedSharedPathParameters, pathStr, httpMethod.toString());
            }
        }
    }

    private void validateOperationParameters(ValidationHelper helper, OpenAPIModelWalker.Context context, Operation operation, Set<String> declaredPathParameters, Set<String> definedSharedPathParams, String path, String operationType) {
        String message;
        HashSet<String> definedPathParameters = new HashSet<String>();
        HashSet<String> definedQueryParameters = new HashSet<String>();
        HashSet<String> definedHeaderParameters = new HashSet<String>();
        HashSet<String> definedCookieParameters = new HashSet<String>();
        List parameters = operation.getParameters();
        if (parameters != null && !parameters.isEmpty()) {
            for (Parameter param : parameters) {
                if (param != null) {
                    String message2;
                    Parameter parameter = param;
                    String reference = parameter.getRef();
                    if (reference != null && !reference.isEmpty()) {
                        Object componentItem = ReferenceValidator.getInstance().validate(helper, context, null, reference);
                        if (parameter.getClass().isInstance(componentItem)) {
                            parameter = (Parameter)componentItem;
                        }
                    }
                    if (this.isPathParameter(parameter) && !parameter.getRequired().booleanValue()) {
                        message2 = Tr.formatMessage((TraceComponent)tc, (String)"pathItemOperationRequiredField", (Object[])new Object[]{parameter.getName(), operationType, path});
                        helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message2));
                    }
                    if (!(this.isPathParameter(parameter) && !definedPathParameters.add(parameter.getName()) || this.isQueryParameter(parameter) && !definedQueryParameters.add(parameter.getName()) || this.isHeaderParameter(parameter) && !definedHeaderParameters.add(parameter.getName())) && (!this.isCookieParameter(parameter) || definedCookieParameters.add(parameter.getName()))) continue;
                    message2 = Tr.formatMessage((TraceComponent)tc, (String)"pathItemOperationDuplicate", (Object[])new Object[]{operationType, path, parameter.getIn(), parameter.getName()});
                    helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message2));
                    continue;
                }
                message = Tr.formatMessage((TraceComponent)tc, (String)"pathItemOperationNullParameter", (Object[])new Object[]{operationType, path});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            }
        }
        if (!declaredPathParameters.containsAll(definedPathParameters)) {
            HashSet undeclaredParameters = new HashSet(definedPathParameters);
            undeclaredParameters.removeAll(declaredPathParameters);
            boolean isMultiple = undeclaredParameters.size() > 1;
            message = isMultiple ? Tr.formatMessage((TraceComponent)tc, (String)"pathItemOperationParameterNotDeclaredMultiple", (Object[])new Object[]{operationType, path, undeclaredParameters.size(), undeclaredParameters}) : Tr.formatMessage((TraceComponent)tc, (String)"pathItemOperationParameterNotDeclaredSingle", (Object[])new Object[]{operationType, path, undeclaredParameters});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.WARNING, context.getLocation(), message));
        }
        for (String declaredParam : declaredPathParameters) {
            if (definedSharedPathParams.contains(declaredParam) || definedPathParameters.contains(declaredParam)) continue;
            message = Tr.formatMessage((TraceComponent)tc, (String)"pathItemOperationNoPathParameterDeclared", (Object[])new Object[]{operationType, path, declaredParam});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
        }
    }

    private boolean isCookieParameter(Parameter parameter) {
        return Parameter.In.COOKIE == parameter.getIn();
    }

    private boolean isHeaderParameter(Parameter parameter) {
        return Parameter.In.HEADER == parameter.getIn();
    }

    private boolean isQueryParameter(Parameter parameter) {
        return Parameter.In.QUERY == parameter.getIn();
    }

    private boolean isPathParameter(Parameter parameter) {
        return Parameter.In.PATH == parameter.getIn();
    }

    private Set<String> validatePathAndRetrievePathParams(ValidationHelper helper, OpenAPIModelWalker.Context context, String pathStr) {
        String pathToCheck = pathStr;
        HashSet<String> pathParameters = new HashSet<String>();
        while (pathToCheck.contains("{")) {
            int lastIndex;
            if (!pathToCheck.contains("}")) {
                String message = Tr.formatMessage((TraceComponent)tc, (String)"pathItemInvalidFormat", (Object[])new Object[]{pathStr});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
                return pathParameters;
            }
            int firstIndex = pathToCheck.indexOf("{");
            if (firstIndex > (lastIndex = pathToCheck.indexOf("}"))) {
                String message = Tr.formatMessage((TraceComponent)tc, (String)"pathItemInvalidFormat", (Object[])new Object[]{pathStr});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
                return pathParameters;
            }
            String parameter = pathToCheck.substring(firstIndex + 1, lastIndex);
            if (parameter.isEmpty() || parameter.contains("{") || parameter.contains("/")) {
                String message = Tr.formatMessage((TraceComponent)tc, (String)"pathItemInvalidFormat", (Object[])new Object[]{pathStr});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
                return pathParameters;
            }
            pathParameters.add(parameter);
            pathToCheck = pathToCheck.substring(lastIndex + 1);
        }
        if (pathToCheck.contains("}")) {
            String message = Tr.formatMessage((TraceComponent)tc, (String)"pathItemInvalidFormat", (Object[])new Object[]{pathStr});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            return pathParameters;
        }
        return pathParameters;
    }
}

