/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.mongo.ssl.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.SSLConfigChangeEvent;
import com.ibm.websphere.ssl.SSLConfigChangeListener;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.mongo.MongoChangeListener;
import com.ibm.ws.mongo.MongoSslHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.ssl.KeyStoreService;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.ssl.SSLConfiguration;
import java.security.AccessController;
import java.security.KeyStoreException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLSocketFactory;
import javax.security.auth.x500.X500Principal;
import org.osgi.service.component.annotations.Component;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component
public class MongoSslHelperImpl
implements MongoSslHelper {
    private final Map<MongoChangeListener, SSLConfigChangeListener> changeListeners = Collections.synchronizedMap(new HashMap());
    static final long serialVersionUID = -6987951272633040514L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public SSLSocketFactory getSSLSocketFactory(Object sslConfig, final Map<String, Object> connectionInfo) throws Exception {
        String sslConfigurationAlias = null;
        if (sslConfig != null) {
            sslConfigurationAlias = ((SSLConfiguration)sslConfig).getAlias();
        }
        final JSSEHelper helper = JSSEHelper.getInstance();
        final Properties sslProps = helper.getProperties(sslConfigurationAlias, connectionInfo, null);
        SSLSocketFactory sslSF = AccessController.doPrivileged(new PrivilegedExceptionAction<SSLSocketFactory>(){
            static final long serialVersionUID = -1202162443069950284L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public SSLSocketFactory run() throws Exception {
                return helper.getSSLSocketFactory(connectionInfo, sslProps);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.mongo.ssl.internal.MongoSslHelperImpl$1", 1.class, (String)"mongo", null);
            }
        });
        return sslSF;
    }

    public Properties getSSLProperties(Object sslConfig, Map<String, Object> connectionInfo, MongoChangeListener changeListener) throws Exception {
        Properties sslProperties = null;
        String sslAlias = null;
        if (sslConfig != null) {
            sslAlias = ((SSLConfiguration)sslConfig).getAlias();
        }
        JSSEHelper helper = JSSEHelper.getInstance();
        MongoSSLConfigChangeListener configListener = null;
        if (changeListener != null) {
            configListener = new MongoSSLConfigChangeListener(changeListener);
            this.changeListeners.put(changeListener, configListener);
        }
        sslProperties = helper.getProperties(sslAlias, connectionInfo, (SSLConfigChangeListener)configListener);
        return sslProperties;
    }

    public Map<String, Object> getConnectionInfo(String hostname, String port) {
        HashMap<String, Object> connectionInfo = new HashMap<String, Object>();
        connectionInfo.put("com.ibm.ssl.direction", "outbound");
        connectionInfo.put("com.ibm.ssl.remoteHost", hostname);
        connectionInfo.put("com.ibm.ssl.remotePort", port);
        return connectionInfo;
    }

    public String getClientKeyCertSubject(AtomicServiceReference<Object> keyStoreServiceRef, Properties sslProps) throws KeyStoreException, CertificateException {
        KeyStoreService keyStoreService = (KeyStoreService)keyStoreServiceRef.getService();
        X509Certificate cert = keyStoreService.getClientKeyCert(sslProps);
        X500Principal x500 = cert == null ? null : cert.getSubjectX500Principal();
        String name = x500 == null ? null : x500.getName();
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void removeChangeListener(MongoChangeListener listener) {
        Map<MongoChangeListener, SSLConfigChangeListener> map = this.changeListeners;
        synchronized (map) {
            SSLConfigChangeListener sslConfigListener = this.changeListeners.get(listener);
            if (sslConfigListener != null) {
                JSSEHelper helper = JSSEHelper.getInstance();
                try {
                    helper.deregisterSSLConfigChangeListener(sslConfigListener);
                }
                catch (SSLException sSLException) {
                    void e;
                    FFDCFilter.processException((Throwable)sSLException, (String)"com.ibm.ws.mongo.ssl.internal.MongoSslHelperImpl", (String)"122", (Object)this, (Object[])new Object[]{listener});
                    throw new RuntimeException((Throwable)e);
                }
                this.changeListeners.remove(listener);
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.mongo.ssl.internal.MongoSslHelperImpl", MongoSslHelperImpl.class, (String)"mongo", null);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class MongoSSLConfigChangeListener
    implements SSLConfigChangeListener {
        private final MongoChangeListener delegate;
        static final long serialVersionUID = 8765970577100872957L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public MongoSSLConfigChangeListener(MongoChangeListener delegate) {
            this.delegate = delegate;
        }

        public void stateChanged(SSLConfigChangeEvent e) {
            this.delegate.changeOccurred();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.mongo.ssl.internal.MongoSslHelperImpl$MongoSSLConfigChangeListener", MongoSSLConfigChangeListener.class, (String)"mongo", null);
        }
    }
}

