/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.monitor.internal.boot.templates;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.security.AccessController;
import java.security.PrivilegedAction;

public final class ProbeUtils {
    private static final ThreadMXBean threadBean = ProbeUtils.getThreadMXBean();

    public static final long nanoTime() {
        return System.nanoTime();
    }

    public static final long elapsedNanoTime(long startTime) {
        return ProbeUtils.nanoTime() - startTime;
    }

    public static final long cpuTime() {
        if (threadBean != null) {
            return threadBean.getCurrentThreadCpuTime();
        }
        return -1L;
    }

    public static final long elapsedCpuTime(long startTime) {
        return ProbeUtils.cpuTime() - startTime;
    }

    public static final long userTime() {
        if (threadBean != null) {
            return threadBean.getCurrentThreadUserTime();
        }
        return -1L;
    }

    public static final long elapsedUserTime(long startTime) {
        return ProbeUtils.userTime() - startTime;
    }

    private static ThreadMXBean getThreadMXBean() {
        return AccessController.doPrivileged(new PrivilegedAction<ThreadMXBean>(){

            @Override
            public ThreadMXBean run() {
                ThreadMXBean bean = ManagementFactory.getThreadMXBean();
                try {
                    if (bean != null && !bean.isCurrentThreadCpuTimeSupported()) {
                        bean = null;
                    }
                    if (bean != null && !bean.isThreadCpuTimeEnabled()) {
                        bean.setThreadCpuTimeEnabled(true);
                    }
                }
                catch (Throwable t) {
                    bean = null;
                }
                return bean;
            }
        });
    }
}

