/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.openapi31;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.openapi31.OpenAPIUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.wab.configure.WABConfiguration;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM"})
public class OpenAPIEndpointManager {
    private static final TraceComponent tc = Tr.register(OpenAPIEndpointManager.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi31.resources.OpenAPIMessages");
    private static final String PUBLIC_URL = "mp.openapi.extensions.liberty.public.url";
    private static final String PUBLIC_URL_DEFAULT_VALUE = "/api";
    private static final String ENABLE_PRIVATE_URL = "mp.openapi.extensions.liberty.enable.private.url";
    private static final boolean ENABLE_PRIVATE_URL_DEFAULT_VALUE = false;
    private static final String PUBLIC_OPEN_API_DOCS_VAR_NAME = "publicOpenAPIDocsURL";
    private static final String PUBLIC_OPEN_API_DOCS_CONTEXT_PATH_SUFFIX = "/docs";
    private static final String PUBLIC_OPEN_API_EXPLORER_VAR_NAME = "publicOpenAPIExplorerURL";
    private static final String PUBLIC_OPEN_API_EXPLORER_CONTEXT_PATH_SUFFIX = "/explorer";
    private static final String PRIVATE_OPEN_API_DOCS_VAR_NAME = "privateOpenAPIDocsURL";
    private static final String PRIVATE_OPEN_API_DOCS_URL = "/ibm/api/docs";
    private static final String PRIVATE_OPEN_API_EXPLORER_VAR_NAME = "privateOpenAPIExplorerURL";
    private static final String PRIVATE_OPEN_API_EXPLORER_URL = "/ibm/api/explorer";
    private static final String RESERVED_URL = "/ibm/api";
    private final List<PublicOpenAPIWABConfigManager> publicWabConfigMgrs = new ArrayList<PublicOpenAPIWABConfigManager>();
    private final List<PrivateOpenAPIWABConfigManager> privateWabConfigMgrs;
    static final long serialVersionUID = 3160048933883700983L;

    public OpenAPIEndpointManager() {
        this.publicWabConfigMgrs.add(new PublicOpenAPIWABConfigManager(PUBLIC_OPEN_API_DOCS_VAR_NAME, PUBLIC_OPEN_API_DOCS_CONTEXT_PATH_SUFFIX));
        this.publicWabConfigMgrs.add(new PublicOpenAPIWABConfigManager(PUBLIC_OPEN_API_EXPLORER_VAR_NAME, PUBLIC_OPEN_API_EXPLORER_CONTEXT_PATH_SUFFIX));
        this.privateWabConfigMgrs = new ArrayList<PrivateOpenAPIWABConfigManager>();
        this.privateWabConfigMgrs.add(new PrivateOpenAPIWABConfigManager(PRIVATE_OPEN_API_DOCS_VAR_NAME, PRIVATE_OPEN_API_DOCS_URL));
        this.privateWabConfigMgrs.add(new PrivateOpenAPIWABConfigManager(PRIVATE_OPEN_API_EXPLORER_VAR_NAME, PRIVATE_OPEN_API_EXPLORER_URL));
    }

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> properties) {
        Config config = ConfigProvider.getConfig((ClassLoader)OpenAPIEndpointManager.class.getClassLoader());
        this.processPublicURL(context, config);
        this.processEnablePrivate(context, config);
    }

    @Deactivate
    protected void deactivate(ComponentContext context, int reason) {
        this.deactivate(this.publicWabConfigMgrs);
        this.deactivate(this.privateWabConfigMgrs);
    }

    private void deactivate(List<? extends WABConfigManager> configMgrs) {
        configMgrs.forEach(v -> v.deactivate());
    }

    private void processPublicURL(ComponentContext context, Config config) {
        String publicURL = OpenAPIUtils.getOptionalValue(config, PUBLIC_URL, String.class, PUBLIC_URL_DEFAULT_VALUE);
        if (!publicURL.startsWith("/")) {
            publicURL = '/' + publicURL;
        }
        if (publicURL.endsWith("/") && !publicURL.equals("/")) {
            publicURL = publicURL.substring(0, publicURL.length() - 1);
        }
        if (RESERVED_URL.equals(publicURL)) {
            Tr.warning((TraceComponent)tc, (String)"PUBLIC_URL_INVALID", (Object[])new Object[]{RESERVED_URL});
            publicURL = PUBLIC_URL_DEFAULT_VALUE;
        }
        String _publicURL = publicURL;
        this.publicWabConfigMgrs.forEach(v -> v.updateWABConfiguration(context, _publicURL));
    }

    private void processEnablePrivate(ComponentContext context, Config config) {
        boolean enablePrivate = OpenAPIUtils.getOptionalValue(config, ENABLE_PRIVATE_URL, Boolean.class, false);
        this.privateWabConfigMgrs.forEach(v -> v.processEnablePrivate(context, enablePrivate));
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static final class PrivateOpenAPIWABConfigManager
    extends WABConfigManager {
        private final String contextPath;
        static final long serialVersionUID = -6378876682153886167L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public PrivateOpenAPIWABConfigManager(String contextName, String contextPath) {
            super(contextName);
            this.contextPath = contextPath;
        }

        public void processEnablePrivate(ComponentContext context, boolean enabled) {
            if (OpenAPIUtils.isEventEnabled(tc)) {
                Tr.event((TraceComponent)tc, (String)("OpenAPI mp.openapi.extensions.liberty.enable.private.url property updated: " + enabled + " WAB config=" + this.wabConfigReg), (Object[])new Object[0]);
            }
            if (this.wabConfigReg == null && !enabled) {
                return;
            }
            if (enabled) {
                this.pushConfiguration(context, this.contextPath);
            } else {
                this.deactivate();
            }
        }

        @Override
        public void registerEvent(Dictionary<String, String> props) {
            Tr.event((TraceComponent)tc, (String)("OpenAPI private web app bundle registered, WAB config=" + this.wabConfigReg + " using props=" + props), (Object[])new Object[0]);
        }

        @Override
        public void modifiedEvent(Dictionary<String, String> props) {
            Tr.event((TraceComponent)tc, (String)("OpenAPI private web app bundle modified, WAB config=" + this.wabConfigReg + " using props=" + props), (Object[])new Object[0]);
        }

        @Override
        public void deactivateEvent() {
            Tr.event((TraceComponent)tc, (String)("Unregistered private web app bundle, WAB config=" + this.wabConfigReg + " for contextName=" + this.contextName + " and contextPath=" + this.contextPath), (Object[])new Object[0]);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.openapi31.OpenAPIEndpointManager$PrivateOpenAPIWABConfigManager", PrivateOpenAPIWABConfigManager.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi31.resources.OpenAPIMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static final class PublicOpenAPIWABConfigManager
    extends WABConfigManager {
        private final String contextPathSuffix;
        static final long serialVersionUID = -6429859559600124778L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public PublicOpenAPIWABConfigManager(String contextName, String contextPathSuffix) {
            super(contextName);
            this.contextPathSuffix = contextPathSuffix;
        }

        public void updateWABConfiguration(ComponentContext context, String publicURL) {
            if (OpenAPIUtils.isEventEnabled(tc)) {
                Tr.event((TraceComponent)tc, (String)("OpenAPI mp.openapi.extensions.liberty.public.url property updated: " + publicURL + " WAB config=" + this.wabConfigReg), (Object[])new Object[0]);
            }
            this.pushConfiguration(context, publicURL + this.contextPathSuffix);
        }

        @Override
        public void registerEvent(Dictionary<String, String> props) {
            Tr.event((TraceComponent)tc, (String)("OpenAPI public web app bundle registered, WAB config=" + this.wabConfigReg + " using props=" + props), (Object[])new Object[0]);
        }

        @Override
        public void modifiedEvent(Dictionary<String, String> props) {
            Tr.event((TraceComponent)tc, (String)("OpenAPI public web app bundle modified, WAB config=" + this.wabConfigReg + " using props=" + props), (Object[])new Object[0]);
        }

        @Override
        public void deactivateEvent() {
            Tr.event((TraceComponent)tc, (String)("Unregistered public web app bundle, WAB config=" + this.wabConfigReg + " for contextName=" + this.contextName + " and contextPathSuffix=" + this.contextPathSuffix), (Object[])new Object[0]);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.openapi31.OpenAPIEndpointManager$PublicOpenAPIWABConfigManager", PublicOpenAPIWABConfigManager.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi31.resources.OpenAPIMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static abstract class WABConfigManager {
        final String contextName;
        ServiceRegistration<WABConfiguration> wabConfigReg;
        static final long serialVersionUID = 4631665559397454182L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public WABConfigManager(String contextName) {
            this.contextName = contextName;
        }

        public final void pushConfiguration(ComponentContext context, String path) {
            BundleContext bundleContext = context.getBundleContext();
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("contextName", this.contextName);
            ((Dictionary)props).put("contextPath", path);
            if (this.wabConfigReg == null) {
                this.wabConfigReg = bundleContext.registerService(WABConfiguration.class, (Object)new WABConfiguration(){
                    static final long serialVersionUID = -7312170852345618356L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.openapi31.OpenAPIEndpointManager$WABConfigManager$1", 1.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi31.resources.OpenAPIMessages");
                    }
                }, props);
                if (OpenAPIUtils.isEventEnabled(tc)) {
                    this.registerEvent(props);
                }
            } else {
                this.wabConfigReg.setProperties(props);
                if (OpenAPIUtils.isEventEnabled(tc)) {
                    this.modifiedEvent(props);
                }
            }
        }

        public final void deactivate() {
            if (this.wabConfigReg != null) {
                this.wabConfigReg.unregister();
                if (OpenAPIUtils.isEventEnabled(tc)) {
                    this.deactivateEvent();
                }
                this.wabConfigReg = null;
            }
        }

        public abstract void registerEvent(Dictionary<String, String> var1);

        public abstract void modifiedEvent(Dictionary<String, String> var1);

        public abstract void deactivateEvent();

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.openapi31.OpenAPIEndpointManager$WABConfigManager", WABConfigManager.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi31.resources.OpenAPIMessages");
        }
    }
}

