/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.openapi31;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.openapi.impl.model.servers.ServerImpl;
import com.ibm.ws.openapi31.OpenAPIUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.servers.Server;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ServerInfo {
    private static final TraceComponent tc = Tr.register(ServerInfo.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi31.resources.OpenAPIMessages");
    private int httpPort = -1;
    private int httpsPort = -1;
    private String host;
    private List<Server> customServers = null;
    static final long serialVersionUID = 1908703262075014915L;

    public ServerInfo(ServerInfo serverInfo) {
        this.host = serverInfo.host;
        this.httpPort = serverInfo.httpPort;
        this.httpsPort = serverInfo.httpsPort;
        this.customServers = serverInfo.customServers;
    }

    public List<Server> setCustomServers(List<Server> servers) {
        this.customServers = servers;
        return this.customServers;
    }

    public List<Server> getCustomServers() {
        return this.customServers;
    }

    public ServerInfo(String host, int httpPort, int httpsPort) {
        this.host = host;
        this.httpPort = httpPort;
        this.httpsPort = httpsPort;
    }

    public String getHost() {
        return this.host;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public String getHTTPServerURL() {
        return this.httpPort < 1 ? null : "http://" + this.host + ":" + this.httpPort;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    public String getHTTPSServerURL() {
        return this.httpsPort < 1 ? null : "https://" + this.host + ":" + this.httpsPort;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public void setHttpsPort(int secureHttpPort) {
        this.httpsPort = secureHttpPort;
    }

    public String toString() {
        return "ServerInfo [host=" + this.host + ", httpPort=" + this.httpPort + ", httpsPort=" + this.httpsPort + "]";
    }

    public void updateServers(OpenAPI openAPI) {
        String serversString;
        if (OpenAPIUtils.isDebugEnabled(tc)) {
            serversString = OpenAPIUtils.stringify(openAPI.getServers());
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Updating the servers list. Old value: \n" + serversString), (Object[])new Object[0]);
        }
        if (this.customServers != null && !this.customServers.isEmpty()) {
            openAPI.setServers(this.customServers);
            if (OpenAPIUtils.isDebugEnabled(tc)) {
                serversString = OpenAPIUtils.stringify(openAPI.getServers());
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Updated the servers list. New value: \n" + serversString), (Object[])new Object[0]);
            }
            return;
        }
        openAPI.setServers(new ArrayList());
        if (this.getHTTPServerURL() != null) {
            openAPI.addServer(new ServerImpl().url(this.getHTTPServerURL()));
        }
        if (this.getHTTPSServerURL() != null) {
            openAPI.addServer(new ServerImpl().url(this.getHTTPSServerURL()));
        }
        if (OpenAPIUtils.isDebugEnabled(tc)) {
            serversString = OpenAPIUtils.stringify(openAPI.getServers());
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Updated the servers list. New value: \n" + serversString), (Object[])new Object[0]);
        }
    }
}

