/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.openapi31.merge;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.openapi.utils.DefaultOpenAPIModelVisitor;
import com.ibm.ws.microprofile.openapi.utils.OpenAPIModelVisitor;
import com.ibm.ws.microprofile.openapi.utils.OpenAPIModelWalker;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.examples.Example;
import org.eclipse.microprofile.openapi.models.headers.Header;
import org.eclipse.microprofile.openapi.models.links.Link;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OASRenameVisitor
extends DefaultOpenAPIModelVisitor {
    private final Map<String, Map<String, String>> conflicsMap;
    private final OpenAPI openAPI;
    static final long serialVersionUID = -6773106317595826906L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public OASRenameVisitor(OpenAPI openAPI, Map<String, Map<String, String>> confMap) {
        this.conflicsMap = confMap;
        this.openAPI = openAPI;
    }

    public void renameRefs() {
        OpenAPIModelWalker walker = new OpenAPIModelWalker(this.openAPI);
        walker.accept((OpenAPIModelVisitor)this);
    }

    public void visitExample(OpenAPIModelWalker.Context context, Example example) {
        String oldName;
        String newName;
        String reference = example.getRef();
        if (reference != null && reference.startsWith("#/components/examples/") && (newName = this.getNewName("$.components.examples", oldName = reference.split("/")[3])) != null) {
            example.setRef("#/components/examples/" + newName);
        }
    }

    public void visitExample(OpenAPIModelWalker.Context context, String key, Example example) {
        String oldName;
        String newName;
        String reference = example.getRef();
        if (reference != null && reference.startsWith("#/components/examples/") && (newName = this.getNewName("$.components.examples", oldName = reference.split("/")[3])) != null) {
            example.setRef("#/components/examples/" + newName);
        }
    }

    public void visitHeader(OpenAPIModelWalker.Context context, String key, Header header) {
        String oldName;
        String newName;
        String reference = header.getRef();
        if (reference != null && reference.startsWith("#/components/headers/") && (newName = this.getNewName("$.components.headers", oldName = reference.split("/")[3])) != null) {
            header.setRef("#/components/headers/" + newName);
        }
    }

    public void visitLink(OpenAPIModelWalker.Context context, String key, Link link) {
        String reference = link.getRef();
        if (reference != null && reference.startsWith("#/components/links/")) {
            String oldName = reference.split("/")[3];
            String newName = this.getNewName("$.components.links", oldName);
            if (newName != null) {
                link.setRef("#/components/links/" + newName);
            }
        } else if (reference == null) {
            String operaitonId = link.getOperationId();
            String new_operationId = this.getConflictsMap("$.paths..operationId").get(operaitonId);
            if (new_operationId != null) {
                link.setOperationId(new_operationId);
            }
        }
    }

    public void visitParameter(OpenAPIModelWalker.Context context, Parameter p) {
        String oldName;
        String newName;
        String reference = p.getRef();
        if (reference != null && reference.startsWith("#/components/parameters/") && (newName = this.getNewName("$.components.parameters", oldName = reference.split("/")[3])) != null) {
            p.setRef("#/components/parameters/" + newName);
        }
    }

    public void visitParameter(OpenAPIModelWalker.Context context, String key, Parameter p) {
        String oldName;
        String newName;
        String reference = p.getRef();
        if (reference != null && reference.startsWith("#/components/parameters/") && (newName = this.getNewName("$.components.parameters", oldName = reference.split("/")[3])) != null) {
            p.setRef("#/components/parameters/" + newName);
        }
    }

    public void visitRequestBody(OpenAPIModelWalker.Context context, RequestBody rb) {
        String oldName;
        String newName;
        String reference = rb.getRef();
        if (reference != null && reference.startsWith("#/components/requestBodies/") && (newName = this.getNewName("$.components.requestBodies", oldName = reference.split("/")[3])) != null) {
            rb.setRef("#/components/requestBodies/" + newName);
        }
    }

    public void visitRequestBody(OpenAPIModelWalker.Context context, String key, RequestBody rb) {
        String oldName;
        String newName;
        String reference = rb.getRef();
        if (reference != null && reference.startsWith("#/components/requestBodies/") && (newName = this.getNewName("$.components.requestBodies", oldName = reference.split("/")[3])) != null) {
            rb.setRef("#/components/requestBodies/" + newName);
        }
    }

    public void visitResponse(OpenAPIModelWalker.Context context, String key, APIResponse response) {
        String oldName;
        String newName;
        String reference = response.getRef();
        if (reference != null && reference.startsWith("#/components/responses/") && (newName = this.getNewName("$.components.responses", oldName = reference.split("/")[3])) != null) {
            response.setRef("#/components/responses/" + newName);
        }
    }

    public void visitSchema(OpenAPIModelWalker.Context context, Schema schema) {
        String oldName;
        String newName;
        String reference = schema.getRef();
        if (reference != null && reference.startsWith("#/components/schemas/") && (newName = this.getNewName("$.components.schemas", oldName = reference.split("/")[3])) != null) {
            schema.setRef("#/components/schemas/" + newName);
        }
    }

    public void visitSchema(OpenAPIModelWalker.Context context, String key, Schema schema) {
        String oldName;
        String newName;
        String reference = schema.getRef();
        if (reference != null && reference.startsWith("#/components/schemas/") && (newName = this.getNewName("$.components.schemas", oldName = reference.split("/")[3])) != null) {
            schema.setRef("#/components/schemas/" + newName);
        }
    }

    public void visitSecurityScheme(OpenAPIModelWalker.Context context, String key, SecurityScheme scheme) {
        String oldName;
        String newName;
        String reference = scheme.getRef();
        if (reference != null && reference.startsWith("#/components/securitySchemes/") && (newName = this.getNewName("$.components.securitySchemes", oldName = reference.split("/")[3])) != null) {
            scheme.setRef("#/components/securitySchemes/" + newName);
        }
    }

    public void visitOperation(OpenAPIModelWalker.Context context, Operation operation) {
        List tags = operation.getTags();
        if (tags != null) {
            Iterator tagsIt = tags.iterator();
            HashSet<String> new_tags = new HashSet<String>();
            while (tagsIt.hasNext()) {
                String tagName = (String)tagsIt.next();
                String new_tagName = this.getNewName("$.tags", tagName);
                if (new_tagName == null) continue;
                tagsIt.remove();
                new_tags.add(new_tagName);
            }
            tags.addAll(new_tags);
        }
    }

    private String getNewName(String type, String original) {
        Map<String, String> conflictPairs = this.getConflictsMap(type);
        return conflictPairs.get(original);
    }

    private Map<String, String> getConflictsMap(String type) {
        Map<String, String> conflicts = this.conflicsMap.get(type);
        if (conflicts == null) {
            conflicts = new HashMap<String, String>();
            this.conflicsMap.put(type, conflicts);
        }
        return conflicts;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.openapi31.merge.OASRenameVisitor", OASRenameVisitor.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi31.resources.OpenAPIMessages");
    }
}

