/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.openapi.batch;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.openapi.OASProvider;
import com.ibm.wsspi.openapi.OASProviderConfig;
import com.ibm.wsspi.openapi.OASProviderResult;
import io.swagger.oas.models.OpenAPI;
import io.swagger.oas.models.Operation;
import io.swagger.oas.models.PathItem;
import io.swagger.oas.models.Paths;
import io.swagger.oas.models.info.Info;
import io.swagger.oas.models.media.ArraySchema;
import io.swagger.oas.models.media.BooleanSchema;
import io.swagger.oas.models.media.Content;
import io.swagger.oas.models.media.IntegerSchema;
import io.swagger.oas.models.media.MediaType;
import io.swagger.oas.models.media.ObjectSchema;
import io.swagger.oas.models.media.Schema;
import io.swagger.oas.models.media.StringSchema;
import io.swagger.oas.models.parameters.Parameter;
import io.swagger.oas.models.parameters.PathParameter;
import io.swagger.oas.models.parameters.QueryParameter;
import io.swagger.oas.models.parameters.RequestBody;
import io.swagger.oas.models.responses.ApiResponse;
import io.swagger.oas.models.responses.ApiResponses;
import io.swagger.oas.models.tags.Tag;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={OASProvider.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class BatchOASProviderImpl
implements OASProvider {
    private static final TraceComponent tc = Tr.register(BatchOASProviderImpl.class, (String)"BatchOASProvider", null);
    private List<OASProviderResult> results = null;
    private OpenAPI openapi = null;
    private PathItem reusablePathItem;
    private final Content defaultContent = new Content().addMediaType("application/json", new MediaType().schema((Schema)new StringSchema()));
    private final Content tripleContent = new Content().addMediaType("application/json", new MediaType().schema((Schema)new StringSchema())).addMediaType("application/zip", new MediaType().schema(new StringSchema().format("binary"))).addMediaType("text/plain", new MediaType().schema((Schema)new StringSchema()));
    private final List<String> allTags = Arrays.asList("Batch");
    private final String ROOT = "/ibm/api/batch";
    static final long serialVersionUID = -2589349881789830678L;

    private void populateDocument() {
        this.openapi = new OpenAPI();
        Info info = new Info().description("Batch APIs").version("1.0.0").title("Batch REST APIs");
        this.openapi.info(info).tags(Arrays.asList(new Tag().name("Batch").description("Batch REST APIs"))).paths(new Paths());
        this.populateJobExecutionsDocument();
        this.populateJobInstancesDocument();
        this.populateStepExecutionsDocument();
        this.populateBatchRoot();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"Created Batch OpenAPI model", (Object[])new Object[0]);
        }
    }

    private void populateJobExecutionsDocument() {
        Operation operationGetJobExecutionId = new Operation().tags(this.allTags).summary("Get information about a job execution").description("This URI returns detailed information about a specified job execution and includes links to associated step executions and job logs.").addParametersItem(new PathParameter().name("jobexecutionid").schema((Schema)new IntegerSchema().format("int64"))).responses(new ApiResponses().addApiResponse("200", new ApiResponse().description("successful operation").content(this.defaultContent)));
        this.reusablePathItem = new PathItem().get(operationGetJobExecutionId);
        Operation operationPutJobExecutionId = new Operation().tags(this.allTags).summary("Stop or restart a job execution").description("Use this URI to stop or restart the specified job execution. Required parameters include action = stop, restart.").addParametersItem(new PathParameter().name("jobexecutionid").schema((Schema)new IntegerSchema().format("int64"))).addParametersItem(new QueryParameter().name("action").schema((Schema)new StringSchema()._enum(Arrays.asList("stop", "restart"))).required(Boolean.valueOf(true))).addParametersItem(new QueryParameter().name("reusePreviousParams").schema((Schema)new BooleanSchema()._default(Boolean.valueOf(false))).required(Boolean.valueOf(false))).requestBody(new RequestBody().description("The job parameters passed into a restart. This field is only used when action=restart and is always optional").required(Boolean.valueOf(false)).content(new Content().addMediaType("application/json", new MediaType().schema(this.getPutModel())))).responses(new ApiResponses().addApiResponse("200", new ApiResponse().description("successful operation").content(this.defaultContent)).addApiResponse("302", new ApiResponse().description("The request was redirected to the correct executor")));
        this.reusablePathItem.put(operationPutJobExecutionId);
        this.openapi.getPaths().addPathItem("/ibm/api/batch/jobexecutions/{jobexecutionid}", this.reusablePathItem);
        this.openapi.getPaths().addPathItem("/ibm/api/batch/v1/jobexecutions/{jobexecutionid}", this.reusablePathItem);
        Operation operationJobExecutionIdJobLogs = new Operation().tags(this.allTags).summary("Get info about job logs").description("This URI returns a JSON array with REST links to all job log parts for the specified job execution. The URI takes in a optional \"type\" parameter which specifies the format the job log parts are returned as. Either as plain text (type=text) or in a compressed file (type=zip).").addParametersItem(new PathParameter().name("jobexecutionid").schema((Schema)new IntegerSchema().format("int64"))).addParametersItem(new QueryParameter().name("part").schema((Schema)new StringSchema()).required(Boolean.valueOf(false))).addParametersItem(new QueryParameter().name("type").required(Boolean.valueOf(false)).schema((Schema)new StringSchema()._enum(Arrays.asList("text", "zip")))).responses(new ApiResponses().addApiResponse("200", new ApiResponse().description("successful operation").content(this.tripleContent)).addApiResponse("302", new ApiResponse().description("The request was redirected to the correct executor")));
        this.openapi.getPaths().addPathItem("/ibm/api/batch/jobexecutions/{jobexecutionid}/joblogs", new PathItem().get(operationJobExecutionIdJobLogs));
        this.openapi.getPaths().addPathItem("/ibm/api/batch/v1/jobexecutions/{jobexecutionid}/joblogs", new PathItem().get(operationJobExecutionIdJobLogs));
        Operation operationJobExecutionIdJobInstance = new Operation().tags(this.allTags).summary("Get information about a job instance").description("This URI returns detailed information about the job instance of a specified job execution.").addParametersItem(new PathParameter().name("jobexecutionid").schema((Schema)new IntegerSchema().format("int64"))).responses(new ApiResponses().addApiResponse("200", new ApiResponse().description("successful operation").content(this.defaultContent)));
        this.openapi.getPaths().addPathItem("/ibm/api/batch/jobexecutions/{jobexecutionid}/jobinstance", new PathItem().get(operationJobExecutionIdJobInstance));
        this.openapi.getPaths().addPathItem("/ibm/api/batch/v1/jobexecutions/{jobexecutionid}/jobinstance", new PathItem().get(operationJobExecutionIdJobInstance));
        Operation operationJobInstancesIdJobExecutions = new Operation().tags(this.allTags).summary("Get job execution information about a job instance").description("This URI returns detailed information about job executions for a specified job instance ID.").addParametersItem(new PathParameter().name("jobinstanceid").schema((Schema)new IntegerSchema().format("int64"))).responses(new ApiResponses().addApiResponse("200", new ApiResponse().description("successful operation").content(this.defaultContent)));
        this.openapi.getPaths().addPathItem("/ibm/api/batch/jobinstances/{jobinstanceid}/jobexecutions", new PathItem().get(operationJobInstancesIdJobExecutions));
        this.openapi.getPaths().addPathItem("/ibm/api/batch/v1/jobinstances/{jobinstanceid}/jobexecutions", new PathItem().get(operationJobInstancesIdJobExecutions));
        Operation operationJobInstancesIdJobExecutionsNumber = new Operation().tags(this.allTags).summary("Get information about a job execution number").description("This URI returns detailed information about a specified job execution in relation to the specified job instance. This includes links to associated step executions and job logs. Note: The job execution number means the 0th, 1st, 2nd, etc. job execution related to the specified job instance.").addParametersItem(new PathParameter().name("jobinstanceid").schema((Schema)new IntegerSchema().format("int64"))).addParametersItem(new PathParameter().name("jobexecutionnumber").schema((Schema)new IntegerSchema().format("int32"))).responses(new ApiResponses().addApiResponse("200", new ApiResponse().description("sucessful operation").content(this.defaultContent)));
        this.openapi.getPaths().addPathItem("/ibm/api/batch/jobinstances/{jobinstanceid}/jobexecutions/{jobexecutionnumber}", new PathItem().get(operationJobInstancesIdJobExecutionsNumber));
        this.openapi.getPaths().addPathItem("/ibm/api/batch/v1/jobinstances/{jobinstanceid}/jobexecutions/{jobexecutionnumber}", new PathItem().get(operationJobInstancesIdJobExecutionsNumber));
        Operation operationJobInstancesIdJobExecutionsIdJobLogs = new Operation().tags(this.allTags).summary("Get info about job logs").description("This URI returns a JSON array with REST links to all job log parts for the specified job execution. The URI takes in a optional \"type\" parameter which specifies the format the job log parts are returned as. Either as plain text (type=text) or in a compressed file (type=zip).").addParametersItem(new PathParameter().name("jobexecutionid").schema((Schema)new IntegerSchema().format("int64"))).addParametersItem(new PathParameter().name("jobinstanceid").schema((Schema)new IntegerSchema().format("int64"))).addParametersItem(new QueryParameter().name("part").schema((Schema)new StringSchema()).required(Boolean.valueOf(false))).addParametersItem(new QueryParameter().name("type").required(Boolean.valueOf(false)).schema((Schema)new StringSchema()._enum(Arrays.asList("text", "zip")))).responses(new ApiResponses().addApiResponse("200", new ApiResponse().description("successful operation").content(this.tripleContent)).addApiResponse("302", new ApiResponse().description("The request was redirected to the correct executor")));
        this.openapi.getPaths().addPathItem("/ibm/api/batch/jobinstances/{jobinstanceid}/jobexecutions/{jobexecutionid}/joblogs", new PathItem().get(operationJobInstancesIdJobExecutionsIdJobLogs));
        this.openapi.getPaths().addPathItem("/ibm/api/batch/v1/jobinstances/{jobinstanceid}/jobexecutions/{jobexecutionid}/joblogs", new PathItem().get(operationJobInstancesIdJobExecutionsIdJobLogs));
    }

    private void populateJobInstancesDocument() {
        QueryParameter jobInstanceId = new QueryParameter();
        jobInstanceId.name("jobInstanceId").schema((Schema)new StringSchema()).required(Boolean.valueOf(false)).description("jobInstanceId=[instanceId]:[instanceId]: Returns job instances equal to and between the instanceId range.\r\njobInstanceId=>[instanceId]: Returns job instances equal to and greater than the provided instanceId.\r\njobInstanceId=<[instanceId]: Returns job instances equal to and less than the provided instanceId.\r\njobInstanceId=[instanceId],[instanceId],[instanceId]: Returns job instances specified.\r\n");
        QueryParameter createTime = new QueryParameter();
        createTime.name("createTime").schema((Schema)new StringSchema()).required(Boolean.valueOf(false)).description("createTime=[yyyy-MM-dd]:[yyy-MM-dd]: Returns job instances between the date range.\r\ncreateTime=[yyyy-MM-dd]: Returns job instances on the given date.\r\ncreateTime=>3d: Returns job instances created including and after 3 days ago UTC.\r\ncreateTime=<3d: Returns job instances created including and before 3 days ago UTC.");
        QueryParameter instanceState = new QueryParameter();
        instanceState.name("instanceState").schema((Schema)new StringSchema()).required(Boolean.valueOf(false)).description("Returns job instances with the provided state. Valid instance states are SUBMITTED, JMS_QUEUED, JMS_CONSUMED, DISPATCHED, FAILED, STOPPED, COMPLETED, and ABANDONED. Multiple state values may be separated by a comma.");
        QueryParameter exitStatus = new QueryParameter();
        exitStatus.name("exitStatus").schema((Schema)new StringSchema()).required(Boolean.valueOf(false)).description("Returns job instances matching the exit status string.");
        QueryParameter exitStatusMulti = new QueryParameter();
        exitStatusMulti.name("exitStatus").schema((Schema)new ArraySchema().items((Schema)new StringSchema())).style(Parameter.StyleEnum.FORM).required(Boolean.valueOf(false)).description("Returns job instances matching the exit status string.");
        QueryParameter lastUpdatedTime = new QueryParameter();
        lastUpdatedTime.name("lastUpdatedTime").schema((Schema)new StringSchema()).required(Boolean.valueOf(false)).description("lastUpdatedTime=[yyyy-MM-dd]: Returns job instances that were last updated on the given date. This time value is updated on transitions of instance state. For example, from SUBMITTED to DISPATCHED.\r\nlastUpdatedTime=[yyyy-MM-dd]:[yyy-MM-dd]: Returns job instances last updated within the date range.\r\ncreateTime=>3d: Returns job instances last updated including and after 3 days ago UTC.\r\ncreateTime=<3d: Returns job instances last updated including and before 3 days ago UTC.");
        QueryParameter jobParameter = new QueryParameter();
        jobParameter.name("jobParameter").schema((Schema)new StringSchema()).required(Boolean.valueOf(false)).description("jobParameter.[paramName]=[paramValue]: Returns job instances with executions that have the supplied name:value pair as a job parameter.");
        QueryParameter submitter = new QueryParameter();
        submitter.name("submitter").schema((Schema)new ArraySchema().items((Schema)new StringSchema())).style(Parameter.StyleEnum.FORM).required(Boolean.valueOf(false)).description("Returns all job instances that were submitted by the specified user.");
        QueryParameter appName = new QueryParameter();
        appName.name("appName").schema((Schema)new ArraySchema().items((Schema)new StringSchema())).style(Parameter.StyleEnum.FORM).required(Boolean.valueOf(false)).description("Returns all job instances with the specified application name. This can be either the simple application name, or the full app-module-component name. For example, a search for either MyApp or MyApp#MyApp.war will return a job instance with an application name of MyApp and module name of MyApp.war.");
        QueryParameter jobName = new QueryParameter();
        jobName.name("jobName").schema((Schema)new ArraySchema().items((Schema)new StringSchema())).style(Parameter.StyleEnum.FORM).required(Boolean.valueOf(false)).description("Returns all job instances with the specified job name.");
        QueryParameter ignoreCase = new QueryParameter();
        ignoreCase.name("ignoreCase").schema((Schema)new BooleanSchema()).required(Boolean.valueOf(false)).description("By default, all text matching is case-sensitive. Specifying ignoreCase=true changes all text search terms to not be case sensitive.");
        QueryParameter sort = new QueryParameter();
        sort.name("sort").schema((Schema)new StringSchema()).required(Boolean.valueOf(false)).description("Specifies the parameter or parameters to sort the results by. Using the - character to prefix the parameter specifies that sorting will be done in descending order. For example,sort=submitter sorts the results by submitter in ascending order. Specifying sort=submitter,-lastUpdatedTime sorts the results first by submitter in ascending order, and then by lastUpdatedTime, in descending order.");
        QueryParameter page = new QueryParameter();
        page.name("page").schema((Schema)new IntegerSchema().format("int32")).required(Boolean.valueOf(false)).description("Indicates which page (subset of records) to return. The default is 0.");
        QueryParameter pageSize = new QueryParameter();
        pageSize.name("pageSize").schema((Schema)new IntegerSchema().format("int32")).required(Boolean.valueOf(false)).description("Indicates the number of records per page. The default is 50.");
        QueryParameter purgeJobStoreOnly = new QueryParameter();
        purgeJobStoreOnly.name("purgeJobStoreOnly").schema((Schema)new BooleanSchema()._default(Boolean.valueOf(false))).required(Boolean.valueOf(false)).description("When purgeJobStoreOnly=true, no attempt is made to purge the job logs associated with this job instance. The default setting is purgeJobStoreOnly=false. This API returns an error if the job instance has active job executions.");
        Operation operationGetJobInstances = new Operation().tags(this.allTags).summary("Get a list of job instances").description("This URI returns a list of job instances.").addParametersItem((Parameter)page).addParametersItem((Parameter)pageSize).responses(new ApiResponses().addApiResponse("200", new ApiResponse().description("successful operation").content(this.defaultContent)));
        this.reusablePathItem = new PathItem().get(operationGetJobInstances);
        Operation operationPostJobInstances = new Operation().tags(this.allTags).summary("Submit (start) a new job").description("This URI submits (starts) a new job. ").requestBody(new RequestBody().description("The parameters that are passed in when the job is submitted").required(Boolean.valueOf(false)).content(new Content().addMediaType("application/json", new MediaType().schema(this.getPOSTModel())))).responses(new ApiResponses().addApiResponse("201", new ApiResponse().description("successful operation").content(this.defaultContent)));
        this.reusablePathItem.post(operationPostJobInstances);
        this.openapi.getPaths().addPathItem("/ibm/api/batch/jobinstances", this.reusablePathItem);
        this.openapi.getPaths().addPathItem("/ibm/api/batch/v1/jobinstances", this.reusablePathItem);
        Operation operationGetJobInstancesId = new Operation().tags(this.allTags).summary("Get information about a job instance").description("This URI returns detailed information about the specified job instance such as all executions that are associated with a specified job instance. Results are returned in order from most recent to the oldest. The most recent result is displayed first in the list.").addParametersItem(new PathParameter().name("jobinstanceid").schema((Schema)new IntegerSchema().format("int64"))).responses(new ApiResponses().addApiResponse("200", new ApiResponse().description("successful operation").content(this.defaultContent)));
        this.reusablePathItem = new PathItem().get(operationGetJobInstancesId);
        Operation operationPutJobInstancesId = new Operation().tags(this.allTags).summary("Stop or restart a job instance").description("Use this URI to stop or restart the most recent job execution that is associated with this job instance. When action is 'stop', this API will stop the most recent job execution that is associated with this job instance if it is running or else the API returns an error if it is not running. When action is 'restart', this API will restart the most recent job execution that is associated with this job instance only if it is in STOPPED or FAILED state. If no job execution is associated with this instance, or the latest job execution is in COMPLETED state, the API returns an error. Note that reusePreviousParams is an optional setting and when its value is true, any job parameters that are submitted as part of the current restart request take precedence over any previous job parameters. Current parameters override previous parameters with the same job parameter key name. ").addParametersItem(new PathParameter().name("jobinstanceid").schema((Schema)new IntegerSchema().format("int64"))).addParametersItem(new QueryParameter().name("action").schema((Schema)new StringSchema()._enum(Arrays.asList("stop", "restart"))).required(Boolean.valueOf(true))).addParametersItem(new QueryParameter().name("reusePreviousParams").schema((Schema)new BooleanSchema()._default(Boolean.valueOf(false))).required(Boolean.valueOf(false))).requestBody(new RequestBody().description("The job parameters passed into a restart. This field is only used when action=restart and is always optional").required(Boolean.valueOf(false)).content(new Content().addMediaType("application/json", new MediaType().schema(this.getPutModel())))).responses(new ApiResponses().addApiResponse("200", new ApiResponse().description("successful operation").content(this.defaultContent)).addApiResponse("302", new ApiResponse().description("The request was redirected to the correct executor")));
        this.reusablePathItem.put(operationPutJobInstancesId);
        Operation operationDeleteJobInstancesId = new Operation().tags(this.allTags).summary("Delete related information of a job instance").description("This URI purges all database entries and job logs that are associated with this job instance. This API returns an error if the job instance has active job executions. If there is an error when you delete the job logs, then no attempt is made to delete the job instance data from the job store database. When purgeJobStoreOnly is true, no attempt is made to purge the job logs associated with this job instance. This API returns an error if the job instance has active job executions.").addParametersItem(new PathParameter().name("jobinstanceid").schema((Schema)new IntegerSchema().format("int64"))).addParametersItem((Parameter)purgeJobStoreOnly).responses(new ApiResponses().addApiResponse("200", new ApiResponse().description("Successful operation.").content(this.defaultContent)).addApiResponse("302", new ApiResponse().description("The request was redirected to the correct executor")));
        this.reusablePathItem.delete(operationDeleteJobInstancesId);
        this.openapi.getPaths().addPathItem("/ibm/api/batch/jobinstances/{jobinstanceid}", this.reusablePathItem);
        this.openapi.getPaths().addPathItem("/ibm/api/batch/v1/jobinstances/{jobinstanceid}", this.reusablePathItem);
        Operation operationJobInstancesIdJobLogs = new Operation().tags(this.allTags).summary("Get info about job logs").description("This URI returns a JSON array with REST links to all job log parts for the specified job instance. The URI takes in a optional \"type\" parameter which specifies the format the job log parts are returned as. Either as plain text (type=text) or in a compressed file (type=zip).").addParametersItem(new PathParameter().name("jobinstanceid").schema((Schema)new IntegerSchema().format("int64"))).addParametersItem(new QueryParameter().name("type").required(Boolean.valueOf(false)).schema((Schema)new StringSchema()._enum(Arrays.asList("text", "zip"))._default("text"))).responses(new ApiResponses().addApiResponse("200", new ApiResponse().description("successful operation").content(this.tripleContent)).addApiResponse("302", new ApiResponse().description("The request was redirected to the correct executor")));
        this.openapi.getPaths().addPathItem("/ibm/api/batch/jobinstances/{jobinstanceid}/joblogs", new PathItem().get(operationJobInstancesIdJobLogs));
        this.openapi.getPaths().addPathItem("/ibm/api/batch/v1/jobinstances/{jobinstanceid}/joblogs", new PathItem().get(operationJobInstancesIdJobLogs));
        Operation operationDeleteJobInstancesIdJobLogs = new Operation().tags(this.allTags).summary("Delete local job logs").description("This URI purges the local job logs for the given job instance id from this endpoint only.").addParametersItem(new PathParameter().name("jobinstanceid").schema((Schema)new IntegerSchema().format("int64"))).responses(new ApiResponses().addApiResponse("200", new ApiResponse().description("successful operation").content(this.defaultContent)));
        this.openapi.getPaths().addPathItem("/ibm/api/batch/jobinstances/{jobinstanceid}/joblogs", new PathItem().delete(operationDeleteJobInstancesIdJobLogs));
        this.openapi.getPaths().addPathItem("/ibm/api/batch/v1/jobinstances/{jobinstanceid}/joblogs", new PathItem().delete(operationDeleteJobInstancesIdJobLogs));
        Operation operationGetJobInstancesV2 = new Operation().tags(this.allTags).summary("Get the list of job instances").description("This URI returns a list of job instances, filtered by the query parameters. String criteria may use the wildcard(*) operator anywhere in the string.").addParametersItem((Parameter)jobInstanceId).addParametersItem((Parameter)createTime).addParametersItem((Parameter)instanceState).addParametersItem((Parameter)exitStatus).addParametersItem((Parameter)page).addParametersItem((Parameter)pageSize).responses(new ApiResponses().addApiResponse("200", new ApiResponse().description("successful operation").content(this.defaultContent)));
        this.reusablePathItem = new PathItem().get(operationGetJobInstancesV2);
        Operation operationDeleteJobInstancesV2 = new Operation().tags(this.allTags).summary("Delete related info of the specified job instances").description("This URI purges all database entries and job logs associated with the job instances, filtered by the query parameters. String criteria may use the wildcard(*) operator anywhere in the string.").addParametersItem((Parameter)jobInstanceId).addParametersItem((Parameter)createTime).addParametersItem((Parameter)instanceState).addParametersItem((Parameter)exitStatus).addParametersItem((Parameter)page).addParametersItem((Parameter)pageSize).addParametersItem((Parameter)purgeJobStoreOnly).responses(new ApiResponses().addApiResponse("200", new ApiResponse().description("Successful operation. The response may contain one of the following purgeStatus values: COMPLETED (job purge completed successfully.), FAILED (job purge failed.), STILL_ACTIVE (job purge failed because it was still active.), JOBLOGS_ONLY (database purge failed, but that the job logs were successfully purged.), NOT_LOCAL (job purge failed because the job is not local).").content(this.defaultContent)).addApiResponse("302", new ApiResponse().description("The request was redirected to the correct executor")));
        this.reusablePathItem.delete(operationDeleteJobInstancesV2);
        this.openapi.getPaths().addPathItem("/ibm/api/batch/v2/jobinstances", this.reusablePathItem);
        Operation operationGetJobInstancesV3 = new Operation().tags(this.allTags).summary("Get the list of job instances").description("This URI returns a list of job instances, filtered by the query parameters. String criteria may use the wildcard(*) operator anywhere in the string.").addParametersItem((Parameter)jobInstanceId).addParametersItem((Parameter)createTime).addParametersItem((Parameter)instanceState).addParametersItem((Parameter)exitStatus).addParametersItem((Parameter)lastUpdatedTime).addParametersItem((Parameter)jobParameter).addParametersItem((Parameter)sort).addParametersItem((Parameter)page).addParametersItem((Parameter)pageSize).responses(new ApiResponses().addApiResponse("200", new ApiResponse().description("successful operation").content(this.defaultContent)));
        this.reusablePathItem = new PathItem().get(operationGetJobInstancesV3);
        Operation operationDeleteJobInstancesV3 = new Operation().tags(this.allTags).summary("Delete related info of the specified job instances").description("This URI purges all database entries and job logs associated with the job instances, filtered by the query parameters. String criteria may use the wildcard(*) operator anywhere in the string.").addParametersItem((Parameter)jobInstanceId).addParametersItem((Parameter)createTime).addParametersItem((Parameter)instanceState).addParametersItem((Parameter)exitStatus).addParametersItem((Parameter)lastUpdatedTime).addParametersItem((Parameter)jobParameter).addParametersItem((Parameter)page).addParametersItem((Parameter)pageSize).addParametersItem((Parameter)purgeJobStoreOnly).responses(new ApiResponses().addApiResponse("200", new ApiResponse().description("Successful operation. The response may contain one of the following purgeStatus values: COMPLETED (job purge completed successfully.), FAILED (job purge failed.), STILL_ACTIVE (job purge failed because it was still active.), JOBLOGS_ONLY (database purge failed, but that the job logs were successfully purged.), NOT_LOCAL (job purge failed because the job is not local).").content(this.defaultContent)).addApiResponse("302", new ApiResponse().description("The request was redirected to the correct executor")));
        this.reusablePathItem.delete(operationDeleteJobInstancesV3);
        this.openapi.getPaths().addPathItem("/ibm/api/batch/v3/jobinstances", this.reusablePathItem);
        Operation operationGetJobInstancesv4 = new Operation().tags(this.allTags).summary("Get the list of job instances").description("This URI returns a list of job instances, filtered by the query parameters. String criteria may use the wildcard(*) operator anywhere in the string.").addParametersItem((Parameter)jobInstanceId).addParametersItem((Parameter)createTime).addParametersItem((Parameter)instanceState).addParametersItem((Parameter)exitStatusMulti).addParametersItem((Parameter)lastUpdatedTime).addParametersItem((Parameter)jobParameter).addParametersItem((Parameter)submitter).addParametersItem((Parameter)appName).addParametersItem((Parameter)jobName).addParametersItem((Parameter)ignoreCase).addParametersItem((Parameter)sort).addParametersItem((Parameter)page).addParametersItem((Parameter)pageSize).responses(new ApiResponses().addApiResponse("200", new ApiResponse().description("successful operation").content(this.defaultContent)));
        this.reusablePathItem = new PathItem().get(operationGetJobInstancesv4);
        Operation operationDeleteJobInstancesv4 = new Operation().tags(this.allTags).summary("Delete related info of the specified job instances").description("This URI purges all database entries and job logs associated with the job instances, filtered by the query parameters. String criteria may use the wildcard(*) operator anywhere in the string.").addParametersItem((Parameter)jobInstanceId).addParametersItem((Parameter)createTime).addParametersItem((Parameter)instanceState).addParametersItem((Parameter)exitStatusMulti).addParametersItem((Parameter)lastUpdatedTime).addParametersItem((Parameter)jobParameter).addParametersItem((Parameter)submitter).addParametersItem((Parameter)appName).addParametersItem((Parameter)jobName).addParametersItem((Parameter)ignoreCase).addParametersItem((Parameter)page).addParametersItem((Parameter)pageSize).addParametersItem((Parameter)purgeJobStoreOnly).responses(new ApiResponses().addApiResponse("200", new ApiResponse().description("Successful operation. The response may contain one of the following purgeStatus values: COMPLETED (job purge completed successfully.), FAILED (job purge failed.), STILL_ACTIVE (job purge failed because it was still active.), JOBLOGS_ONLY (database purge failed, but that the job logs were successfully purged.), NOT_LOCAL (job purge failed because the job is not local).").content(this.defaultContent)).addApiResponse("302", new ApiResponse().description("The request was redirected to the correct executor")));
        this.reusablePathItem.delete(operationDeleteJobInstancesv4);
        this.openapi.getPaths().addPathItem("/ibm/api/batch/v4/jobinstances", this.reusablePathItem);
    }

    private void populateStepExecutionsDocument() {
        Operation operationGetJobInstances = new Operation().tags(this.allTags).summary("Get a list of step executions").description("This URI returns a JSON array of all the step execution details for the specified job execution. If your job contains a partitioned step, the partition information will be returned listed within each step.").addParametersItem(new PathParameter().name("jobexecutionid").schema((Schema)new IntegerSchema().format("int64"))).responses(new ApiResponses().addApiResponse("200", new ApiResponse().description("successful operation").content(this.defaultContent)));
        this.openapi.getPaths().addPathItem("/ibm/api/batch/jobexecutions/{jobexecutionid}/stepexecutions", new PathItem().get(operationGetJobInstances));
        this.openapi.getPaths().addPathItem("/ibm/api/batch/v1/jobexecutions/{jobexecutionid}/stepexecutions", new PathItem().get(operationGetJobInstances));
        Operation operationGetJobExecutionsIdStepExecutionsName = new Operation().tags(this.allTags).summary("Get info about a step execution").description("This URI returns a JSON array containing the step execution details for the specified job execution and step name.").addParametersItem(new PathParameter().name("jobexecutionid").schema((Schema)new IntegerSchema().format("int64"))).addParametersItem(new PathParameter().name("stepname").schema((Schema)new StringSchema())).responses(new ApiResponses().addApiResponse("200", new ApiResponse().description("successful operation").content(this.defaultContent)));
        this.openapi.getPaths().addPathItem("/ibm/api/batch/jobexecutions/{jobexecutionid}/stepexecutions/{stepname}", new PathItem().get(operationGetJobExecutionsIdStepExecutionsName));
        this.openapi.getPaths().addPathItem("/ibm/api/batch/v1/jobexecutions/{jobexecutionid}/stepexecutions/{stepname}", new PathItem().get(operationGetJobExecutionsIdStepExecutionsName));
        Operation operationGetStepExecutionsId = new Operation().tags(this.allTags).summary("Get info about a step execution").description("This URI returns a JSON array containing the step execution details for the specified step execution.").addParametersItem(new PathParameter().name("stepexecutionid").schema((Schema)new IntegerSchema().format("int64"))).responses(new ApiResponses().addApiResponse("200", new ApiResponse().description("successful operation").content(this.defaultContent)));
        this.openapi.getPaths().addPathItem("/ibm/api/batch/stepexecutions/{stepexecutionid}", new PathItem().get(operationGetStepExecutionsId));
        this.openapi.getPaths().addPathItem("/ibm/api/batch/v1/stepexecutions/{stepexecutionid}", new PathItem().get(operationGetStepExecutionsId));
        Operation operationGetJobInstancesIdJobExecutionsIdStepExecutionsId = new Operation().tags(this.allTags).summary("Get info about step executions").description("This URI returns a JSON array containing the step execution details for the specified job instance, job execution, and step name.").addParametersItem(new PathParameter().name("jobinstanceid").schema((Schema)new IntegerSchema().format("int64"))).addParametersItem(new PathParameter().name("jobexecutionnumber").schema((Schema)new IntegerSchema().format("int32"))).addParametersItem(new PathParameter().name("stepname").schema((Schema)new StringSchema())).responses(new ApiResponses().addApiResponse("200", new ApiResponse().description("successful operation").content(this.defaultContent)));
        this.openapi.getPaths().addPathItem("/ibm/api/batch/jobinstances/{jobinstanceid}/jobexecutions/{jobexecutionnumber}/stepexecutions/{stepname}", new PathItem().get(operationGetJobInstancesIdJobExecutionsIdStepExecutionsId));
        this.openapi.getPaths().addPathItem("/ibm/api/batch/v1/jobinstances/{jobinstanceid}/jobexecutions/{jobexecutionnumber}/stepexecutions/{stepname}", new PathItem().get(operationGetJobInstancesIdJobExecutionsIdStepExecutionsId));
    }

    private void populateBatchRoot() {
        HashMap<String, StringSchema> innerProperties = new HashMap<String, StringSchema>();
        innerProperties.put("rel", new StringSchema());
        innerProperties.put("href", new StringSchema());
        ArraySchema arraySchema = new ArraySchema().items(new ObjectSchema().properties(innerProperties));
        Schema linksSchema = new ObjectSchema().properties(Collections.singletonMap("_links", arraySchema));
        Content linksContent = new Content().addMediaType("application/json", new MediaType().schema(linksSchema));
        Operation operation = new Operation().tags(this.allTags).summary("Get the list of resources").description("Returns a list of available resources.").responses(new ApiResponses().addApiResponse("200", new ApiResponse().description("successful operation").content(linksContent)));
        this.openapi.getPaths().addPathItem("/ibm/api/batch", new PathItem().get(operation));
    }

    private Map<String, Schema> getPropsMap() {
        HashMap<String, Schema> props = new HashMap<String, Schema>();
        props.put("prop1", new StringSchema().example((Object)"prop1value"));
        props.put("prop2", new StringSchema().example((Object)"prop2value"));
        return props;
    }

    private Schema getPutModel() {
        HashMap<String, Schema> props = new HashMap<String, Schema>();
        props.put("jobParameters", new ObjectSchema().properties(this.getPropsMap()).description("The job parameters you wish to submit with your job. The jobParameters are not required."));
        Schema putModel = new ObjectSchema().description("Sample model").properties(props);
        return putModel;
    }

    private Schema getPOSTModel() {
        HashMap<String, Schema> props = new HashMap<String, Schema>();
        props.put("applicationName", new StringSchema().example((Object)"BonusPayout").description("The applicationName identifies the batch application. It is required unless moduleName is specified, in which case the applicationName is derived from the moduleName by trimming off the .war or .jar suffix of the moduleName."));
        props.put("moduleName", new StringSchema().example((Object)"BonusPayout.war").description("The moduleName identifies the module within the batch application that contains the job artifacts, such as the JSL. The job is submitted under the module's component context. The moduleName is required unless applicationName is specified, in which case the moduleName is derived from the applicationName by appending .war to the applicationName. "));
        props.put("componentName", new StringSchema().example((Object)" ").description("The componentName identifies the EJB component within the batch application EJB module. If specified, the job is submitted under the EJB's component context. Note: The componentName is required only when the module is an EJB module. When the module is a WAR module, the componentName is not required. "));
        props.put("jobXMLName", new StringSchema().example((Object)"BonusPayoutJob").description("The job XML name. Note: this field is required unless jobXML is specified since the job ID information in the inline JSL is used for the job name."));
        props.put("jobXML", new StringSchema().example((Object)" ").description("As an alternative to using the JSL job definition that is packaged within your batch application under META-INF/batch-jobs, you can pass your JSL inline as part of your REST job submission request. The JSL that is submitted inline always overrides any JSL that is packaged with the batch application."));
        props.put("jobParameters", new ObjectSchema().properties(this.getPropsMap()).description("The job parameters you wish to submit with your job. The jobParameters are not required."));
        Schema postModel = new ObjectSchema().description("Sample model").properties(props);
        return postModel;
    }

    public List<OASProviderResult> getResults() {
        if (this.results == null) {
            OASProviderResult result = new OASProviderResult(){
                static final long serialVersionUID = -9055002883295499989L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public OpenAPI getOpenAPI() {
                    if (BatchOASProviderImpl.this.openapi == null) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            Tr.event((Object)this, (TraceComponent)tc, (String)"Creating Batch OpenAPI model", (Object[])new Object[0]);
                        }
                        BatchOASProviderImpl.this.populateDocument();
                    }
                    return BatchOASProviderImpl.this.openapi;
                }

                public String getDocument() {
                    return null;
                }

                public OASProviderConfig getOASProviderConfig() {
                    return OASProviderConfig.defaultConfig();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.openapi.batch.BatchOASProviderImpl$1", 1.class, (String)"BatchOASProvider", null);
                }
            };
            this.results = Arrays.asList(result);
        }
        return this.results;
    }

    public String getContextRoot() {
        return "/ibm/api/batch";
    }

    public boolean isPublic() {
        return false;
    }
}

