/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.converter;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.swagger.converter.ModelConverter;
import io.swagger.converter.ModelConverterContext;
import io.swagger.oas.models.media.Schema;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ModelConverterContextImpl
implements ModelConverterContext {
    private final List<ModelConverter> converters;
    private final Map<String, Schema> modelByName;
    private final HashMap<Type, Schema> modelByType;
    private final Set<Type> processedTypes;
    static final long serialVersionUID = 4192061958084580021L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ModelConverterContextImpl(List<ModelConverter> converters) {
        this.converters = converters;
        this.modelByName = new TreeMap<String, Schema>();
        this.modelByType = new HashMap();
        this.processedTypes = new HashSet<Type>();
    }

    public ModelConverterContextImpl(ModelConverter converter) {
        this(new ArrayList<ModelConverter>());
        this.converters.add(converter);
    }

    @Override
    public Iterator<ModelConverter> getConverters() {
        return this.converters.iterator();
    }

    @Override
    public void defineModel(String name, Schema model) {
        this.defineModel(name, model, null, null);
    }

    @Override
    public void defineModel(String name, Schema model, Type type, String prevName) {
        this.modelByName.put(name, model);
        if (StringUtils.isNotBlank((CharSequence)prevName) && !prevName.equals(name)) {
            this.modelByName.remove(prevName);
        }
        if (type != null) {
            this.modelByType.put(type, model);
        }
    }

    public Map<String, Schema> getDefinedModels() {
        return Collections.unmodifiableMap(this.modelByName);
    }

    @Override
    public Schema resolve(Type type) {
        if (this.processedTypes.contains(type)) {
            return this.modelByType.get(type);
        }
        this.processedTypes.add(type);
        Iterator<ModelConverter> converters = this.getConverters();
        Schema resolved = null;
        if (converters.hasNext()) {
            ModelConverter converter = converters.next();
            resolved = converter.resolve(type, this, converters);
        }
        if (resolved != null) {
            this.modelByType.put(type, resolved);
            Schema resolvedImpl = resolved;
            if (resolvedImpl.getTitle() != null) {
                this.modelByName.put(resolvedImpl.getTitle(), resolved);
            }
        }
        return resolved;
    }

    @Override
    public Schema resolve(Type type, Annotation[] annotations) {
        Iterator<ModelConverter> converters = this.getConverters();
        if (converters.hasNext()) {
            ModelConverter converter = converters.next();
            return converter.resolve(type, this, annotations, converters);
        }
        return null;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.swagger.converter.ModelConverterContextImpl", ModelConverterContextImpl.class, null, null);
    }
}

