/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.core.filter;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.swagger.core.filter.AbstractSpecFilter;
import io.swagger.core.filter.SwaggerSpecFilter;
import io.swagger.model.ApiDescription;
import io.swagger.oas.models.OpenAPI;
import io.swagger.oas.models.Operation;
import io.swagger.oas.models.PathItem;
import io.swagger.oas.models.media.Schema;
import io.swagger.oas.models.parameters.Parameter;
import io.swagger.oas.models.tags.Tag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SpecFilter {
    static final long serialVersionUID = 8041673259791983787L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public OpenAPI filter(OpenAPI swagger, SwaggerSpecFilter filter, Map<String, List<String>> params, Map<String, String> cookies, Map<String, List<String>> headers) {
        OpenAPI clone = new OpenAPI();
        clone.info(swagger.getInfo()).tags((List)(swagger.getTags() == null ? null : new ArrayList(swagger.getTags())));
        HashSet filteredTags = new HashSet();
        HashSet allowedTags = new HashSet();
        for (String resourcePath : swagger.getPaths().keySet()) {
            PathItem path = (PathItem)swagger.getPaths().get((Object)resourcePath);
            HashMap<String, Operation> ops = new HashMap<String, Operation>();
            ops.put("get", path.getGet());
            ops.put("head", path.getHead());
            ops.put("put", path.getPut());
            ops.put("post", path.getPost());
            ops.put("delete", path.getDelete());
            ops.put("patch", path.getPatch());
            ops.put("options", path.getOptions());
            PathItem clonedPath = new PathItem();
            for (String key : ops.keySet()) {
                Operation op = (Operation)ops.get(key);
                if (op == null) continue;
                ApiDescription description = new ApiDescription(resourcePath, key);
                HashSet tags = filter.isOperationAllowed(op, description, params, cookies, headers) ? allowedTags : filteredTags;
                if (op.getTags() == null) continue;
                tags.addAll(op.getTags());
            }
        }
        List tags = clone.getTags();
        filteredTags.removeAll(allowedTags);
        if (tags != null && !filteredTags.isEmpty()) {
            Iterator it = tags.iterator();
            while (it.hasNext()) {
                if (!filteredTags.contains(((Tag)it.next()).getName())) continue;
                it.remove();
            }
            if (clone.getTags().isEmpty()) {
                clone.setTags(null);
            }
        }
        Map<String, Schema> definitions = this.filterDefinitions(filter, swagger.getComponents().getSchemas(), params, cookies, headers);
        clone.setSecurity(swagger.getSecurity());
        if (filter instanceof AbstractSpecFilter && ((AbstractSpecFilter)filter).isRemovingUnreferencedDefinitions()) {
            clone = this.removeBrokenReferenceDefinitions(clone);
        }
        return clone;
    }

    private OpenAPI removeBrokenReferenceDefinitions(OpenAPI swagger) {
        if (swagger.getComponents().getSchemas() == null || swagger.getComponents().getSchemas().isEmpty()) {
            return swagger;
        }
        TreeSet<String> referencedDefinitions = new TreeSet<String>();
        if (swagger.getComponents().getResponses() != null) {
            for (Object object : swagger.getComponents().getResponses().values()) {
            }
        }
        if (swagger.getComponents().getParameters() != null) {
            for (Object object : swagger.getComponents().getParameters().values()) {
            }
        }
        if (swagger.getPaths() != null) {
            for (PathItem path : swagger.getPaths().values()) {
                if (path.getParameters() == null) continue;
                for (Parameter parameter : path.getParameters()) {
                }
            }
        }
        if (swagger.getComponents().getSchemas() != null) {
            TreeSet<String> nestedReferencedDefinitions = new TreeSet<String>();
            for (String ref : referencedDefinitions) {
                this.locateReferencedDefinitions(ref, nestedReferencedDefinitions, swagger);
            }
            referencedDefinitions.addAll(nestedReferencedDefinitions);
            swagger.getComponents().getSchemas().keySet().retainAll(referencedDefinitions);
        }
        return swagger;
    }

    private void locateReferencedDefinitions(Map<String, Schema> props, Set<String> nestedReferencedDefinitions, OpenAPI swagger) {
        if (props == null) {
            return;
        }
        for (String keyProp : props.keySet()) {
            Schema p = props.get(keyProp);
            String ref = this.getPropertyRef(p);
            if (ref == null) continue;
            this.locateReferencedDefinitions(ref, nestedReferencedDefinitions, swagger);
        }
    }

    private void locateReferencedDefinitions(String ref, Set<String> nestedReferencedDefinitions, OpenAPI swagger) {
        if (!nestedReferencedDefinitions.contains(ref)) {
            nestedReferencedDefinitions.add(ref);
            Schema model = (Schema)swagger.getComponents().getSchemas().get(ref);
            if (model != null) {
                this.locateReferencedDefinitions(model.getProperties(), nestedReferencedDefinitions, swagger);
            }
        }
    }

    public Map<String, Schema> filterDefinitions(SwaggerSpecFilter filter, Map<String, Schema> definitions, Map<String, List<String>> params, Map<String, String> cookies, Map<String, List<String>> headers) {
        if (definitions == null) {
            return null;
        }
        LinkedHashMap<String, Schema> clonedDefinitions = new LinkedHashMap<String, Schema>();
        for (String key : definitions.keySet()) {
            Schema definition = definitions.get(key);
            LinkedHashMap<String, Schema> clonedProperties = new LinkedHashMap<String, Schema>();
            if (definition.getProperties() != null) {
                for (String propName : definition.getProperties().keySet()) {
                    boolean shouldInclude;
                    Schema property = (Schema)definition.getProperties().get(propName);
                    if (property == null || !(shouldInclude = filter.isPropertyAllowed(definition, property, propName, params, cookies, headers))) continue;
                    clonedProperties.put(propName, property);
                }
            }
            clonedDefinitions.put(key, definition);
        }
        return clonedDefinitions;
    }

    public Operation filterOperation(SwaggerSpecFilter filter, Operation op, ApiDescription description, Map<String, List<String>> params, Map<String, String> cookies, Map<String, List<String>> headers) {
        Operation clonedOperation = new Operation().summary(op.getSummary()).description(op.getDescription()).operationId(op.getOperationId()).tags(op.getTags()).externalDocs(op.getExternalDocs());
        ArrayList<Parameter> clonedParams = new ArrayList<Parameter>();
        if (op.getParameters() != null) {
            for (Parameter param : op.getParameters()) {
                if (!filter.isParamAllowed(param, op, description, params, cookies, headers)) continue;
                clonedParams.add(param);
            }
        }
        clonedOperation.setParameters(clonedParams);
        clonedOperation.setSecurity(op.getSecurity());
        clonedOperation.setResponses(op.getResponses());
        return clonedOperation;
    }

    private String getPropertyRef(Schema property) {
        if (property.get$ref() != null) {
            return property.get$ref();
        }
        return null;
    }

    private Set<String> getModelRef(Schema model) {
        if (model.get$ref() != null) {
            return new HashSet<String>(Arrays.asList(model.get$ref()));
        }
        return null;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.swagger.core.filter.SpecFilter", SpecFilter.class, null, null);
    }
}

