/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.jackson;

import com.fasterxml.jackson.databind.JavaType;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.swagger.oas.annotations.media.Schema;
import io.swagger.util.PrimitiveType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class TypeNameResolver {
    public static final TypeNameResolver std;
    static final long serialVersionUID = -9060306768031237038L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected TypeNameResolver() {
    }

    public String nameForType(JavaType type, Options ... options) {
        return this.nameForType(type, options.length == 0 ? Collections.emptySet() : EnumSet.copyOf(Arrays.asList(options)));
    }

    public String nameForType(JavaType type, Set<Options> options) {
        if (type.hasGenericTypes()) {
            return this.nameForGenericType(type, options);
        }
        String name = this.findStdName(type);
        return name == null ? this.nameForClass(type, options) : name;
    }

    protected String nameForClass(JavaType type, Set<Options> options) {
        return this.nameForClass(type.getRawClass(), options);
    }

    protected String nameForClass(Class<?> cls, Set<Options> options) {
        if (options.contains((Object)Options.SKIP_API_MODEL)) {
            return cls.getSimpleName();
        }
        Schema model = cls.getAnnotation(Schema.class);
        String modelName = model == null ? null : StringUtils.trimToNull((String)model.title());
        return modelName == null ? cls.getSimpleName() : modelName;
    }

    protected String nameForGenericType(JavaType type, Set<Options> options) {
        StringBuilder generic = new StringBuilder(this.nameForClass(type, options));
        int count = type.containedTypeCount();
        for (int i = 0; i < count; ++i) {
            JavaType arg = type.containedType(i);
            String argName = PrimitiveType.fromType((Type)arg) != null ? this.nameForClass(arg, options) : this.nameForType(arg, options);
            generic.append(WordUtils.capitalize((String)argName));
        }
        return generic.toString();
    }

    protected String findStdName(JavaType type) {
        return PrimitiveType.getCommonName((Type)type);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.swagger.jackson.TypeNameResolver", TypeNameResolver.class, null, null);
        std = new TypeNameResolver();
    }

    public static enum Options {
        SKIP_API_MODEL;

    }
}

