/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.swagger.oas.models.media.ArraySchema;
import io.swagger.oas.models.media.BooleanSchema;
import io.swagger.oas.models.media.ComposedSchema;
import io.swagger.oas.models.media.DateSchema;
import io.swagger.oas.models.media.DateTimeSchema;
import io.swagger.oas.models.media.EmailSchema;
import io.swagger.oas.models.media.IntegerSchema;
import io.swagger.oas.models.media.MapSchema;
import io.swagger.oas.models.media.NumberSchema;
import io.swagger.oas.models.media.ObjectSchema;
import io.swagger.oas.models.media.PasswordSchema;
import io.swagger.oas.models.media.Schema;
import io.swagger.oas.models.media.StringSchema;
import io.swagger.oas.models.media.UUIDSchema;
import io.swagger.util.Json;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ModelDeserializer
extends JsonDeserializer<Schema> {
    static final long serialVersionUID = 8199689272453455704L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public Schema deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        String format;
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        JsonNode allOf = node.get("allOf");
        JsonNode anyOf = node.get("anyOf");
        JsonNode oneOf = node.get("oneOf");
        Schema schema = null;
        if (allOf != null || anyOf != null || oneOf != null) {
            ComposedSchema composedSchema = (ComposedSchema)Json.mapper().convertValue((Object)node, ComposedSchema.class);
            return composedSchema;
        }
        JsonNode type = node.get("type");
        String string = format = node.get("format") == null ? "" : node.get("format").textValue();
        if (type != null && "array".equals(((TextNode)type).textValue())) {
            schema = (Schema)Json.mapper().convertValue((Object)node, ArraySchema.class);
        } else if (type != null) {
            if (type.textValue().equals("integer")) {
                schema = (Schema)Json.mapper().convertValue((Object)node, IntegerSchema.class);
                if (StringUtils.isBlank((CharSequence)format)) {
                    schema.setFormat(null);
                }
            } else if (type.textValue().equals("number")) {
                schema = (Schema)Json.mapper().convertValue((Object)node, NumberSchema.class);
            } else if (type.textValue().equals("boolean")) {
                schema = (Schema)Json.mapper().convertValue((Object)node, BooleanSchema.class);
            } else if (type.textValue().equals("string")) {
                schema = "date".equals(format) ? (Schema)Json.mapper().convertValue((Object)node, DateSchema.class) : ("date-time".equals(format) ? (Schema)Json.mapper().convertValue((Object)node, DateTimeSchema.class) : ("email".equals(format) ? (Schema)Json.mapper().convertValue((Object)node, EmailSchema.class) : ("password".equals(format) ? (Schema)Json.mapper().convertValue((Object)node, PasswordSchema.class) : ("uuid".equals(format) ? (Schema)Json.mapper().convertValue((Object)node, UUIDSchema.class) : (Schema)Json.mapper().convertValue((Object)node, StringSchema.class)))));
            } else if (type.textValue().equals("object")) {
                JsonNode additionalProperties = node.get("additionalProperties");
                if (additionalProperties != null) {
                    Schema innerSchema = (Schema)Json.mapper().convertValue((Object)additionalProperties, Schema.class);
                    MapSchema ms = (MapSchema)Json.mapper().convertValue((Object)node, MapSchema.class);
                    ms.setAdditionalProperties(innerSchema);
                    schema = ms;
                } else {
                    schema = (Schema)Json.mapper().convertValue((Object)node, ObjectSchema.class);
                }
            }
        } else {
            schema = node.get("$ref") != null ? new Schema().$ref(node.get("$ref").asText()) : (Schema)Json.mapper().convertValue((Object)node, ObjectSchema.class);
        }
        Iterator it = node.fieldNames();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object value = node.get(key);
            if (!key.startsWith("x-") || value == null || !StringUtils.isNotBlank((CharSequence)value.toString())) continue;
            if (value instanceof NullNode) {
                value = null;
            }
            if (value instanceof TextNode) {
                schema.addExtension(key, (Object)((TextNode)value).asText());
                continue;
            }
            if (value instanceof ObjectNode) {
                value = Json.mapper().convertValue(value, Map.class);
            } else if (value instanceof ArrayNode) {
                value = Json.mapper().convertValue(value, List.class);
            } else if (value instanceof IntNode) {
                value = ((IntNode)value).intValue();
            } else if (value instanceof LongNode) {
                value = ((LongNode)value).longValue();
            } else if (value instanceof BooleanNode) {
                value = ((BooleanNode)value).booleanValue();
            } else if (value instanceof FloatNode) {
                value = Float.valueOf(((FloatNode)value).floatValue());
            } else if (value instanceof DoubleNode) {
                value = ((DoubleNode)value).doubleValue();
            }
            schema.addExtension(key, value);
        }
        return schema;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.swagger.util.ModelDeserializer", ModelDeserializer.class, null, null);
    }
}

