/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.openapi.jmx;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.FileUtils;
import com.ibm.wsspi.openapi.OASProvider;
import com.ibm.wsspi.openapi.OASProviderConfig;
import com.ibm.wsspi.openapi.OASProviderResult;
import io.swagger.oas.models.OpenAPI;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={OASProvider.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class JMXOASProviderImpl
implements OASProvider {
    private static final String REST_CONNECTOR_CONTEXT_ROOT = "/IBMJMXConnectorREST";
    private static final String DOCUMENT_FILE_PATH = "/lib/openapi.yaml";
    private List<OASProviderResult> results = null;
    private WsLocationAdmin locationAdminProvider;
    private static final TraceComponent tc = Tr.register(JMXOASProviderImpl.class, (String)"JMXOASProvider", (String)"com.ibm.ws.openapi.jmx.resources.JMXOASProviderImplMessages");
    static final long serialVersionUID = -1906970876288314526L;

    @Reference(service=WsLocationAdmin.class)
    protected void setLocationAdmin(WsLocationAdmin provider) {
        this.locationAdminProvider = provider;
    }

    protected void unsetLocationAdmin(WsLocationAdmin provider) {
        this.locationAdminProvider = null;
    }

    public List<OASProviderResult> getResults() {
        if (this.results == null) {
            OASProviderResult result = new OASProviderResult(){
                private String openAPIdocument = null;
                static final long serialVersionUID = -4023598559874542879L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public String getDocument() {
                    block4: {
                        File openAPIfile;
                        if (this.openAPIdocument == null && (openAPIfile = JMXOASProviderImpl.this.getDocumentFile()) != null) {
                            try {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                    Tr.event((Object)this, (TraceComponent)tc, (String)("Reading JMX document name=" + openAPIfile.getAbsolutePath()), (Object[])new Object[0]);
                                }
                                byte[] buf = Files.readAllBytes(Paths.get(openAPIfile.getAbsolutePath(), new String[0]));
                                this.openAPIdocument = new String(buf, "UTF-8");
                            }
                            catch (IOException buf) {
                                FFDCFilter.processException((Throwable)buf, (String)"com.ibm.ws.openapi.jmx.JMXOASProviderImpl$1", (String)"78", (Object)this, (Object[])new Object[0]);
                                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                                Tr.event((Object)this, (TraceComponent)tc, (String)("Error reading JMX document name=" + openAPIfile.getAbsolutePath()), (Object[])new Object[0]);
                            }
                        }
                    }
                    return this.openAPIdocument;
                }

                public OpenAPI getOpenAPI() {
                    return null;
                }

                public OASProviderConfig getOASProviderConfig() {
                    return OASProviderConfig.defaultConfig();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.openapi.jmx.JMXOASProviderImpl$1", 1.class, (String)"JMXOASProvider", (String)"com.ibm.ws.openapi.jmx.resources.JMXOASProviderImplMessages");
                }
            };
            this.results = Arrays.asList(result);
        }
        return this.results;
    }

    public String getContextRoot() {
        return REST_CONNECTOR_CONTEXT_ROOT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public File getDocumentFile() {
        String path = this.locationAdminProvider.resolveString("${server.output.dir}//workarea/jmxSwagger/openapi.yaml");
        File openApiDoc = new File(path);
        if (!FileUtils.fileExists((File)openApiDoc)) {
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("JMX file doesn't exist, need to copy to : " + path), (Object[])new Object[0]);
                }
                FileUtils.fileMkDirs((File)openApiDoc.getParentFile());
                FileUtils.fileCreate((File)openApiDoc);
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.openapi.jmx.JMXOASProviderImpl", (String)"123", (Object)this, (Object[])new Object[0]);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    void e;
                    Tr.event((TraceComponent)tc, (String)("IOException occurred while creating JMX file/folder. e=" + e), (Object[])new Object[0]);
                }
                Tr.warning((TraceComponent)tc, (String)"IO_CREATE_ERROR", (Object[])new Object[]{openApiDoc});
                return null;
            }
            InputStream inputStream = this.getClass().getResourceAsStream(DOCUMENT_FILE_PATH);
            if (inputStream != null) {
                FileOutputStream outputStream = null;
                try {
                    int len;
                    outputStream = FileUtils.getFileOutputStream((File)openApiDoc);
                    byte[] buffer = new byte[2048];
                    while ((len = inputStream.read(buffer)) != -1) {
                        outputStream.write(buffer, 0, len);
                    }
                }
                catch (IOException buffer) {
                    FFDCFilter.processException((Throwable)buffer, (String)"com.ibm.ws.openapi.jmx.JMXOASProviderImpl", (String)"142", (Object)this, (Object[])new Object[0]);
                    FileUtils.fileDelete((File)openApiDoc);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        void ioe;
                        Tr.event((TraceComponent)tc, (String)("IOException occurred while copying JMX file contents. ioe" + ioe), (Object[])new Object[0]);
                    }
                    Tr.warning((TraceComponent)tc, (String)"IO_COPY_ERROR", (Object[])new Object[]{openApiDoc});
                    File file = null;
                    return file;
                }
                finally {
                    FileUtils.tryToClose((Closeable)outputStream);
                    FileUtils.tryToClose((Closeable)inputStream);
                }
            }
        }
        return openApiDoc;
    }

    public boolean isPublic() {
        return false;
    }
}

