/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.swagger.parser.extensions.SwaggerParserExtension;
import io.swagger.parser.models.AuthorizationValue;
import io.swagger.parser.models.ParseOptions;
import io.swagger.parser.models.SwaggerParseResult;
import io.swagger.parser.v3.OpenAPIV3Parser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OpenAPIParser {
    static final long serialVersionUID = 5549849432926066262L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public SwaggerParseResult readLocation(String url, List<AuthorizationValue> auth, ParseOptions options) {
        SwaggerParseResult output = null;
        for (SwaggerParserExtension extension : this.getExtensions()) {
            output = extension.readLocation(url, this.transform(auth), options);
            if (output == null || output.getOpenAPI() == null) continue;
            return output;
        }
        return output;
    }

    public SwaggerParseResult readContents(String swaggerAsString, List<AuthorizationValue> auth, ParseOptions options) {
        SwaggerParseResult output = null;
        for (SwaggerParserExtension extension : this.getExtensions()) {
            output = extension.readContents(swaggerAsString, this.transform(auth), options);
            if (output == null || output.getOpenAPI() == null) continue;
            return output;
        }
        return output;
    }

    protected List<SwaggerParserExtension> getExtensions() {
        return Arrays.asList(new OpenAPIV3Parser());
    }

    protected List<AuthorizationValue> transform(List<AuthorizationValue> input) {
        if (input == null) {
            return null;
        }
        ArrayList<AuthorizationValue> output = new ArrayList<AuthorizationValue>();
        for (AuthorizationValue value : input) {
            AuthorizationValue v = new AuthorizationValue();
            v.setKeyName(value.getKeyName());
            v.setValue(value.getValue());
            v.setType(value.getType());
            output.add(v);
        }
        return output;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.swagger.parser.OpenAPIParser", OpenAPIParser.class, null, null);
    }
}

