/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser.v2;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.swagger.oas.models.Components;
import io.swagger.oas.models.ExternalDocumentation;
import io.swagger.oas.models.OpenAPI;
import io.swagger.oas.models.PathItem;
import io.swagger.oas.models.Paths;
import io.swagger.oas.models.examples.Example;
import io.swagger.oas.models.info.Info;
import io.swagger.oas.models.media.ArraySchema;
import io.swagger.oas.models.media.Content;
import io.swagger.oas.models.media.FileSchema;
import io.swagger.oas.models.media.MediaType;
import io.swagger.oas.models.media.ObjectSchema;
import io.swagger.oas.models.media.Schema;
import io.swagger.oas.models.parameters.HeaderParameter;
import io.swagger.oas.models.parameters.Parameter;
import io.swagger.oas.models.parameters.PathParameter;
import io.swagger.oas.models.parameters.QueryParameter;
import io.swagger.oas.models.parameters.RequestBody;
import io.swagger.oas.models.responses.ApiResponse;
import io.swagger.oas.models.responses.ApiResponses;
import io.swagger.oas.models.servers.Server;
import io.swagger.oas.models.tags.Tag;
import io.swagger.parser.extensions.SwaggerParserExtension;
import io.swagger.parser.models.AuthorizationValue;
import io.swagger.parser.models.ParseOptions;
import io.swagger.parser.models.SwaggerParseResult;
import io.swagger.parser.v2.SwaggerInventory;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import v2.io.swagger.models.ArrayModel;
import v2.io.swagger.models.Contact;
import v2.io.swagger.models.ExternalDocs;
import v2.io.swagger.models.License;
import v2.io.swagger.models.Model;
import v2.io.swagger.models.ModelImpl;
import v2.io.swagger.models.Operation;
import v2.io.swagger.models.Path;
import v2.io.swagger.models.RefModel;
import v2.io.swagger.models.Response;
import v2.io.swagger.models.Scheme;
import v2.io.swagger.models.Swagger;
import v2.io.swagger.models.parameters.AbstractSerializableParameter;
import v2.io.swagger.models.parameters.BodyParameter;
import v2.io.swagger.models.parameters.RefParameter;
import v2.io.swagger.models.parameters.SerializableParameter;
import v2.io.swagger.models.properties.ArrayProperty;
import v2.io.swagger.models.properties.MapProperty;
import v2.io.swagger.models.properties.ObjectProperty;
import v2.io.swagger.models.properties.Property;
import v2.io.swagger.models.properties.RefProperty;
import v2.io.swagger.parser.SwaggerParser;
import v2.io.swagger.parser.SwaggerResolver;
import v2.io.swagger.parser.util.SwaggerDeserializationResult;
import v2.io.swagger.util.Json;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SwaggerConverter
implements SwaggerParserExtension {
    private final List<String> globalConsumes = new ArrayList<String>();
    private final List<String> globalProduces = new ArrayList<String>();
    private SwaggerInventory inventory;
    private Swagger swagger;
    private final Map<String, RequestBody> requestBodies = new HashMap<String, RequestBody>();
    static final long serialVersionUID = 8095991995743541075L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Override
    public SwaggerParseResult readLocation(String url, List<AuthorizationValue> auths, ParseOptions options) {
        boolean resolve = false;
        if (options != null) {
            resolve = options.isResolve();
        }
        SwaggerDeserializationResult result = new SwaggerParser().readWithInfo(url, this.convert(auths), resolve);
        return this.convert(result);
    }

    @Override
    public SwaggerParseResult readContents(String swaggerAsString, List<AuthorizationValue> auth, ParseOptions options) {
        SwaggerDeserializationResult result = new SwaggerParser().readWithInfo(swaggerAsString);
        if (options != null && options.isResolve()) {
            Swagger resolved = new SwaggerResolver(result.getSwagger(), this.convert(auth)).resolve();
            result.setSwagger(resolved);
        }
        return this.convert(result);
    }

    public List<v2.io.swagger.models.auth.AuthorizationValue> convert(List<AuthorizationValue> auths) {
        ArrayList<v2.io.swagger.models.auth.AuthorizationValue> convertedAuth = new ArrayList<v2.io.swagger.models.auth.AuthorizationValue>();
        if (auths != null) {
            for (AuthorizationValue auth : auths) {
                v2.io.swagger.models.auth.AuthorizationValue v = new v2.io.swagger.models.auth.AuthorizationValue();
                v.setType(auth.getType());
                v.setValue(auth.getValue());
                v.setKeyName(auth.getKeyName());
            }
        }
        return convertedAuth;
    }

    public SwaggerParseResult convert(SwaggerDeserializationResult parse) {
        String updatedRef;
        RefModel ref;
        if (parse == null) {
            return null;
        }
        if (parse.getSwagger() == null) {
            return new SwaggerParseResult().messages(parse.getMessages());
        }
        OpenAPI openAPI = new OpenAPI();
        SwaggerParseResult output = new SwaggerParseResult();
        this.inventory = new SwaggerInventory().process(parse.getSwagger());
        this.swagger = parse.getSwagger();
        openAPI.setInfo(this.convert(this.swagger.getInfo()));
        openAPI.setServers(this.convert(this.swagger.getSchemes(), this.swagger.getHost(), this.swagger.getBasePath()));
        if (this.swagger.getTags() != null) {
            openAPI.setTags(this.convertTags(this.swagger.getTags()));
        }
        if (this.swagger.getConsumes() != null) {
            this.globalConsumes.addAll(this.swagger.getConsumes());
        }
        if (this.swagger.getProduces() != null) {
            this.globalProduces.addAll(this.swagger.getProduces());
        }
        String bPath = this.swagger.getBasePath();
        List<Model> models = this.inventory.getModels();
        for (Model model : models) {
            if (model.getExample() != null) {
                model.setExample(null);
            }
            if (!(model instanceof RefModel) || (ref = (RefModel)model).get$ref().indexOf("#/definitions") != 0) continue;
            updatedRef = "#/components/schemas" + ref.get$ref().substring("#/definitions".length());
            ref.set$ref(updatedRef);
        }
        for (Property property : this.inventory.getProperties()) {
            if (property.getExample() != null) {
                property.setExample(null);
            }
            if (!(property instanceof RefProperty) || (ref = (RefProperty)property).get$ref().indexOf("#/definitions") != 0) continue;
            updatedRef = "#/components/schemas" + ref.get$ref().substring("#/definitions".length());
            ref.set$ref(updatedRef);
        }
        Paths v3Paths = new Paths();
        for (String pathname : this.swagger.getPaths().keySet()) {
            Path v2Path = this.swagger.getPath(pathname);
            PathItem v3Path = this.convert(v2Path);
            v3Paths.put((Object)pathname, (Object)v3Path);
        }
        openAPI.setPaths(v3Paths);
        Components components = new Components();
        if (this.swagger.getParameters() != null) {
            for (String name : this.swagger.getParameters().keySet()) {
                v2.io.swagger.models.parameters.Parameter param = (v2.io.swagger.models.parameters.Parameter)this.swagger.getParameters().get(name);
                if (param instanceof BodyParameter) continue;
                components.addParameters(name, this.convert(param));
            }
        }
        if (!this.requestBodies.isEmpty()) {
            components.setRequestBodies(this.requestBodies);
        }
        if (this.swagger.getDefinitions() != null) {
            for (String key : this.swagger.getDefinitions().keySet()) {
                Model model = (Model)this.swagger.getDefinitions().get(key);
                Schema schema = this.convert(model);
                components.addSchemas(key, schema);
            }
        }
        openAPI.setComponents(components);
        output.setOpenAPI(openAPI);
        return output;
    }

    private List<Tag> convertTags(List<v2.io.swagger.models.Tag> v2tags) {
        ArrayList<Tag> v3tags = new ArrayList<Tag>();
        for (v2.io.swagger.models.Tag v2tag : v2tags) {
            Tag v3tag = new Tag();
            v3tag.setDescription(v2tag.getDescription());
            v3tag.setName(v2tag.getName());
            if (v2tag.getExternalDocs() != null) {
                v3tag.setExternalDocs(this.convert(v2tag.getExternalDocs()));
            }
            if (v2tag.getVendorExtensions() != null && v2tag.getVendorExtensions().size() > 0) {
                v3tag.setExtensions(v2tag.getVendorExtensions());
            }
            v3tags.add(v3tag);
        }
        return v3tags;
    }

    private ExternalDocumentation convert(ExternalDocs externalDocs) {
        ExternalDocumentation externalDocumentation = new ExternalDocumentation();
        externalDocumentation.setUrl(externalDocs.getUrl());
        externalDocumentation.setDescription(externalDocs.getDescription());
        externalDocumentation.setExtensions(externalDocs.getVendorExtensions());
        return externalDocumentation;
    }

    private List<Server> convert(List<Scheme> schemes, String host, String basePath) {
        ArrayList<Server> servers = new ArrayList<Server>();
        String baseUrl = StringUtils.isNotEmpty((CharSequence)basePath) ? basePath : "/";
        if (StringUtils.isNotEmpty((CharSequence)host)) {
            baseUrl = host + baseUrl;
        }
        if (!StringUtils.startsWith((CharSequence)baseUrl, (CharSequence)"/") && !schemes.isEmpty()) {
            for (Scheme scheme : schemes) {
                Server server = new Server();
                server.setUrl(scheme.toValue() + baseUrl);
                servers.add(server);
            }
        } else {
            Server server = new Server();
            server.setUrl(baseUrl);
            servers.add(server);
        }
        return servers;
    }

    public Info convert(v2.io.swagger.models.Info v2Info) {
        Info info = new Info();
        info.setContact(this.convert(v2Info.getContact()));
        info.setDescription(v2Info.getDescription());
        info.setLicense(this.convert(v2Info.getLicense()));
        info.setTermsOfService(v2Info.getTermsOfService());
        info.setTitle(v2Info.getTitle());
        info.setVersion(v2Info.getVersion());
        if (v2Info.getVendorExtensions() != null && v2Info.getVendorExtensions().size() > 0) {
            info.setExtensions(v2Info.getVendorExtensions());
        }
        return info;
    }

    private io.swagger.oas.models.info.License convert(License v2License) {
        if (v2License == null) {
            return null;
        }
        io.swagger.oas.models.info.License license = new io.swagger.oas.models.info.License();
        if (v2License.getVendorExtensions() != null && v2License.getVendorExtensions().size() > 0) {
            license.setExtensions(v2License.getVendorExtensions());
        }
        license.setName(v2License.getName());
        license.setUrl(v2License.getUrl());
        return license;
    }

    public io.swagger.oas.models.info.Contact convert(Contact v2Contact) {
        if (v2Contact == null) {
            return null;
        }
        io.swagger.oas.models.info.Contact contact = new io.swagger.oas.models.info.Contact();
        contact.setUrl(v2Contact.getUrl());
        contact.setName(v2Contact.getName());
        contact.setEmail(v2Contact.getEmail());
        return contact;
    }

    public PathItem convert(Path v2Path) {
        Operation v2Operation;
        PathItem v3Path = new PathItem();
        if (v2Path.getParameters() != null) {
            for (v2.io.swagger.models.parameters.Parameter param : v2Path.getParameters()) {
                v3Path.addParametersItem(this.convert(param));
            }
        }
        if ((v2Operation = v2Path.getGet()) != null) {
            v3Path.setGet(this.convert(v2Operation));
        }
        if ((v2Operation = v2Path.getPut()) != null) {
            v3Path.setPut(this.convert(v2Operation));
        }
        if ((v2Operation = v2Path.getPost()) != null) {
            v3Path.setPost(this.convert(v2Operation));
        }
        if ((v2Operation = v2Path.getPatch()) != null) {
            v3Path.setPatch(this.convert(v2Operation));
        }
        if ((v2Operation = v2Path.getDelete()) != null) {
            v3Path.setDelete(this.convert(v2Operation));
        }
        if (v2Path.getVendorExtensions() != null && v2Path.getVendorExtensions().size() > 0) {
            v3Path.setExtensions(v2Path.getVendorExtensions());
        }
        return v3Path;
    }

    public io.swagger.oas.models.Operation convert(Operation v2Operation) {
        io.swagger.oas.models.Operation operation = new io.swagger.oas.models.Operation();
        if (StringUtils.isNotBlank((CharSequence)v2Operation.getDescription())) {
            operation.setDescription(v2Operation.getDescription());
        }
        if (StringUtils.isNotBlank((CharSequence)v2Operation.getSummary())) {
            operation.setSummary(v2Operation.getSummary());
        }
        operation.setDeprecated(v2Operation.isDeprecated());
        operation.setOperationId(v2Operation.getOperationId());
        if (v2Operation.getTags() != null) {
            operation.tags(v2Operation.getTags());
        }
        if (v2Operation.getParameters() != null) {
            ArrayList<v2.io.swagger.models.parameters.Parameter> formParams = new ArrayList<v2.io.swagger.models.parameters.Parameter>();
            for (v2.io.swagger.models.parameters.Parameter param : v2Operation.getParameters()) {
                if (param instanceof RefParameter) {
                    RefParameter refParam = (RefParameter)param;
                    String refName = refParam.get$ref();
                    refName = refName.substring("#/parameters/".length());
                    v2.io.swagger.models.parameters.Parameter tempParam = (v2.io.swagger.models.parameters.Parameter)this.swagger.getParameters().get(refName);
                    if (tempParam instanceof BodyParameter) {
                        BodyParameter bp = (BodyParameter)tempParam;
                        Object body = this.convert(bp, v2Operation);
                        this.requestBodies.put(refName, (RequestBody)body);
                        body = new RequestBody().$ref(refName);
                        operation.setRequestBody((RequestBody)body);
                        continue;
                    }
                    operation.addParametersItem(this.convert(param));
                    continue;
                }
                if ("formData".equals(param.getIn())) {
                    formParams.add(param);
                    continue;
                }
                if ("body".equals(param.getIn())) {
                    BodyParameter bp = (BodyParameter)param;
                    RequestBody body = this.convert(bp, v2Operation);
                    ArrayList<String> mediaTypes = new ArrayList<String>(this.globalConsumes);
                    if (v2Operation.getConsumes() != null && v2Operation.getConsumes().size() > 0) {
                        mediaTypes.clear();
                        mediaTypes.addAll(v2Operation.getConsumes());
                    }
                    if (mediaTypes.size() == 0) {
                        mediaTypes.add("*/*");
                    }
                    if (StringUtils.isNotBlank((CharSequence)param.getDescription())) {
                        body.description(param.getDescription());
                    }
                    body.required(Boolean.valueOf(param.getRequired()));
                    Content content = new Content();
                    for (String type : mediaTypes) {
                        content.addMediaType(type, new MediaType().schema(this.convert(bp.getSchema())));
                        if (StringUtils.isNotBlank((CharSequence)bp.getDescription())) {
                            body.setDescription(bp.getDescription());
                        }
                        operation.setRequestBody(body);
                    }
                    body.content(content);
                    continue;
                }
                operation.addParametersItem(this.convert(param));
            }
            if (formParams.size() > 0) {
                RequestBody body = new RequestBody();
                Schema formSchema = new Schema();
                for (v2.io.swagger.models.parameters.Parameter param : formParams) {
                    SerializableParameter sp = (SerializableParameter)param;
                    FileSchema schema = null;
                    if ("file".equals(sp.getType())) {
                        schema = new FileSchema();
                    } else if ("array".equals(sp.getType())) {
                        ArraySchema as = new ArraySchema();
                        if (sp.getItems() != null) {
                            as.setItems(this.convert(sp.getItems()));
                        }
                        schema = as;
                    } else {
                        schema = new Schema();
                        schema.setType(sp.getType());
                        schema.setFormat(sp.getFormat());
                    }
                    schema.setDescription(sp.getDescription());
                    schema.setReadOnly(sp.isReadOnly());
                    formSchema.addProperties(param.getName(), (Schema)schema);
                }
                ArrayList<String> mediaTypes = new ArrayList<String>(this.globalConsumes);
                if (v2Operation.getConsumes() != null && v2Operation.getConsumes().size() > 0) {
                    mediaTypes.clear();
                    mediaTypes.addAll(v2Operation.getConsumes());
                }
                Content content = new Content();
                for (String type : mediaTypes) {
                    content.addMediaType(type, new MediaType().schema(formSchema));
                }
                body.content(content);
                operation.requestBody(body);
            }
        }
        if (v2Operation.getResponses() != null) {
            ArrayList<String> mediaTypes = new ArrayList<String>(this.globalProduces);
            if (v2Operation.getProduces() != null) {
                mediaTypes.clear();
                mediaTypes.addAll(v2Operation.getProduces());
            }
            if (mediaTypes.size() == 0) {
                mediaTypes.add("*/*");
            }
            for (String responseCode : v2Operation.getResponses().keySet()) {
                Response v2Response = (Response)v2Operation.getResponses().get(responseCode);
                ApiResponse response = this.convert(v2Response, mediaTypes);
                ApiResponses responses = operation.getResponses();
                if (responses == null) {
                    responses = new ApiResponses();
                }
                operation.responses(responses.addApiResponse(responseCode, response));
            }
        }
        return operation;
    }

    public RequestBody convert(BodyParameter bp, Operation v2Operation) {
        RequestBody body = new RequestBody();
        if (StringUtils.isNotBlank((CharSequence)bp.getDescription())) {
            body.description(bp.getDescription());
        }
        body.required(Boolean.valueOf(bp.getRequired()));
        ArrayList<String> mediaTypes = new ArrayList<String>(this.globalConsumes);
        if (v2Operation.getConsumes() != null && v2Operation.getConsumes().size() > 0) {
            mediaTypes.clear();
            mediaTypes.addAll(v2Operation.getConsumes());
        }
        if (mediaTypes.size() == 0) {
            mediaTypes.add("*/*");
        }
        Content content = new Content();
        for (String type : mediaTypes) {
            content.addMediaType(type, new MediaType().schema(this.convert(bp.getSchema())));
        }
        body.content(content);
        return body;
    }

    public ApiResponse convert(Response v2Response, List<String> mediaTypes) {
        ApiResponse response = new ApiResponse();
        Content content = new Content();
        response.setDescription(v2Response.getDescription());
        for (String type : mediaTypes) {
            Object v2Example;
            MediaType media = new MediaType();
            if (v2Response.getSchema() != null) {
                Schema schema = this.convert(v2Response.getSchema());
                media.schema(schema);
            }
            if (v2Response.getExamples() != null && (v2Example = v2Response.getExamples().get(type)) != null) {
                Example ex = new Example().value(v2Example);
                media.addExamples(type, ex);
            }
            if (media.getSchema() == null && media.getExamples() == null) continue;
            content.addMediaType(type, media);
        }
        if (!content.keySet().isEmpty()) {
            response.content(content);
        }
        return response;
    }

    public Parameter convert(v2.io.swagger.models.parameters.Parameter v2Parameter) {
        Object v3Parameter = v2Parameter.getIn() == null ? new Parameter() : (v2Parameter.getIn().equals("path") ? new PathParameter() : (v2Parameter.getIn().equals("query") ? new QueryParameter() : (v2Parameter.getIn().equals("header") ? new HeaderParameter() : new Parameter())));
        if (StringUtils.isNotBlank((CharSequence)v2Parameter.getDescription())) {
            v3Parameter.setDescription(v2Parameter.getDescription());
        }
        v3Parameter.setAllowEmptyValue(v2Parameter.getAllowEmptyValue());
        v3Parameter.setIn(v2Parameter.getIn());
        v3Parameter.setName(v2Parameter.getName());
        Schema schema = null;
        if (v2Parameter instanceof RefParameter) {
            schema = new Schema().$ref(((RefParameter)v2Parameter).get$ref());
        } else if (v2Parameter instanceof AbstractSerializableParameter) {
            AbstractSerializableParameter v2asParam = (AbstractSerializableParameter)v2Parameter;
            if ("array".equals(v2asParam.getType())) {
                ArraySchema a = new ArraySchema();
                v2asParam.getCollectionFormat();
                Property items = v2asParam.getItems();
                Schema itemsSchema = this.convert(items);
                a.setItems(itemsSchema);
                if (v2asParam.getMaxItems() != null) {
                    a.setMaxItems(v2asParam.getMaxItems());
                }
                if (v2asParam.getMinItems() != null) {
                    a.setMinItems(v2asParam.getMinItems());
                }
                schema = a;
            } else {
                schema = new Schema();
                schema.setType(v2asParam.getType());
                schema.setFormat(v2asParam.getFormat());
                if (v2asParam.getVendorExtensions() != null && v2asParam.getVendorExtensions().size() > 0) {
                    schema.setExtensions(v2asParam.getVendorExtensions());
                }
                if (v2asParam.getEnum() != null) {
                    for (Object e : v2asParam.getEnum()) {
                        schema.addEnumItemObject(e);
                    }
                }
                schema.setMaximum(v2asParam.getMaximum());
                schema.setMinimum(v2asParam.getMinimum());
                schema.setMinLength(v2asParam.getMinLength());
                schema.setMaxLength(v2asParam.getMaxLength());
                if (v2asParam.getMultipleOf() != null) {
                    schema.setMultipleOf(new BigDecimal(v2asParam.getMultipleOf().toString()));
                }
                schema.setPattern(v2asParam.getPattern());
                schema.setDefault(v2asParam.getDefault());
            }
        }
        v3Parameter.setSchema(schema);
        if (v2Parameter.getRequired()) {
            v3Parameter.setRequired(Boolean.valueOf(v2Parameter.getRequired()));
        }
        if (v2Parameter.getVendorExtensions() != null && v2Parameter.getVendorExtensions().size() > 0) {
            v3Parameter.setExtensions(v2Parameter.getVendorExtensions());
        }
        return v3Parameter;
    }

    public Schema convert(Property prop) {
        if (prop instanceof ObjectProperty) {
            ObjectSchema objectSchema = (ObjectSchema)Json.mapper().convertValue((Object)prop, ObjectSchema.class);
            ObjectProperty oprop = (ObjectProperty)prop;
            Map v2Properties = oprop.getProperties();
            if (v2Properties != null && !v2Properties.keySet().isEmpty()) {
                objectSchema.setProperties(null);
                for (String name : v2Properties.keySet()) {
                    objectSchema.addProperties(name, this.convert((Property)v2Properties.get(name)));
                }
            }
            return objectSchema;
        }
        if (prop instanceof MapProperty) {
            Schema schema = (Schema)Json.mapper().convertValue((Object)prop, Schema.class);
            MapProperty mprop = (MapProperty)prop;
            if (mprop.getAdditionalProperties() != null) {
                schema.additionalProperties(this.convert(mprop.getAdditionalProperties()));
            }
            return schema;
        }
        if (prop instanceof ArrayProperty) {
            ArraySchema arraySchema = (ArraySchema)Json.mapper().convertValue((Object)prop, ArraySchema.class);
            ArrayProperty aprop = (ArrayProperty)prop;
            if (aprop.getItems() != null) {
                arraySchema.setItems(this.convert(aprop.getItems()));
            }
            return arraySchema;
        }
        return (Schema)Json.mapper().convertValue((Object)prop, Schema.class);
    }

    public Schema convert(Model v2Model) {
        if (v2Model instanceof ModelImpl) {
            ModelImpl v2ModelImpl = (ModelImpl)v2Model;
            ObjectSchema objectSchema = (ObjectSchema)Json.mapper().convertValue((Object)v2Model, ObjectSchema.class);
            if (v2ModelImpl.getProperties() != null) {
                objectSchema.setProperties(null);
                for (String key : v2ModelImpl.getProperties().keySet()) {
                    Property prop = (Property)v2ModelImpl.getProperties().get(key);
                    objectSchema.addProperties(key, this.convert(prop));
                }
            }
            if (v2ModelImpl.getAdditionalProperties() != null) {
                objectSchema.additionalProperties(this.convert(v2ModelImpl.getAdditionalProperties()));
            }
            return objectSchema;
        }
        if (v2Model instanceof ArrayModel) {
            ArraySchema arraySchema = (ArraySchema)Json.mapper().convertValue((Object)v2Model, ArraySchema.class);
            ArrayModel v2ArrayModel = (ArrayModel)v2Model;
            if (v2ArrayModel.getItems() != null) {
                arraySchema.items(this.convert(v2ArrayModel.getItems()));
            }
            return arraySchema;
        }
        return (Schema)Json.mapper().convertValue((Object)v2Model, Schema.class);
    }

    public Tag convert(v2.io.swagger.models.Tag v2Tag) {
        return (Tag)Json.mapper().convertValue((Object)v2Tag, Tag.class);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.swagger.parser.v2.SwaggerConverter", SwaggerConverter.class, null, null);
    }
}

