/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser.v3;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.swagger.oas.models.OpenAPI;
import io.swagger.oas.models.Operation;
import io.swagger.oas.models.PathItem;
import io.swagger.parser.models.AuthorizationValue;
import io.swagger.parser.v3.ResolverCache;
import io.swagger.parser.v3.processors.ComponentsProcessor;
import io.swagger.parser.v3.processors.OperationProcessor;
import io.swagger.parser.v3.processors.PathsProcessor;
import java.util.List;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OpenAPIResolver {
    private final OpenAPI openApi;
    private final ResolverCache cache;
    private final ComponentsProcessor componentsProcessor;
    private final PathsProcessor pathProcessor;
    private final OperationProcessor operationsProcessor;
    private Settings settings = new Settings();
    static final long serialVersionUID = 1989838730421168490L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public OpenAPIResolver(OpenAPI openApi) {
        this(openApi, null, null, null);
    }

    public OpenAPIResolver(OpenAPI openApi, List<AuthorizationValue> auths) {
        this(openApi, auths, null, null);
    }

    public OpenAPIResolver(OpenAPI openApi, List<AuthorizationValue> auths, String parentFileLocation) {
        this(openApi, auths, parentFileLocation, null);
    }

    public OpenAPIResolver(OpenAPI openApi, List<AuthorizationValue> auths, String parentFileLocation, Settings settings) {
        this.openApi = openApi;
        this.settings = settings != null ? settings : new Settings();
        this.cache = new ResolverCache(openApi, auths, parentFileLocation);
        this.componentsProcessor = new ComponentsProcessor(openApi, this.cache);
        this.pathProcessor = new PathsProcessor(this.cache, openApi, this.settings);
        this.operationsProcessor = new OperationProcessor(this.cache, openApi);
    }

    public OpenAPI resolve() {
        if (this.openApi == null) {
            return null;
        }
        this.pathProcessor.processPaths();
        this.componentsProcessor.processComponents();
        if (this.openApi.getPaths() != null) {
            for (String pathname : this.openApi.getPaths().keySet()) {
                PathItem pathItem = (PathItem)this.openApi.getPaths().get((Object)pathname);
                if (pathItem.readOperations() == null) continue;
                for (Operation operation : pathItem.readOperations()) {
                    this.operationsProcessor.processOperation(operation);
                }
            }
        }
        return this.openApi;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.swagger.parser.v3.OpenAPIResolver", OpenAPIResolver.class, null, null);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class Settings {
        private boolean addParametersToEachOperation = true;
        static final long serialVersionUID = 7422971872847810152L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public boolean addParametersToEachOperation() {
            return this.addParametersToEachOperation;
        }

        public Settings addParametersToEachOperation(boolean addParametersToEachOperation) {
            this.addParametersToEachOperation = addParametersToEachOperation;
            return this;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.swagger.parser.v3.OpenAPIResolver$Settings", Settings.class, null, null);
        }
    }
}

