/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser.v3.processors;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.swagger.oas.models.OpenAPI;
import io.swagger.oas.models.Operation;
import io.swagger.oas.models.PathItem;
import io.swagger.oas.models.callbacks.Callback;
import io.swagger.oas.models.parameters.Parameter;
import io.swagger.parser.v3.ResolverCache;
import io.swagger.parser.v3.models.RefFormat;
import io.swagger.parser.v3.processors.ExternalRefProcessor;
import io.swagger.parser.v3.processors.OperationProcessor;
import io.swagger.parser.v3.processors.ParameterProcessor;
import io.swagger.parser.v3.util.RefUtils;
import java.util.List;
import java.util.Map;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CallbackProcessor {
    private final ResolverCache cache;
    private final OperationProcessor operationProcessor;
    private final ParameterProcessor parameterProcessor;
    private final OpenAPI openAPI;
    private final ExternalRefProcessor externalRefProcessor;
    static final long serialVersionUID = -7472148843063106526L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public CallbackProcessor(ResolverCache cache, OpenAPI openAPI) {
        this.cache = cache;
        this.operationProcessor = new OperationProcessor(cache, openAPI);
        this.parameterProcessor = new ParameterProcessor(cache, openAPI);
        this.externalRefProcessor = new ExternalRefProcessor(cache, openAPI);
        this.openAPI = openAPI;
    }

    public void processCallback(Callback callback) {
        if (callback.get((Object)"$ref") != null) {
            this.processReferenceCallback(callback);
        }
        for (String name : callback.keySet()) {
            PathItem pathItem = (PathItem)callback.get((Object)name);
            Map operationMap = pathItem.readOperationsMap();
            for (PathItem.HttpMethod httpMethod : operationMap.keySet()) {
                Operation operation = (Operation)operationMap.get(httpMethod);
                this.operationProcessor.processOperation(operation);
            }
            List parameters = pathItem.getParameters();
            if (parameters == null) continue;
            for (Parameter parameter : parameters) {
                this.parameterProcessor.processParameter(parameter);
            }
        }
    }

    public void processReferenceCallback(Callback callback) {
        String newRef;
        String $ref = ((PathItem)callback.get((Object)"$ref")).get$ref();
        RefFormat refFormat = RefUtils.computeRefFormat($ref);
        if (RefUtils.isAnExternalRefFormat(refFormat) && (newRef = this.externalRefProcessor.processRefToExternalCallback($ref, refFormat)) != null) {
            ((PathItem)callback.get((Object)"$ref")).set$ref("#/components/callbacks/" + newRef);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.swagger.parser.v3.processors.CallbackProcessor", CallbackProcessor.class, null, null);
    }
}

