/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser.v3.processors;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.swagger.oas.models.OpenAPI;
import io.swagger.oas.models.examples.Example;
import io.swagger.parser.v3.ResolverCache;
import io.swagger.parser.v3.models.RefFormat;
import io.swagger.parser.v3.processors.ExternalRefProcessor;
import io.swagger.parser.v3.util.RefUtils;
import java.util.List;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ExampleProcessor {
    private final ResolverCache cache;
    private final OpenAPI openAPI;
    private final ExternalRefProcessor externalRefProcessor;
    static final long serialVersionUID = 8324970717275595508L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ExampleProcessor(ResolverCache cache, OpenAPI openAPI) {
        this.cache = cache;
        this.openAPI = openAPI;
        this.externalRefProcessor = new ExternalRefProcessor(cache, openAPI);
    }

    public void processExample(Example example) {
        if (example.get$ref() != null) {
            this.processReferenceExample(example);
        }
    }

    public void processExample(List<Example> examples) {
        for (Example example : examples) {
            if (example.get$ref() == null) continue;
            this.processReferenceExample(example);
        }
    }

    private void processReferenceExample(Example example) {
        String newRef;
        RefFormat refFormat = RefUtils.computeRefFormat(example.get$ref());
        String $ref = example.get$ref();
        if (RefUtils.isAnExternalRefFormat(refFormat) && (newRef = this.externalRefProcessor.processRefToExternalExample($ref, refFormat)) != null) {
            example.set$ref(newRef);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.swagger.parser.v3.processors.ExampleProcessor", ExampleProcessor.class, null, null);
    }
}

