/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser.v3.processors;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.swagger.oas.models.OpenAPI;
import io.swagger.oas.models.Operation;
import io.swagger.oas.models.PathItem;
import io.swagger.oas.models.callbacks.Callback;
import io.swagger.oas.models.parameters.Parameter;
import io.swagger.oas.models.parameters.RequestBody;
import io.swagger.oas.models.responses.ApiResponse;
import io.swagger.oas.models.responses.ApiResponses;
import io.swagger.parser.v3.ResolverCache;
import io.swagger.parser.v3.models.RefFormat;
import io.swagger.parser.v3.processors.ExternalRefProcessor;
import io.swagger.parser.v3.processors.ParameterProcessor;
import io.swagger.parser.v3.processors.RequestBodyProcessor;
import io.swagger.parser.v3.processors.ResponseProcessor;
import io.swagger.parser.v3.util.RefUtils;
import java.util.List;
import java.util.Map;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OperationProcessor {
    private final ParameterProcessor parameterProcessor;
    private final RequestBodyProcessor requestBodyProcessor;
    private final ResponseProcessor responseProcessor;
    private final ExternalRefProcessor externalRefProcessor;
    private final ResolverCache cache;
    static final long serialVersionUID = 6008680910103489634L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public OperationProcessor(ResolverCache cache, OpenAPI openAPI) {
        this.parameterProcessor = new ParameterProcessor(cache, openAPI);
        this.responseProcessor = new ResponseProcessor(cache, openAPI);
        this.requestBodyProcessor = new RequestBodyProcessor(cache, openAPI);
        this.externalRefProcessor = new ExternalRefProcessor(cache, openAPI);
        this.cache = cache;
    }

    public void processOperation(Operation operation) {
        Map callbacks;
        ApiResponses responses;
        RequestBody requestBody;
        List<Parameter> processedOperationParameters = this.parameterProcessor.processParameters(operation.getParameters());
        if (processedOperationParameters != null) {
            operation.setParameters(processedOperationParameters);
        }
        if ((requestBody = operation.getRequestBody()) != null) {
            this.requestBodyProcessor.processRequestBody(requestBody);
        }
        if ((responses = operation.getResponses()) != null) {
            for (String responseCode : responses.keySet()) {
                ApiResponse response = (ApiResponse)responses.get(responseCode);
                if (response == null) continue;
                this.responseProcessor.processResponse(response);
            }
        }
        if ((callbacks = operation.getCallbacks()) != null) {
            for (String name : callbacks.keySet()) {
                String newRef;
                String $ref;
                RefFormat refFormat;
                Callback callback = (Callback)callbacks.get(name);
                if (callback == null) continue;
                if (callback.get((Object)"$ref") != null && RefUtils.isAnExternalRefFormat(refFormat = RefUtils.computeRefFormat($ref = ((PathItem)callback.get((Object)"$ref")).get$ref())) && (newRef = this.externalRefProcessor.processRefToExternalCallback($ref, refFormat)) != null) {
                    ((PathItem)callback.get((Object)"$ref")).set$ref(newRef);
                }
                for (String callbackName : callback.keySet()) {
                    PathItem pathItem = (PathItem)callback.get((Object)callbackName);
                    Map operationMap = pathItem.readOperationsMap();
                    for (PathItem.HttpMethod httpMethod : operationMap.keySet()) {
                        Operation op = (Operation)operationMap.get(httpMethod);
                        this.processOperation(op);
                    }
                    List parameters = pathItem.getParameters();
                    if (parameters == null) continue;
                    for (Parameter parameter : parameters) {
                        this.parameterProcessor.processParameter(parameter);
                    }
                }
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.swagger.parser.v3.processors.OperationProcessor", OperationProcessor.class, null, null);
    }
}

