/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser.v3.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.swagger.util.Json;
import io.swagger.util.Yaml;
import java.io.IOException;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class DeserializationUtils {
    static final long serialVersionUID = 7209578661005803938L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    /*
     * WARNING - void declaration
     */
    public static JsonNode deserializeIntoTree(String contents, String fileOrHost) {
        JsonNode result;
        try {
            result = DeserializationUtils.isJson(contents) ? Json.mapper().readTree(contents) : DeserializationUtils.readYamlTree(contents);
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"io.swagger.parser.v3.util.DeserializationUtils", (String)"25", null, (Object[])new Object[]{contents, fileOrHost});
            throw new RuntimeException("An exception was thrown while trying to deserialize the contents of " + fileOrHost + " into a JsonNode tree", (Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T deserialize(Object contents, String fileOrHost, Class<T> expectedType) {
        Object result;
        boolean isJson = false;
        if (contents instanceof String && DeserializationUtils.isJson((String)contents)) {
            isJson = true;
        }
        try {
            result = contents instanceof String ? (isJson ? Json.mapper().readValue((String)contents, expectedType) : Yaml.mapper().readValue((String)contents, expectedType)) : Json.mapper().convertValue(contents, expectedType);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"io.swagger.parser.v3.util.DeserializationUtils", (String)"51", null, (Object[])new Object[]{contents, fileOrHost, expectedType});
            throw new RuntimeException("An exception was thrown while trying to deserialize the contents of " + fileOrHost + " into type " + expectedType, (Throwable)e);
        }
        return (T)result;
    }

    private static boolean isJson(String contents) {
        return contents.toString().trim().startsWith("{");
    }

    public static JsonNode readYamlTree(String contents) {
        org.yaml.snakeyaml.Yaml yaml = new org.yaml.snakeyaml.Yaml((BaseConstructor)new SafeConstructor());
        return (JsonNode)Json.mapper().convertValue(yaml.load(contents), JsonNode.class);
    }

    public static <T> T readYamlValue(String contents, Class<T> expectedType) {
        org.yaml.snakeyaml.Yaml yaml = new org.yaml.snakeyaml.Yaml((BaseConstructor)new SafeConstructor());
        return (T)Json.mapper().convertValue(yaml.load(contents), expectedType);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.swagger.parser.v3.util.DeserializationUtils", DeserializationUtils.class, null, null);
    }
}

