/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser.v3.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.swagger.parser.models.AuthorizationValue;
import io.swagger.parser.v3.util.ManagedValue;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class RemoteUrl {
    private static final String TRUST_ALL;
    private static final ConnectionConfigurator CONNECTION_CONFIGURATOR;
    private static final Charset UTF_8;
    private static final String ACCEPT_HEADER_VALUE = "application/json, application/yaml, */*";
    private static final String USER_AGENT_HEADER_VALUE = "Apache-HttpClient/Swagger";
    static final long serialVersionUID = 8389263411720456710L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private static ConnectionConfigurator createConnectionConfigurator() {
        if (Boolean.parseBoolean(System.getProperty(TRUST_ALL))) {
            try {
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){
                    static final long serialVersionUID = -3084971717472893981L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"io.swagger.parser.v3.util.RemoteUrl$1", 1.class, null, null);
                    }
                }};
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, trustAllCerts, new SecureRandom());
                final SSLSocketFactory sf = sc.getSocketFactory();
                final HostnameVerifier trustAllNames = new HostnameVerifier(){
                    static final long serialVersionUID = -923546750535019533L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"io.swagger.parser.v3.util.RemoteUrl$2", 2.class, null, null);
                    }
                };
                return new ConnectionConfigurator(){
                    static final long serialVersionUID = 3491611777041885990L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public void process(URLConnection connection) {
                        if (connection instanceof HttpsURLConnection) {
                            HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
                            httpsConnection.setSSLSocketFactory(sf);
                            httpsConnection.setHostnameVerifier(trustAllNames);
                        }
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"io.swagger.parser.v3.util.RemoteUrl$3", 3.class, null, null);
                    }
                };
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                FFDCFilter.processException((Throwable)noSuchAlgorithmException, (String)"io.swagger.parser.v3.util.RemoteUrl", (String)"82", null, (Object[])new Object[0]);
            }
            catch (KeyManagementException keyManagementException) {
                FFDCFilter.processException((Throwable)keyManagementException, (String)"io.swagger.parser.v3.util.RemoteUrl", (String)"84", null, (Object[])new Object[0]);
            }
        }
        return new ConnectionConfigurator(){
            static final long serialVersionUID = 4820824172590920680L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public void process(URLConnection connection) {
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"io.swagger.parser.v3.util.RemoteUrl$4", 4.class, null, null);
            }
        };
    }

    public static String cleanUrl(String url) {
        return url.replaceAll("\\{", "%7B").replaceAll("\\}", "%7D");
    }

    /*
     * WARNING - void declaration
     */
    public static String urlToString(String url, List<AuthorizationValue> auths) throws Exception {
        InputStream is = null;
        BufferedReader br = null;
        try {
            URLConnection conn;
            URL inUrl = new URL(RemoteUrl.cleanUrl(url));
            ArrayList<AuthorizationValue> query = new ArrayList<AuthorizationValue>();
            ArrayList<AuthorizationValue> header = new ArrayList<AuthorizationValue>();
            if (auths != null) {
                for (AuthorizationValue auth : auths) {
                    if ("query".equals(auth.getType())) {
                        RemoteUrl.appendValue(inUrl, auth, query);
                        continue;
                    }
                    if (!"header".equals(auth.getType())) continue;
                    RemoteUrl.appendValue(inUrl, auth, header);
                }
            }
            if (!query.isEmpty()) {
                URI inUri = inUrl.toURI();
                StringBuilder newQuery = new StringBuilder(inUri.getQuery() == null ? "" : inUri.getQuery());
                for (AuthorizationValue item : query) {
                    if (newQuery.length() > 0) {
                        newQuery.append("&");
                    }
                    newQuery.append(URLEncoder.encode(item.getKeyName(), UTF_8.name())).append("=").append(URLEncoder.encode(item.getValue(), UTF_8.name()));
                }
                conn = new URI(inUri.getScheme(), inUri.getAuthority(), inUri.getPath(), newQuery.toString(), inUri.getFragment()).toURL().openConnection();
            } else {
                conn = inUrl.openConnection();
            }
            CONNECTION_CONFIGURATOR.process(conn);
            for (AuthorizationValue item : header) {
                conn.setRequestProperty(item.getKeyName(), item.getValue());
            }
            conn.setRequestProperty("Accept", ACCEPT_HEADER_VALUE);
            conn.setRequestProperty("User-Agent", USER_AGENT_HEADER_VALUE);
            conn.connect();
            InputStream in = conn.getInputStream();
            StringBuilder contents = new StringBuilder();
            BufferedReader input = new BufferedReader(new InputStreamReader(in, UTF_8));
            int i = 0;
            while (i != -1) {
                char c = (char)i;
                if (!Character.isISOControl(c)) {
                    contents.append((char)i);
                }
                if (c == '\n') {
                    contents.append('\n');
                }
                i = input.read();
            }
            if (in != null) {
                in.close();
            }
            if (input != null) {
                input.close();
            }
            String string = contents.toString();
            return string;
        }
        catch (SSLProtocolException inUrl) {
            void e;
            FFDCFilter.processException((Throwable)inUrl, (String)"io.swagger.parser.v3.util.RemoteUrl", (String)"164", null, (Object[])new Object[]{url, auths});
            throw e;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"io.swagger.parser.v3.util.RemoteUrl", (String)"169", null, (Object[])new Object[]{url, auths});
            throw e;
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (br != null) {
                br.close();
            }
        }
    }

    private static void appendValue(URL url, AuthorizationValue value, Collection<AuthorizationValue> to) {
        if (value instanceof ManagedValue && !((ManagedValue)((Object)value)).process(url)) {
            return;
        }
        to.add(value);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.swagger.parser.v3.util.RemoteUrl", RemoteUrl.class, null, null);
        TRUST_ALL = String.format("%s.trustAll", RemoteUrl.class.getName());
        CONNECTION_CONFIGURATOR = RemoteUrl.createConnectionConfigurator();
        UTF_8 = StandardCharsets.UTF_8;
    }

    private static interface ConnectionConfigurator {
        public void process(URLConnection var1);
    }
}

