/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser.v3.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.swagger.oas.models.OpenAPI;
import io.swagger.oas.models.Operation;
import io.swagger.oas.models.PathItem;
import io.swagger.oas.models.callbacks.Callback;
import io.swagger.oas.models.media.ArraySchema;
import io.swagger.oas.models.media.ComposedSchema;
import io.swagger.oas.models.media.Content;
import io.swagger.oas.models.media.MediaType;
import io.swagger.oas.models.media.Schema;
import io.swagger.oas.models.responses.ApiResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ResolverFully {
    private Map<String, Schema> schemas;
    private final Map<String, Schema> resolvedModels = new HashMap<String, Schema>();
    static final long serialVersionUID = 3177724865510334310L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public void resolveFully(OpenAPI openAPI) {
        if (openAPI.getComponents().getSchemas() != null) {
            this.schemas = openAPI.getComponents().getSchemas();
            if (this.schemas == null) {
                this.schemas = new HashMap<String, Schema>();
            }
        }
        if (openAPI.getPaths() != null) {
            for (String pathname : openAPI.getPaths().keySet()) {
                PathItem pathItem = (PathItem)openAPI.getPaths().get((Object)pathname);
                this.resolvePath(pathItem);
            }
        }
    }

    public void resolvePath(PathItem pathItem) {
        for (Operation op : pathItem.readOperations()) {
            Object parameter2;
            if (op.getParameters() != null) {
                for (Object parameter2 : op.getParameters()) {
                    Schema resolved;
                    if (parameter2.getSchema() != null && (resolved = this.resolveSchema(parameter2.getSchema())) != null) {
                        parameter2.setSchema(resolved);
                    }
                    if (parameter2.getContent() == null) continue;
                    Content content = parameter2.getContent();
                    for (String key : content.keySet()) {
                        Schema resolvedSchema;
                        if (content.get(key) == null || ((MediaType)content.get(key)).getSchema() == null || (resolvedSchema = this.resolveSchema(((MediaType)content.get(key)).getSchema())) == null) continue;
                        ((MediaType)content.get(key)).setSchema(resolvedSchema);
                    }
                }
            }
            if (op.getCallbacks() != null) {
                Map callbacks = op.getCallbacks();
                parameter2 = callbacks.keySet().iterator();
                while (parameter2.hasNext()) {
                    String name = (String)parameter2.next();
                    Callback callback = (Callback)callbacks.get(name);
                    if (callback == null) continue;
                    for (String callbackName : callback.keySet()) {
                        PathItem path = (PathItem)callback.get((Object)callbackName);
                        if (path == null) continue;
                        this.resolvePath(path);
                    }
                }
            }
            if (op.getRequestBody() != null && op.getRequestBody().getContent() != null) {
                Content content = op.getRequestBody().getContent();
                parameter2 = content.keySet().iterator();
                while (parameter2.hasNext()) {
                    Schema resolved;
                    String key = (String)parameter2.next();
                    if (content.get(key) == null || ((MediaType)content.get(key)).getSchema() == null || (resolved = this.resolveSchema(((MediaType)content.get(key)).getSchema())) == null) continue;
                    ((MediaType)content.get(key)).setSchema(resolved);
                }
            }
            if (op.getResponses() == null) continue;
            for (String code : op.getResponses().keySet()) {
                ApiResponse response = (ApiResponse)op.getResponses().get((Object)code);
                if (response.getContent() == null) continue;
                Content content = response.getContent();
                for (String mediaType : content.keySet()) {
                    if (((MediaType)content.get(mediaType)).getSchema() == null) continue;
                    Schema resolved = this.resolveSchema(((MediaType)content.get(mediaType)).getSchema());
                    ((MediaType)response.getContent().get((Object)mediaType)).setSchema(resolved);
                }
            }
        }
    }

    public Schema resolveSchema(Schema schema) {
        if (schema.get$ref() != null) {
            String ref = schema.get$ref();
            Schema resolved = this.schemas.get(ref = ref.substring(ref.lastIndexOf("/") + 1));
            if (resolved == null) {
                return schema;
            }
            if (this.resolvedModels.containsKey(ref)) {
                return this.resolvedModels.get(ref);
            }
            this.resolvedModels.put(ref, schema);
            Schema model = this.resolveSchema(resolved);
            this.resolvedModels.put(ref, model);
            return model;
        }
        if (schema instanceof ArraySchema) {
            ArraySchema arrayModel = (ArraySchema)schema;
            Schema items = arrayModel.getItems();
            if (items.get$ref() != null) {
                Schema resolved = this.resolveSchema(items);
                arrayModel.setItems(resolved);
            }
            return arrayModel;
        }
        if (schema.getProperties() != null) {
            Schema property;
            Schema model = schema;
            LinkedHashMap<String, Schema> updated = new LinkedHashMap<String, Schema>();
            Map properties = model.getProperties();
            for (String propertyName : properties.keySet()) {
                property = (Schema)model.getProperties().get(propertyName);
                Schema resolved = this.resolveSchema(property);
                updated.put(propertyName, resolved);
            }
            for (String key : updated.keySet()) {
                property = (Schema)updated.get(key);
                if (property.getProperties() != model.getProperties()) {
                    if (property.getType() == null) {
                        property.setType("object");
                    }
                    model.addProperties(key, property);
                    continue;
                }
                Schema newSchema = new Schema();
                newSchema.setType("object");
                model.addProperties(key, newSchema);
            }
            return model;
        }
        if (schema instanceof ComposedSchema) {
            Schema prop;
            int count;
            Map properties;
            Schema resolved;
            ComposedSchema composedSchema = (ComposedSchema)schema;
            Schema model = new Schema();
            HashSet<String> requiredProperties = new HashSet<String>();
            if (composedSchema.getAllOf() != null) {
                for (Schema innerModel : composedSchema.getAllOf()) {
                    resolved = this.resolveSchema(innerModel);
                    properties = resolved.getProperties();
                    if (resolved.getProperties() == null) continue;
                    count = 0;
                    for (String key : properties.keySet()) {
                        prop = (Schema)resolved.getProperties().get(key);
                        if (prop.getRequired() != null && prop.getRequired().get(count) != null) {
                            requiredProperties.add(key);
                        }
                        ++count;
                        model.addProperties(key, this.resolveSchema(prop));
                    }
                }
            } else if (composedSchema.getOneOf() != null) {
                for (Schema innerModel : composedSchema.getOneOf()) {
                    resolved = this.resolveSchema(innerModel);
                    properties = resolved.getProperties();
                    if (resolved.getProperties() == null) continue;
                    count = 0;
                    for (String key : properties.keySet()) {
                        prop = (Schema)resolved.getProperties().get(key);
                        if (prop.getRequired() != null && prop.getRequired().get(count) != null) {
                            requiredProperties.add(key);
                        }
                        ++count;
                        model.addProperties(key, this.resolveSchema(prop));
                    }
                }
            } else if (composedSchema.getAnyOf() != null) {
                for (Schema innerModel : composedSchema.getAnyOf()) {
                    resolved = this.resolveSchema(innerModel);
                    properties = resolved.getProperties();
                    if (resolved.getProperties() == null) continue;
                    count = 0;
                    for (String key : properties.keySet()) {
                        prop = (Schema)resolved.getProperties().get(key);
                        if (prop.getRequired() != null && prop.getRequired().get(count) != null) {
                            requiredProperties.add(key);
                        }
                        ++count;
                        model.addProperties(key, this.resolveSchema(prop));
                    }
                }
            }
            if (requiredProperties.size() > 0) {
                model.setRequired(new ArrayList(requiredProperties));
            }
            if (composedSchema.getExtensions() != null) {
                Map extensions = composedSchema.getExtensions();
                for (String key : extensions.keySet()) {
                    model.addExtension(key, composedSchema.getExtensions().get(key));
                }
            }
            return model;
        }
        return schema;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.swagger.parser.v3.util.ResolverFully", ResolverFully.class, null, null);
    }
}

