/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.openapi.publicapi.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.openapi.OASProviderAggregator;
import com.ibm.ws.openapi.internal.OpenAPIUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class PublicOpenAPIHandlerServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final TraceComponent tc = Tr.register(PublicOpenAPIHandlerServlet.class, (String)"OpenAPI", null);
    private transient OASProviderAggregator oasProviderAggregator;
    private static final String ACCEPT_HEADER = "Accept";
    private static final String QUERY_COMPACT = "compact";
    private static final String MIME_JSON = "application/json";
    private static final String MIME_YAML = "application/yaml";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if ("GET".equals(request.getMethod())) {
            boolean compact = Boolean.valueOf(request.getParameter(QUERY_COMPACT));
            boolean yaml = true;
            String accept = request.getHeader(ACCEPT_HEADER);
            if (accept == null) {
                yaml = true;
                response.setContentType(MIME_YAML);
            } else if (accept.contains(MIME_YAML)) {
                yaml = true;
                response.setContentType(MIME_YAML);
            } else if (accept.contains(MIME_JSON)) {
                yaml = false;
                response.setContentType(MIME_JSON);
            }
            boolean isSuccess = this.getOASProviderAggregator(false).getPublicDocumentation(request, compact, yaml, response);
            if (!isSuccess) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"Couldn't get public API documentation. Retry after resetting the aggregator.", (Object[])new Object[0]);
                }
                this.getOASProviderAggregator(true).getPublicDocumentation(request, compact, yaml, response);
            }
        }
    }

    private synchronized OASProviderAggregator getOASProviderAggregator(boolean resetAggregator) throws ServletException {
        if (this.oasProviderAggregator == null || resetAggregator) {
            this.setOASProviderAggregator();
        }
        return this.oasProviderAggregator;
    }

    private void setOASProviderAggregator() throws ServletException {
        BundleContext bundleContext = (BundleContext)this.getServletContext().getAttribute("osgi-bundlecontext");
        ServiceReference oasProviderAggregatorRef = bundleContext.getServiceReference(OASProviderAggregator.class);
        if (oasProviderAggregatorRef == null) {
            throw new ServletException(OpenAPIUtils.getOsgiServiceErrorMessage(((Object)((Object)this)).getClass(), (String)"OASProviderAggregator"));
        }
        this.oasProviderAggregator = (OASProviderAggregator)bundleContext.getService(oasProviderAggregatorRef);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("oasProviderAggregator=" + this.oasProviderAggregator), (Object[])new Object[0]);
        }
        if (this.oasProviderAggregator == null) {
            throw new ServletException(OpenAPIUtils.getOsgiServiceErrorMessage(((Object)((Object)this)).getClass(), (String)"OASProviderAggregator"));
        }
    }
}

