/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.openapi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.openapi.internal.CustomCSSProcessor;
import com.ibm.ws.openapi.internal.OASProviderFilterBuilder;
import com.ibm.ws.openapi.internal.OASProviderWrapper;
import com.ibm.ws.openapi.internal.OpenAPIUtils;
import com.ibm.ws.openapi.internal.ServerInfo;
import com.ibm.ws.openapi.internal.utils.ProxySupportUtil;
import com.ibm.ws.openapi.internal.validation.OASValidationResult;
import com.ibm.ws.openapi.internal.validation.OASValidator;
import com.ibm.ws.openapi.merge.OASMergeService;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.http.VirtualHost;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ServerQuiesceListener;
import com.ibm.wsspi.openapi.OASProvider;
import io.swagger.oas.models.OpenAPI;
import io.swagger.util.ObjectMapperFactory;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={OASProviderAggregator.class, ServerQuiesceListener.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM"})
public class OASProviderAggregator
implements ServerQuiesceListener {
    private static final TraceComponent tc = Tr.register(OASProviderAggregator.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi.internal.resources.OpenAPIMessages");
    private static final String KEY_EXECUTOR_SERVICE_REF = "executorService";
    private static final String QUERY_ROOT = "root";
    private final AtomicServiceReference<ScheduledExecutorService> executorServiceRef = new AtomicServiceReference("executorService");
    private final ConcurrentHashMap<OASProvider, OASProviderWrapper> oasProviderWrappers = new ConcurrentHashMap();
    private final ServerInfo serverInfo = new ServerInfo(null, -1, -1);
    private boolean isBundleActive = false;
    private final OASMergeService mergeService = new OASMergeService();
    private OpenAPI customizationOpenAPI = null;
    private volatile boolean validation = false;
    private ComponentContext context;
    private final AtomicReference<ComponentContext> contextRef = new AtomicReference();
    private volatile CustomCSSProcessor customCSSProcessor;
    private WsLocationAdmin locationAdminProvider;
    static final long serialVersionUID = 7043248148566902307L;

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> properties) {
        this.context = context;
        this.contextRef.set(this.context);
        this.customCSSProcessor = new CustomCSSProcessor();
        this.executorServiceRef.activate(context);
        this.isBundleActive = true;
        this.customCSSProcessor.restoreDefaultAtStartup((ScheduledExecutorService)this.executorServiceRef.getService());
        if (OpenAPIUtils.isEventEnabled.test(tc)) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"Activating OASProviderAggregator", (Object[])new Object[]{properties});
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context, int reason) {
        this.customCSSProcessor = null;
        this.executorServiceRef.deactivate(context);
        this.isBundleActive = false;
        if (OpenAPIUtils.isEventEnabled.test(tc)) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("Deactivating APIProviderAggregator, reason=" + reason), (Object[])new Object[0]);
        }
    }

    @Reference(name="executorService", service=ScheduledExecutorService.class)
    protected void setExecutorService(ServiceReference<ScheduledExecutorService> ref) {
        this.executorServiceRef.setReference(ref);
    }

    protected void unsetExecutorService(ServiceReference<ScheduledExecutorService> ref) {
        this.executorServiceRef.unsetReference(ref);
    }

    @Reference(service=WsLocationAdmin.class)
    protected void setLocationAdmin(WsLocationAdmin provider) {
        this.locationAdminProvider = provider;
    }

    protected void unsetLocationAdmin(WsLocationAdmin provider) {
        this.locationAdminProvider = null;
    }

    /*
     * WARNING - void declaration
     */
    @Reference(service=OASProvider.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY)
    protected void setOASProvider(OASProvider oasProvider) {
        OASProviderWrapper wrapper;
        block4: {
            wrapper = new OASProviderWrapper(this.contextRef, oasProvider);
            Callable<Boolean> callable = () -> {
                Boolean successful;
                OpenAPI openAPI;
                if (OpenAPIUtils.isDebugEnabled.test(tc)) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Submitting a provider processing task: " + oasProvider), (Object[])new Object[0]);
                }
                if ((openAPI = wrapper.getOpenAPI()) == null) {
                    successful = false;
                    wrapper.setValidity(false);
                } else {
                    boolean isValid = this.validation ? this.validateOpenAPI(wrapper.getOpenAPIProvider(), openAPI) : true;
                    OASMergeService oASMergeService = this.mergeService;
                    synchronized (oASMergeService) {
                        wrapper.setValidity(isValid);
                        successful = isValid ? Boolean.valueOf(this.addOpenAPI(wrapper)) : Boolean.valueOf(false);
                    }
                }
                if (OpenAPIUtils.isDebugEnabled.test(tc)) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Finished processing the provider: successful: " + successful + " - provider: " + oasProvider), (Object[])new Object[0]);
                }
                return successful;
            };
            try {
                if (this.executorServiceRef.getService() != null) {
                    Future<Boolean> future = this.getExecutorService().submit(callable);
                    wrapper.setFuture(future);
                } else {
                    callable.call();
                }
            }
            catch (Exception future) {
                void e;
                FFDCFilter.processException((Throwable)future, (String)"com.ibm.ws.openapi.OASProviderAggregator", (String)"178", (Object)this, (Object[])new Object[]{oasProvider});
                if (!OpenAPIUtils.isEventEnabled.test(tc)) break block4;
                Tr.event((Object)this, (TraceComponent)tc, (String)("Exception occured while removing the provider: " + oasProvider + "\n" + e), (Object[])new Object[0]);
            }
        }
        this.oasProviderWrappers.put(oasProvider, wrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void unsetOASProvider(OASProvider oasProvider) {
        OASProviderWrapper wrapper = this.oasProviderWrappers.remove(oasProvider);
        if (wrapper == null) {
            return;
        }
        Future<Boolean> job = wrapper.getFuture();
        OASMergeService oASMergeService = this.mergeService;
        synchronized (oASMergeService) {
            block14: {
                try {
                    boolean isValid = wrapper.isValid();
                    if (job == null) {
                        if (isValid) {
                            this.removeOpenAPI(wrapper);
                        }
                    } else if (job.isDone()) {
                        if (OpenAPIUtils.isDebugEnabled.test(tc)) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)("Started removing the provider: " + oasProvider), (Object[])new Object[0]);
                        }
                        if (isValid) {
                            this.removeOpenAPI(wrapper);
                        }
                    } else {
                        job.cancel(false);
                    }
                }
                catch (Exception isValid) {
                    void e;
                    FFDCFilter.processException((Throwable)isValid, (String)"com.ibm.ws.openapi.OASProviderAggregator", (String)"212", (Object)this, (Object[])new Object[]{oasProvider});
                    if (!OpenAPIUtils.isEventEnabled.test(tc)) break block14;
                    Tr.event((Object)this, (TraceComponent)tc, (String)("Exception occured while removing the provider: " + oasProvider + " \n" + e.getMessage()), (Object[])new Object[0]);
                }
            }
        }
        if (OpenAPIUtils.isDebugEnabled.test(tc)) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Finished removing the provider from the main document: " + oasProvider), (Object[])new Object[0]);
        }
    }

    @Reference(service=VirtualHost.class, target="(&(enabled=true)(id=default_host)(|(aliases=*)(httpsAlias=*)))", policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY)
    protected void setVirtualHost(VirtualHost vhost, Map<String, Object> props) {
        this.updateOpenAPIServer(vhost, props);
    }

    protected void updatedVirtualHost(VirtualHost vhost, Map<String, Object> props) {
        this.updateOpenAPIServer(vhost, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOpenAPIServer(VirtualHost vhost, Map<String, Object> props) {
        Object value = props.get("httpsAlias");
        if (value == null) {
            CharSequence[] aliases = (String[])props.get("aliases");
            if (OpenAPIUtils.isDebugEnabled.test(tc)) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("httpsAlias is null. aliases : " + String.join((CharSequence)", ", aliases)), (Object[])new Object[0]);
            }
            value = Arrays.stream(aliases).filter(a -> !a.endsWith(":-1")).findFirst().orElse(null);
            if (OpenAPIUtils.isDebugEnabled.test(tc)) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Found non-secure alias: " + value), (Object[])new Object[0]);
            }
        }
        String alias = String.valueOf(value);
        if (OpenAPIUtils.isEventEnabled.test(tc)) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("Received new alias: " + alias), (Object[])new Object[0]);
        }
        ServerInfo serverInfo = this.serverInfo;
        synchronized (serverInfo) {
            this.serverInfo.setHost(vhost.getHostName(alias));
            this.serverInfo.setHttpPort(vhost.getHttpPort(alias));
            this.serverInfo.setHttpsPort(vhost.getSecureHttpPort(alias));
            this.checkVCAPHost(this.serverInfo);
        }
        if (OpenAPIUtils.isEventEnabled.test(tc)) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("Updated server information: " + this.serverInfo), (Object[])new Object[0]);
        }
    }

    @FFDCIgnore(value={Exception.class})
    private void checkVCAPHost(ServerInfo server) {
        block5: {
            String VCAP_APPLICATION = System.getenv("VCAP_APPLICATION");
            if (VCAP_APPLICATION != null) {
                try {
                    JsonNode node = (JsonNode)ObjectMapperFactory.createJson().readValue(VCAP_APPLICATION, JsonNode.class);
                    ArrayNode uris = (ArrayNode)node.get("uris");
                    if (uris != null && uris.size() > 0 && uris.get(0) != null) {
                        server.setHost(uris.get(0).textValue());
                    }
                    if (OpenAPIUtils.isEventEnabled.test(tc)) {
                        Tr.event((Object)this, (TraceComponent)tc, (String)("Changed hostPort using VCAP_APPLICATION.  New value: " + server.getHost()), (Object[])new Object[0]);
                    }
                }
                catch (Exception e) {
                    if (!OpenAPIUtils.isEventEnabled.test(tc)) break block5;
                    Tr.event((Object)this, (TraceComponent)tc, (String)("Exception while parsing VCAP_APPLICATION env: " + e.getMessage()), (Object[])new Object[0]);
                }
            }
        }
    }

    public boolean getPublicDocumentation(HttpServletRequest request, boolean compact, boolean yaml, HttpServletResponse response) {
        return this.getDocumentation(request, compact, yaml, response, new OASProviderFilterBuilder().addPredicate(OASProviderFilterBuilder.publicFilter()));
    }

    public boolean getDocumentation(HttpServletRequest request, boolean compact, boolean yaml, HttpServletResponse response) {
        return this.getDocumentation(request, compact, yaml, response, new OASProviderFilterBuilder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public boolean getDocumentation(HttpServletRequest request, boolean compact, boolean yaml, HttpServletResponse response, OASProviderFilterBuilder filterBuilder) {
        block7: {
            if (this.isBundleActive) {
                this.processRequest(request, filterBuilder);
                OpenAPI openAPI = this.getMergedDocumentation(filterBuilder);
                ServerInfo reqServerInfo = null;
                ServerInfo serverInfo = this.serverInfo;
                synchronized (serverInfo) {
                    reqServerInfo = new ServerInfo(this.serverInfo);
                }
                ProxySupportUtil.processRequest(request, reqServerInfo);
                reqServerInfo.updateServers(openAPI);
                String serializedDocument = yaml && compact ? OpenAPIUtils.getCompactYamlDocument(openAPI) : (yaml && !compact ? OpenAPIUtils.getPrettyYamlDocument(openAPI) : (!yaml && compact ? OpenAPIUtils.getCompactJsonDocument(openAPI) : OpenAPIUtils.getPrettyJsonDocument(openAPI)));
                if (OpenAPIUtils.isDumpEnabled.test(tc)) {
                    Tr.dump((TraceComponent)tc, (String)("Returning document into the response: compact? " + compact + " yaml?" + yaml + " \n" + serializedDocument), (Object[])new Object[0]);
                }
                try {
                    response.setCharacterEncoding("UTF-8");
                    response.getWriter().write(serializedDocument);
                    return true;
                }
                catch (IOException iOException) {
                    void e;
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.openapi.OASProviderAggregator", (String)"328", (Object)this, (Object[])new Object[]{request, compact, yaml, response, filterBuilder});
                    if (!OpenAPIUtils.isEventEnabled.test(tc)) break block7;
                    Tr.event((Object)this, (TraceComponent)tc, (String)("Exception occured while writing to document to the response: " + e.getMessage()), (Object[])new Object[0]);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OpenAPI getMergedDocumentation(OASProviderFilterBuilder filterBuilder) {
        OpenAPI openAPI = this.createOpenAPI();
        OASMergeService oASMergeService = this.mergeService;
        synchronized (oASMergeService) {
            Stream<OASProviderWrapper> s = this.oasProviderWrappers.values().stream().filter(filterBuilder.getPredicate());
            if (filterBuilder.getFindFirst()) {
                OASProviderWrapper w = s.findFirst().orElse(null);
                if (w != null && w.getOpenAPI() != null) {
                    this.mergeService.mergeOpenAPI(openAPI, w.getOpenAPI());
                }
            } else {
                s.forEach(v -> {
                    if (v.getOpenAPI() != null) {
                        this.mergeService.mergeOpenAPI(openAPI, v.getOpenAPI());
                    }
                });
            }
        }
        return openAPI;
    }

    private void processRequest(HttpServletRequest request, OASProviderFilterBuilder filterBuilder) {
        String contextRoot = request.getParameter(QUERY_ROOT);
        if (contextRoot != null && !contextRoot.isEmpty()) {
            filterBuilder.addPredicate(OASProviderFilterBuilder.contextRootFilter(contextRoot));
        }
    }

    private ScheduledExecutorService getExecutorService() {
        ScheduledExecutorService service = (ScheduledExecutorService)this.executorServiceRef.getService();
        if (service == null) {
            throw new IllegalStateException(OpenAPIUtils.getOsgiServiceErrorMessage(this.getClass(), "ScheduledExecutorService"));
        }
        return service;
    }

    /*
     * WARNING - void declaration
     */
    private boolean addOpenAPI(OASProviderWrapper wrapper) {
        block2: {
            try {
                this.mergeService.addAPIProvider(wrapper);
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.openapi.OASProviderAggregator", (String)"376", (Object)this, (Object[])new Object[]{wrapper});
                if (!OpenAPIUtils.isEventEnabled.test(tc)) break block2;
                Tr.event((Object)this, (TraceComponent)tc, (String)("Exception occurred while merging the Open API from the provider: " + wrapper.getOpenAPIProvider() + e), (Object[])new Object[0]);
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void removeOpenAPI(OASProviderWrapper wrapper) {
        block2: {
            try {
                this.mergeService.removeAPIProvider(wrapper);
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.openapi.OASProviderAggregator", (String)"388", (Object)this, (Object[])new Object[]{wrapper});
                if (!OpenAPIUtils.isEventEnabled.test(tc)) break block2;
                Tr.event((Object)this, (TraceComponent)tc, (String)("Exception occured while removing the Open API from the provider: " + wrapper.getOpenAPIProvider() + e), (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OpenAPI createOpenAPI() {
        OASMergeService oASMergeService = this.mergeService;
        synchronized (oASMergeService) {
            OpenAPI openAPI = OpenAPIUtils.createDefaultOpenAPI();
            if (this.customizationOpenAPI != null) {
                openAPI.setInfo(OpenAPIUtils.ensureValidInfo(this.customizationOpenAPI.getInfo()));
                openAPI.setSecurity(this.customizationOpenAPI.getSecurity());
                openAPI.setExternalDocs(this.customizationOpenAPI.getExternalDocs());
                if (this.customizationOpenAPI.getServers() != null && !this.customizationOpenAPI.getServers().isEmpty()) {
                    openAPI.setServers(this.customizationOpenAPI.getServers());
                } else if (this.serverInfo != null) {
                    this.serverInfo.updateServers(openAPI);
                }
                OpenAPIUtils.copyOpenAPIObjectExtensions(this.customizationOpenAPI, openAPI);
            }
            return openAPI;
        }
    }

    private boolean validateOpenAPI(OASProvider provider, OpenAPI openAPI) {
        OASValidator validator = new OASValidator();
        OASValidationResult result = validator.validate(openAPI);
        AtomicBoolean isValid = new AtomicBoolean(true);
        if (result.hasEvents()) {
            result.getEvents().stream().forEach(v -> {
                if (v.severity == OASValidationResult.ValidationEvent.Severity.ERROR) {
                    isValid.set(false);
                    Tr.error((TraceComponent)tc, (String)"INVALID_OPENAPI_DOCUMENT", (Object[])new Object[]{provider, v.message});
                } else if (v.severity == OASValidationResult.ValidationEvent.Severity.WARNING) {
                    Tr.warning((TraceComponent)tc, (String)"INVALID_OPENAPI_DOCUMENT", (Object[])new Object[]{provider, v.message});
                }
            });
        }
        return isValid.get();
    }

    public void setValidation(boolean validation) {
        this.validation = validation;
    }

    public void pushOpenAPIDefinition(OpenAPI openAPI) {
        this.customizationOpenAPI = openAPI;
        this.processCustomCSS(this.customizationOpenAPI);
        if (OpenAPIUtils.isEventEnabled.test(tc)) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("Pushed OpenAPI definition (" + (openAPI == null ? "default" : "customized") + ")."), (Object[])new Object[0]);
        }
    }

    private void processCustomCSS(OpenAPI openAPI) {
        CustomCSSProcessor processor = this.customCSSProcessor;
        WsLocationAdmin locationAdmin = this.locationAdminProvider;
        if (processor != null && locationAdmin != null) {
            processor.process(openAPI, locationAdmin, this.getExecutorService());
        } else if (OpenAPIUtils.isEventEnabled.test(tc)) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("CSS was not processed. CustomCSSProcessor and/or WsLocationAdmin is null. CustomCSSProcessor=" + processor + " :  WsLocationAdmin=" + this.locationAdminProvider), (Object[])new Object[0]);
        }
    }

    public void serverStopping() {
        CustomCSSProcessor css = this.customCSSProcessor;
        if (css != null) {
            css.serverStopping();
        }
    }
}

