/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.openapi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.openapi.OpenAPICustomizer;
import com.ibm.ws.openapi.internal.OpenAPIUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.wab.configure.WABConfiguration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={OpenAPIConfig.class}, configurationPid={"com.ibm.ws.openapi"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, immediate=true, property={"service.vendor=IBM"})
public class OpenAPIConfig {
    private static final String PUBLIC_OPEN_API_DOCS_VAR_NAME = "publicOpenAPIDocsURL";
    private static final String PUBLIC_OPEN_API_DOCS_CONTEXT_PATH_SUFFIX = "/docs";
    private static final String PUBLIC_OPEN_API_EXPLORER_VAR_NAME = "publicOpenAPIExplorerURL";
    private static final String PUBLIC_OPEN_API_EXPLORER_CONTEXT_PATH_SUFFIX = "/explorer";
    private static final String PRIVATE_OPEN_API_DOCS_VAR_NAME = "privateOpenAPIDocsURL";
    private static final String PRIVATE_OPEN_API_DOCS_URL = "/ibm/api/docs";
    private static final String PRIVATE_OPEN_API_EXPLORER_VAR_NAME = "privateOpenAPIExplorerURL";
    private static final String PRIVATE_OPEN_API_EXPLORER_URL = "/ibm/api/explorer";
    public static final TraceComponent tc = Tr.register(OpenAPIConfig.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi.internal.resources.OpenAPIMessages");
    private static final String CONFIG_CUSTOMIZATION = "customization";
    private static final String CONFIG_ENABLE_PRIVATE = "enablePrivateURL";
    private static final String CONFIG_PUBLIC_URL = "publicURL";
    private static final String CONFIG_VALIDATION = "validation";
    private static final String CONFIG_DISABLE_FILE_MONITOR = "disableFileMonitor";
    private static final String DEFAULT_PUBLIC_URL = "/api";
    private static final String RESERVED_URL = "/ibm/api";
    private final String KEY_OPENAPI_CUSTOMIZER = "openapiCustomizer";
    private final AtomicServiceReference<OpenAPICustomizer> openapiCustomizerRef = new AtomicServiceReference("openapiCustomizer");
    private String customization;
    private Boolean enablePrivate = null;
    private String publicURL = null;
    private Boolean validation = null;
    private Boolean disableFileMonitor = null;
    private final List<PublicOpenAPIWABConfigManager> publicWabConfigMgrs;
    private final List<PrivateOpenAPIWABConfigManager> privateWabConfigMgrs;
    static final long serialVersionUID = 1672005865196139912L;

    public OpenAPIConfig() {
        this.setDefaults(false);
        this.publicWabConfigMgrs = new ArrayList<PublicOpenAPIWABConfigManager>();
        this.publicWabConfigMgrs.add(new PublicOpenAPIWABConfigManager(PUBLIC_OPEN_API_DOCS_VAR_NAME, PUBLIC_OPEN_API_DOCS_CONTEXT_PATH_SUFFIX));
        this.publicWabConfigMgrs.add(new PublicOpenAPIWABConfigManager(PUBLIC_OPEN_API_EXPLORER_VAR_NAME, PUBLIC_OPEN_API_EXPLORER_CONTEXT_PATH_SUFFIX));
        this.privateWabConfigMgrs = new ArrayList<PrivateOpenAPIWABConfigManager>();
        this.privateWabConfigMgrs.add(new PrivateOpenAPIWABConfigManager(PRIVATE_OPEN_API_DOCS_VAR_NAME, PRIVATE_OPEN_API_DOCS_URL));
        this.privateWabConfigMgrs.add(new PrivateOpenAPIWABConfigManager(PRIVATE_OPEN_API_EXPLORER_VAR_NAME, PRIVATE_OPEN_API_EXPLORER_URL));
    }

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> properties) {
        this.openapiCustomizerRef.activate(context);
        if (OpenAPIUtils.isEventEnabled.test(tc)) {
            Tr.event((TraceComponent)tc, (String)("activate OpenAPIConfig with " + properties.size() + " properties."), (Object[])new Object[0]);
        }
        this.processConfig(context, properties);
    }

    @Modified
    protected void modified(ComponentContext context, Map<String, Object> properties) throws IOException {
        if (OpenAPIUtils.isEventEnabled.test(tc)) {
            Tr.event((TraceComponent)tc, (String)("modified OpenAPIConfig with " + properties.size() + " properties."), (Object[])new Object[0]);
        }
        this.processConfig(context, properties);
    }

    @Deactivate
    protected void deactivate(ComponentContext context, int reason) {
        if (OpenAPIUtils.isEventEnabled.test(tc)) {
            Tr.event((TraceComponent)tc, (String)("deactivate OpenAPIConfig with reason=" + reason), (Object[])new Object[0]);
        }
        for (PrivateOpenAPIWABConfigManager privateWabConfigMgr : this.privateWabConfigMgrs) {
            privateWabConfigMgr.deactivate();
        }
        this.openapiCustomizerRef.deactivate(context);
    }

    private synchronized void setDefaults(boolean processConfig) {
        this.customization = null;
        this.validation = null;
        this.disableFileMonitor = null;
        this.publicURL = processConfig ? DEFAULT_PUBLIC_URL : null;
    }

    private synchronized void processConfig(ComponentContext context, Map<String, Object> properties) {
        String customizationOld = this.customization;
        String publicURLOld = this.publicURL;
        Boolean enablePrivateOld = this.enablePrivate;
        Boolean validationOld = this.validation;
        Boolean disableFileMonitorOld = this.disableFileMonitor;
        if (properties == null) {
            this.setDefaults(true);
            OpenAPICustomizer customizer = this.getOpenAPICustomizer();
            customizer.setCustomization(this.customization);
            customizer.setValidation(false);
            customizer.setDisableFileMonitor(false);
        } else {
            this.customization = (String)properties.get(CONFIG_CUSTOMIZATION);
            String publicURLObj = (String)properties.get(CONFIG_PUBLIC_URL);
            if (publicURLObj != null) {
                if (!publicURLObj.startsWith("/")) {
                    publicURLObj = '/' + publicURLObj;
                }
                if (publicURLObj.endsWith("/") && !publicURLObj.equals("/")) {
                    publicURLObj = publicURLObj.substring(0, publicURLObj.length() - 1);
                }
                if (RESERVED_URL.equals(publicURLObj)) {
                    Tr.warning((TraceComponent)tc, (String)"PUBLIC_URL_INVALID", (Object[])new Object[]{RESERVED_URL});
                    publicURLObj = publicURLOld;
                }
            } else {
                publicURLObj = DEFAULT_PUBLIC_URL;
            }
            this.publicURL = publicURLObj;
            this.enablePrivate = (Boolean)properties.get(CONFIG_ENABLE_PRIVATE);
            this.validation = (Boolean)properties.get(CONFIG_VALIDATION);
            this.disableFileMonitor = (Boolean)properties.get(CONFIG_DISABLE_FILE_MONITOR);
            if (this.valueChanged(publicURLOld, this.publicURL)) {
                for (PublicOpenAPIWABConfigManager publicWabConfigMgr : this.publicWabConfigMgrs) {
                    publicWabConfigMgr.updateWABConfiguration(context, this.publicURL);
                }
            }
            if (this.valueChanged(enablePrivateOld, this.enablePrivate)) {
                for (PrivateOpenAPIWABConfigManager privateWabConfigMgr : this.privateWabConfigMgrs) {
                    privateWabConfigMgr.processEnablePrivate(context, this.enablePrivate);
                }
            }
            OpenAPICustomizer customizer = null;
            boolean customizationValueChanged = this.valueChanged(customizationOld, this.customization);
            if (this.valueChanged(disableFileMonitorOld, this.disableFileMonitor)) {
                customizer = this.getOpenAPICustomizer();
                customizer.setDisableFileMonitor(Boolean.TRUE.equals(this.disableFileMonitor));
                if (!customizationValueChanged) {
                    customizer.setCustomization(this.customization);
                }
            }
            if (customizationValueChanged) {
                if (customizer == null) {
                    customizer = this.getOpenAPICustomizer();
                }
                customizer.setCustomization(this.customization);
            }
            if (this.valueChanged(validationOld, this.validation)) {
                if (customizer == null) {
                    customizer = this.getOpenAPICustomizer();
                }
                customizer.setValidation(Boolean.TRUE.equals(this.validation));
            }
        }
    }

    private boolean valueChanged(Object oldValue, Object newValue) {
        return oldValue == null ? newValue != null : !oldValue.equals(newValue);
    }

    protected OpenAPICustomizer getOpenAPICustomizer() {
        OpenAPICustomizer openapiCustomizer = (OpenAPICustomizer)this.openapiCustomizerRef.getService();
        if (openapiCustomizer == null) {
            throw new IllegalStateException(OpenAPIUtils.getOsgiServiceErrorMessage(this.getClass(), "OpenAPICustomizer"));
        }
        return openapiCustomizer;
    }

    @Reference(service=OpenAPICustomizer.class, name="openapiCustomizer")
    protected void setOpenAPICustomizer(ServiceReference<OpenAPICustomizer> openapiCustomizer) {
        this.openapiCustomizerRef.setReference(openapiCustomizer);
    }

    protected void unsetOpenAPICustomizer(ServiceReference<OpenAPICustomizer> openapiCustomizer) {
        this.openapiCustomizerRef.unsetReference(openapiCustomizer);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static final class PrivateOpenAPIWABConfigManager
    extends WABConfigManager {
        private final String contextPath;
        static final long serialVersionUID = 5375689418833622190L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public PrivateOpenAPIWABConfigManager(String contextName, String contextPath) {
            super(contextName);
            this.contextPath = contextPath;
        }

        public void processEnablePrivate(ComponentContext context, boolean enabled) {
            if (OpenAPIUtils.isEventEnabled.test(tc)) {
                Tr.event((TraceComponent)tc, (String)("OpenAPI enablePrivateURL attribute updated: " + enabled + " WAB config=" + this.wabConfigReg), (Object[])new Object[0]);
            }
            if (this.wabConfigReg == null && !enabled) {
                return;
            }
            if (enabled) {
                this.pushConfiguration(context, this.contextPath);
            } else {
                this.deactivate();
            }
        }

        @Override
        public void registerEvent(Dictionary<String, String> props) {
            Tr.event((TraceComponent)tc, (String)("OpenAPI private web app bundle registered, WAB config=" + this.wabConfigReg + " using props=" + props), (Object[])new Object[0]);
        }

        @Override
        public void modifiedEvent(Dictionary<String, String> props) {
            Tr.event((TraceComponent)tc, (String)("OpenAPI private web app bundle modified, WAB config=" + this.wabConfigReg + " using props=" + props), (Object[])new Object[0]);
        }

        @Override
        public void deactivateEvent() {
            Tr.event((TraceComponent)tc, (String)("Unregistered private web app bundle, WAB config=" + this.wabConfigReg + " for contextName=" + this.contextName + " and contextPath=" + this.contextPath), (Object[])new Object[0]);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.openapi.OpenAPIConfig$PrivateOpenAPIWABConfigManager", PrivateOpenAPIWABConfigManager.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi.internal.resources.OpenAPIMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static final class PublicOpenAPIWABConfigManager
    extends WABConfigManager {
        private final String contextPathSuffix;
        static final long serialVersionUID = 352473123778984776L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public PublicOpenAPIWABConfigManager(String contextName, String contextPathSuffix) {
            super(contextName);
            this.contextPathSuffix = contextPathSuffix;
        }

        public void updateWABConfiguration(ComponentContext context, String publicURL) {
            if (OpenAPIUtils.isEventEnabled.test(tc)) {
                Tr.event((TraceComponent)tc, (String)("OpenAPI publicURL attribute updated: " + publicURL + " WAB config=" + this.wabConfigReg), (Object[])new Object[0]);
            }
            this.pushConfiguration(context, publicURL + this.contextPathSuffix);
        }

        @Override
        public void registerEvent(Dictionary<String, String> props) {
            Tr.event((TraceComponent)tc, (String)("OpenAPI public web app bundle registered, WAB config=" + this.wabConfigReg + " using props=" + props), (Object[])new Object[0]);
        }

        @Override
        public void modifiedEvent(Dictionary<String, String> props) {
            Tr.event((TraceComponent)tc, (String)("OpenAPI public web app bundle modified, WAB config=" + this.wabConfigReg + " using props=" + props), (Object[])new Object[0]);
        }

        @Override
        public void deactivateEvent() {
            Tr.event((TraceComponent)tc, (String)("Unregistered public web app bundle, WAB config=" + this.wabConfigReg + " for contextName=" + this.contextName + " and contextPathSuffix=" + this.contextPathSuffix), (Object[])new Object[0]);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.openapi.OpenAPIConfig$PublicOpenAPIWABConfigManager", PublicOpenAPIWABConfigManager.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi.internal.resources.OpenAPIMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static abstract class WABConfigManager {
        final String contextName;
        ServiceRegistration<WABConfiguration> wabConfigReg;
        static final long serialVersionUID = -2284863317595079191L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public WABConfigManager(String contextName) {
            this.contextName = contextName;
        }

        public final void pushConfiguration(ComponentContext context, String path) {
            BundleContext bundleContext = context.getBundleContext();
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("contextName", this.contextName);
            ((Dictionary)props).put("contextPath", path);
            if (this.wabConfigReg == null) {
                this.wabConfigReg = bundleContext.registerService(WABConfiguration.class, (Object)new WABConfiguration(){
                    static final long serialVersionUID = 2706553320475285669L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.openapi.OpenAPIConfig$WABConfigManager$1", 1.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi.internal.resources.OpenAPIMessages");
                    }
                }, props);
                if (OpenAPIUtils.isEventEnabled.test(tc)) {
                    this.registerEvent(props);
                }
            } else {
                this.wabConfigReg.setProperties(props);
                if (OpenAPIUtils.isEventEnabled.test(tc)) {
                    this.modifiedEvent(props);
                }
            }
        }

        public final void deactivate() {
            if (this.wabConfigReg != null) {
                this.wabConfigReg.unregister();
                if (OpenAPIUtils.isEventEnabled.test(tc)) {
                    this.deactivateEvent();
                }
                this.wabConfigReg = null;
            }
        }

        public abstract void registerEvent(Dictionary<String, String> var1);

        public abstract void modifiedEvent(Dictionary<String, String> var1);

        public abstract void deactivateEvent();

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.openapi.OpenAPIConfig$WABConfigManager", WABConfigManager.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi.internal.resources.OpenAPIMessages");
        }
    }
}

