/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.openapi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.openapi.OASProviderAggregator;
import com.ibm.ws.openapi.internal.OpenAPIUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.filemonitor.FileMonitor;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.location.WsResource;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.PathUtils;
import io.swagger.oas.models.OpenAPI;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={OpenAPICustomizer.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM"})
public class OpenAPICustomizer
implements FileMonitor {
    private static final TraceComponent tc = Tr.register(OpenAPICustomizer.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi.internal.resources.OpenAPIMessages");
    private WsLocationAdmin locationAdminProvider;
    private final String KEY_OAS_PROVIDER_AGGREGATOR = "oasProviderAggregator";
    private final AtomicServiceReference<OASProviderAggregator> oasProviderAggregatorRef = new AtomicServiceReference("oasProviderAggregator");
    private ComponentContext context;
    private ServiceRegistration<FileMonitor> fileMonitor;
    private String customizationLocation;
    private boolean monitorDefaults = true;
    private boolean disableFileMonitor = false;
    private final String DEFAULT_LOCATION_YAML = "${server.config.dir}/openapi/customization.yaml";
    private final String DEFAULT_LOCATION_YML = "${server.config.dir}/openapi/customization.yml";
    private final String DEFAULT_LOCATION_JSON = "${server.config.dir}/openapi/customization.json";
    private final List<File> defaultCustomizationFiles = new ArrayList<File>();
    static final long serialVersionUID = -2245557115302597985L;

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> properties) {
        this.context = context;
        this.oasProviderAggregatorRef.activate(context);
        this.normalizeDefaultCustomizerPaths();
        this.processDefaultCustomizationFiles();
    }

    private File normalizeCustomizerPath(String path) {
        String normalizedPath = PathUtils.normalize((String)path);
        WsResource resource = this.getLocationAdmin().resolveResource(normalizedPath);
        File customizationFile = resource.asFile();
        return customizationFile;
    }

    private void normalizeDefaultCustomizerPaths() {
        this.defaultCustomizationFiles.add(this.normalizeCustomizerPath("${server.config.dir}/openapi/customization.yaml"));
        this.defaultCustomizationFiles.add(this.normalizeCustomizerPath("${server.config.dir}/openapi/customization.yml"));
        this.defaultCustomizationFiles.add(this.normalizeCustomizerPath("${server.config.dir}/openapi/customization.json"));
    }

    @Deactivate
    protected void deactivate(ComponentContext context, int reason) {
        this.deactivateFileMonitor();
        this.oasProviderAggregatorRef.deactivate(context);
        this.customizationLocation = null;
        this.disableFileMonitor = false;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setCustomization(String customizationLocation) {
        boolean showWarning;
        OpenAPI customizedOpenAPI;
        block13: {
            this.customizationLocation = customizationLocation;
            customizedOpenAPI = null;
            showWarning = true;
            try {
                if (customizationLocation == null || customizationLocation.trim().isEmpty()) {
                    showWarning = false;
                    boolean bl = this.monitorDefaults = !this.disableFileMonitor;
                    if (this.processDefaultCustomizationFiles()) {
                        return;
                    }
                } else if (!(customizationLocation.charAt(0) != '/' || customizationLocation.endsWith(".yaml") || customizationLocation.endsWith(".yml") || customizationLocation.endsWith(".json"))) {
                    showWarning = false;
                    this.monitorDefaults = false;
                    this.deactivateFileMonitor();
                } else if (customizationLocation.startsWith("http:") || customizationLocation.startsWith("https:")) {
                    customizedOpenAPI = OpenAPIUtils.parseOpenAPI(OpenAPIUtils.getAPIDocumentFromURL(customizationLocation));
                    this.monitorDefaults = false;
                    this.deactivateFileMonitor();
                } else if (customizationLocation.endsWith(".yaml") || customizationLocation.endsWith(".yml") || customizationLocation.endsWith(".json")) {
                    this.monitorDefaults = false;
                    customizedOpenAPI = this.getOpenAPIFromFile(customizationLocation);
                }
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.openapi.OpenAPICustomizer", (String)"126", (Object)this, (Object[])new Object[]{customizationLocation});
                if (!OpenAPIUtils.isEventEnabled.test(tc)) break block13;
                Tr.event((Object)this, (TraceComponent)tc, (String)("Exception occurred while trying to read OpenAPI definition '" + customizationLocation + "' or create OpenAPI object. \n exception: " + e), (Object[])new Object[0]);
            }
        }
        if (customizedOpenAPI == null) {
            if (OpenAPIUtils.isEventEnabled.test(tc)) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("Document is null/empty for OpenAPI Definition: " + customizationLocation), (Object[])new Object[0]);
            }
            if (showWarning) {
                Tr.warning((TraceComponent)tc, (String)"CUSTOMIZATION_IS_NULL", (Object[])new Object[]{customizationLocation});
            }
        }
        this.getOASProviderAggregator().pushOpenAPIDefinition(customizedOpenAPI);
    }

    private void setDefaultCustomization(File customizationFile) {
        OpenAPI parsedOpenAPI = OpenAPIUtils.parseOpenAPI(OpenAPIUtils.getAPIDocFromFile(customizationFile));
        if (parsedOpenAPI == null) {
            if (OpenAPIUtils.isEventEnabled.test(tc)) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("Document is null/empty for OpenAPI Definition: " + customizationFile), (Object[])new Object[0]);
            }
            Tr.warning((TraceComponent)tc, (String)"CUSTOMIZATION_IS_NULL", (Object[])new Object[]{customizationFile});
        }
        this.getOASProviderAggregator().pushOpenAPIDefinition(parsedOpenAPI);
        if (OpenAPIUtils.isDebugEnabled.test(tc)) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Default customization file was pushed : location=" + customizationFile), (Object[])new Object[0]);
        }
    }

    public void setValidation(boolean validation) {
        this.getOASProviderAggregator().setValidation(validation);
    }

    public synchronized void setDisableFileMonitor(boolean value) {
        this.disableFileMonitor = value;
        if (this.disableFileMonitor) {
            this.deactivateFileMonitor();
        }
    }

    @Reference(service=OASProviderAggregator.class, name="oasProviderAggregator")
    protected void setOASProviderAggregator(ServiceReference<OASProviderAggregator> oasProviderAggregator) {
        this.oasProviderAggregatorRef.setReference(oasProviderAggregator);
    }

    protected void unsetOASProviderAggregator(ServiceReference<OASProviderAggregator> oasProviderAggregator) {
        this.oasProviderAggregatorRef.unsetReference(oasProviderAggregator);
    }

    protected OASProviderAggregator getOASProviderAggregator() {
        OASProviderAggregator oasProviderAggregator = (OASProviderAggregator)this.oasProviderAggregatorRef.getService();
        if (oasProviderAggregator == null) {
            throw new IllegalStateException(OpenAPIUtils.getOsgiServiceErrorMessage(this.getClass(), "OASProviderAggregator"));
        }
        return oasProviderAggregator;
    }

    @Reference(service=WsLocationAdmin.class)
    protected void setLocationAdmin(WsLocationAdmin provider) {
        this.locationAdminProvider = provider;
    }

    protected void unsetLocationAdmin(WsLocationAdmin provider) {
        this.locationAdminProvider = null;
    }

    private WsLocationAdmin getLocationAdmin() {
        if (this.locationAdminProvider == null) {
            throw new IllegalStateException(OpenAPIUtils.getOsgiServiceErrorMessage(this.getClass(), "WsLocationAdmin"));
        }
        return this.locationAdminProvider;
    }

    private OpenAPI getOpenAPIFromFile(String filePath) {
        String normalizedPath = PathUtils.normalize((String)filePath);
        WsResource resource = this.getLocationAdmin().resolveResource(normalizedPath);
        File customizationFile = resource.asFile();
        OpenAPI openapi = null;
        if (customizationFile != null) {
            this.monitorFiles(Arrays.asList(customizationFile.getAbsolutePath()));
            openapi = OpenAPIUtils.parseOpenAPI(OpenAPIUtils.getAPIDocFromFile(customizationFile));
        } else if (OpenAPIUtils.isEventEnabled.test(tc)) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("Failed to locate the file " + (customizationFile == null ? filePath : customizationFile.getAbsolutePath()) + "."), (Object[])new Object[0]);
        }
        return openapi;
    }

    /*
     * WARNING - void declaration
     */
    private boolean processDefaultCustomizationFiles() {
        List<Object> existingFiles;
        block6: {
            existingFiles = new ArrayList();
            try {
                existingFiles = this.defaultCustomizationFiles.stream().filter(f -> f.exists()).collect(Collectors.toList());
            }
            catch (SecurityException securityException) {
                void se;
                FFDCFilter.processException((Throwable)securityException, (String)"com.ibm.ws.openapi.OpenAPICustomizer", (String)"227", (Object)this, (Object[])new Object[0]);
                if (!OpenAPIUtils.isDebugEnabled.test(tc)) break block6;
                Tr.debug((Object)this, (TraceComponent)tc, (String)("SecurityException occurred while checking whether default files exist: " + se), (Object[])new Object[0]);
            }
        }
        int fileCount = existingFiles.size();
        if (fileCount == 0) {
            if (OpenAPIUtils.isDebugEnabled.test(tc)) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"None of the default customization files exist. Set up monitoring on all of them.", (Object[])new Object[0]);
            }
        } else {
            File file = (File)existingFiles.iterator().next();
            if (fileCount > 1) {
                Tr.warning((TraceComponent)tc, (String)"MULTIPLE_DEFAULT_OPENAPI_FILES", (Object[])new Object[]{existingFiles.stream().map(f -> f.getAbsolutePath()).collect(Collectors.joining(", ", "{", "}")), file.getAbsolutePath()});
            }
            this.monitorFiles(Arrays.asList(file.getAbsolutePath()));
            this.setDefaultCustomization(file);
            return true;
        }
        this.monitorFiles(this.defaultCustomizationFiles.stream().map(f -> f.getAbsolutePath()).collect(Collectors.toList()));
        return false;
    }

    public void onBaseline(Collection<File> arg0) {
    }

    public void onChange(Collection<File> createdFiles, Collection<File> modifiedFiles, Collection<File> deletedFiles) {
        if (OpenAPIUtils.isDebugEnabled.test(tc)) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Received notification from FileMonitor: createdFiles=" + createdFiles + " : modifiedFiles=" + modifiedFiles + " : deletedFiles=" + deletedFiles), (Object[])new Object[0]);
        }
        if (this.monitorDefaults) {
            File file;
            if (deletedFiles != null && !deletedFiles.isEmpty()) {
                if (OpenAPIUtils.isEventEnabled.test(tc)) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)("Default customization file was deleted : location=" + deletedFiles.iterator().next().toString()), (Object[])new Object[0]);
                }
                this.getOASProviderAggregator().pushOpenAPIDefinition(null);
                this.processDefaultCustomizationFiles();
            }
            if (createdFiles != null && !createdFiles.isEmpty()) {
                file = createdFiles.iterator().next();
                if (createdFiles.size() > 1) {
                    Tr.warning((TraceComponent)tc, (String)"MULTIPLE_DEFAULT_OPENAPI_FILES", (Object[])new Object[]{createdFiles.stream().map(f -> f.getAbsolutePath()).collect(Collectors.joining(", ", "{", "}")), file});
                }
                this.monitorFiles(Arrays.asList(file.getAbsolutePath()));
                this.setDefaultCustomization(file);
                if (OpenAPIUtils.isEventEnabled.test(tc)) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)("Default customization file was created : location=" + file.toString()), (Object[])new Object[0]);
                }
            }
            if (modifiedFiles != null && !modifiedFiles.isEmpty()) {
                file = modifiedFiles.iterator().next();
                this.setDefaultCustomization(file);
                if (OpenAPIUtils.isEventEnabled.test(tc)) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)("Default customization file was modified : location=" + file.toString()), (Object[])new Object[0]);
                }
            }
        } else if (createdFiles != null && !createdFiles.isEmpty() || modifiedFiles != null && !modifiedFiles.isEmpty() || deletedFiles != null && !deletedFiles.isEmpty()) {
            if (OpenAPIUtils.isEventEnabled.test(tc)) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("Customization file was modified/deleted/created : customizationLocation=" + this.customizationLocation), (Object[])new Object[0]);
            }
            this.setCustomization(this.customizationLocation);
        }
    }

    private synchronized void deactivateFileMonitor() {
        if (this.fileMonitor != null) {
            this.fileMonitor.unregister();
            this.fileMonitor = null;
            if (OpenAPIUtils.isEventEnabled.test(tc)) {
                Tr.event((Object)this, (TraceComponent)tc, (String)"Deactivated FileMonitor service.", (Object[])new Object[0]);
            }
        }
    }

    private synchronized void monitorFiles(List<String> fileLocations) {
        if (this.disableFileMonitor) {
            if (OpenAPIUtils.isDebugEnabled.test(tc)) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("FileMonitor is disabled. Not monitoring fileLocations=" + fileLocations.stream().map(f -> f.toString()).collect(Collectors.joining(", ", "{", "}"))), (Object[])new Object[0]);
            }
            return;
        }
        BundleContext bundleContext = this.context.getBundleContext();
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("service.vendor", "IBM");
        ((Dictionary)props).put("monitor.interval", "2s");
        ((Dictionary)props).put("monitor.files", fileLocations);
        if (this.fileMonitor == null) {
            this.fileMonitor = bundleContext.registerService(FileMonitor.class, (Object)this, props);
            if (OpenAPIUtils.isEventEnabled.test(tc)) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("Registered FileMonitor service : fileLocations=" + fileLocations.stream().map(f -> f.toString()).collect(Collectors.joining(", ", "{", "}"))), (Object[])new Object[0]);
            }
        } else {
            this.fileMonitor.setProperties(props);
            if (OpenAPIUtils.isEventEnabled.test(tc)) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("Updated FileMonitor service : fileLocations=" + fileLocations.stream().map(f -> f.toString()).collect(Collectors.joining(", ", "{", "}"))), (Object[])new Object[0]);
            }
        }
    }
}

