/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.openapi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.openapi.internal.OpenAPIUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.FileUtils;
import com.ibm.wsspi.openapi.OASProvider;
import com.ibm.wsspi.openapi.OASProviderConfig;
import com.ibm.wsspi.openapi.OASProviderResult;
import io.swagger.oas.models.OpenAPI;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={OASProvider.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class OpenAPIDocumentProvider
implements OASProvider {
    private static final String IBM_API_DOCS_CONTEXT_ROOT = "/ibm/api/docs";
    private static final String DOCUMENT_FILE_PATH = "/lib/openapi.yaml";
    private List<OASProviderResult> results = null;
    private WsLocationAdmin locationAdminProvider;
    private static final TraceComponent tc = Tr.register(OpenAPIDocumentProvider.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi.internal.resources.OpenAPIMessages");
    static final long serialVersionUID = -7305203500131797800L;

    @Reference(service=WsLocationAdmin.class)
    protected void setLocationAdmin(WsLocationAdmin provider) {
        this.locationAdminProvider = provider;
    }

    protected void unsetLocationAdmin(WsLocationAdmin provider) {
        this.locationAdminProvider = null;
    }

    public List<OASProviderResult> getResults() {
        if (this.results == null) {
            OASProviderResult result = new OASProviderResult(){
                private String openAPIdocument = null;
                static final long serialVersionUID = 6050594546153537714L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public String getDocument() {
                    block4: {
                        File openAPIfile;
                        if (this.openAPIdocument == null && (openAPIfile = OpenAPIDocumentProvider.this.getDocumentFile()) != null) {
                            try {
                                if (OpenAPIUtils.isEventEnabled.test(tc)) {
                                    Tr.event((Object)this, (TraceComponent)tc, (String)("Reading document name=" + openAPIfile.getAbsolutePath()), (Object[])new Object[0]);
                                }
                                byte[] buf = Files.readAllBytes(Paths.get(openAPIfile.getAbsolutePath(), new String[0]));
                                this.openAPIdocument = new String(buf, "UTF-8");
                            }
                            catch (IOException buf) {
                                FFDCFilter.processException((Throwable)buf, (String)"com.ibm.ws.openapi.OpenAPIDocumentProvider$1", (String)"77", (Object)this, (Object[])new Object[0]);
                                if (!OpenAPIUtils.isEventEnabled.test(tc)) break block4;
                                Tr.event((Object)this, (TraceComponent)tc, (String)("Error reading document name=" + openAPIfile.getAbsolutePath()), (Object[])new Object[0]);
                            }
                        }
                    }
                    return this.openAPIdocument;
                }

                public OpenAPI getOpenAPI() {
                    return null;
                }

                public OASProviderConfig getOASProviderConfig() {
                    return OASProviderConfig.defaultConfig();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.openapi.OpenAPIDocumentProvider$1", 1.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi.internal.resources.OpenAPIMessages");
                }
            };
            this.results = Arrays.asList(result);
        }
        return this.results;
    }

    public String getContextRoot() {
        return IBM_API_DOCS_CONTEXT_ROOT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public File getDocumentFile() {
        String path = this.locationAdminProvider.resolveString("${server.output.dir}//workarea/openapi.doc/openapi.yaml");
        File openApiDoc = new File(path);
        if (!FileUtils.fileExists((File)openApiDoc)) {
            try {
                if (OpenAPIUtils.isEventEnabled.test(tc)) {
                    Tr.event((TraceComponent)tc, (String)("File doesn't exist, need to copy to : " + path), (Object[])new Object[0]);
                }
                FileUtils.fileMkDirs((File)openApiDoc.getParentFile());
                FileUtils.fileCreate((File)openApiDoc);
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.openapi.OpenAPIDocumentProvider", (String)"122", (Object)this, (Object[])new Object[0]);
                if (OpenAPIUtils.isEventEnabled.test(tc)) {
                    void e;
                    Tr.event((TraceComponent)tc, (String)("IOException occurred while creating file/folder. e=" + e), (Object[])new Object[0]);
                }
                return null;
            }
            InputStream inputStream = this.getClass().getResourceAsStream(DOCUMENT_FILE_PATH);
            if (inputStream != null) {
                FileOutputStream outputStream = null;
                try {
                    int len;
                    outputStream = FileUtils.getFileOutputStream((File)openApiDoc);
                    byte[] buffer = new byte[2048];
                    while ((len = inputStream.read(buffer)) != -1) {
                        outputStream.write(buffer, 0, len);
                    }
                }
                catch (IOException buffer) {
                    FFDCFilter.processException((Throwable)buffer, (String)"com.ibm.ws.openapi.OpenAPIDocumentProvider", (String)"140", (Object)this, (Object[])new Object[0]);
                    FileUtils.fileDelete((File)openApiDoc);
                    if (OpenAPIUtils.isEventEnabled.test(tc)) {
                        void ioe;
                        Tr.event((TraceComponent)tc, (String)("IOException occurred while copying file contents. ioe" + ioe), (Object[])new Object[0]);
                    }
                    File file = null;
                    return file;
                }
                finally {
                    FileUtils.tryToClose((Closeable)outputStream);
                    FileUtils.tryToClose((Closeable)inputStream);
                }
            }
        }
        return openApiDoc;
    }

    public boolean isPublic() {
        return false;
    }
}

