/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.openapi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.openapi.OpenAPIReaderFactory;
import com.ibm.ws.openapi.SwaggerConfiguration;
import com.ibm.ws.openapi.internal.AnnotationScanner;
import com.ibm.ws.openapi.internal.OpenAPIUtils;
import com.ibm.ws.openapi.internal.bootstrapping.BootstrappingHelper;
import com.ibm.ws.openapi.internal.bootstrapping.OpenAPIConfigurationBuilderServiceLoader;
import com.ibm.ws.openapi.internal.bootstrapping.OpenAPIConfigurationClasspathLoader;
import com.ibm.ws.openapi.internal.bootstrapping.OpenAPIReaderServiceLoader;
import com.ibm.ws.openapi.internal.bootstrapping.OpenAPIScannerServiceLoader;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.openapi.OASProvider;
import com.ibm.wsspi.openapi.OASProviderConfig;
import com.ibm.wsspi.openapi.OASProviderResult;
import io.swagger.oas.integration.OpenAPIConfiguration;
import io.swagger.oas.integration.OpenAPIConfigurationBuilder;
import io.swagger.oas.integration.OpenAPIReader;
import io.swagger.oas.integration.OpenAPIScanner;
import io.swagger.oas.models.OpenAPI;
import io.swagger.oas.models.servers.Server;
import io.swagger.util.Yaml;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OpenAPIWebProvider
implements OASProvider {
    private static final TraceComponent tc = Tr.register(OpenAPIWebProvider.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi.internal.resources.OpenAPIMessages");
    private static final Dictionary<String, String> PROPS = new Hashtable<String, String>();
    private String moduleURL;
    private List<String> nonDefaultHosts;
    private boolean isPublic = true;
    private ServiceRegistration<OASProvider> serviceRegistration;
    private final ComponentContext cc;
    private String apiDocAsString = null;
    private OpenAPIConfiguration openAPIConfiguration;
    private OpenAPIReader openAPIReader;
    private OpenAPIScanner openAPIScanner;
    private final ClassLoader classLoader;
    private final AnnotationScanner annotationScanner;
    private OpenAPI cachedOpenAPI;
    static final long serialVersionUID = 8952816226561648006L;

    public OpenAPIWebProvider(ComponentContext cc, InputStream is, ClassLoader classLoader, Container container) throws UnableToAdaptException {
        this.cc = cc;
        this.nonDefaultHosts = null;
        this.isPublic = true;
        if (is != null) {
            this.apiDocAsString = OpenAPIUtils.getAPIDocFromStream(is);
        }
        this.classLoader = classLoader;
        this.annotationScanner = new AnnotationScanner(classLoader, container);
    }

    public void setModuleURL(String moduleURL) {
        this.moduleURL = moduleURL;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public void setIsPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    public void setNonDefaultHosts(List<String> nonDefaultHosts) {
        this.nonDefaultHosts = nonDefaultHosts;
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            this.registerOSGiService();
        } else {
            this.unregisterOSGiService();
        }
    }

    public void registerOSGiService() {
        this.unregisterOSGiService();
        this.getOpenAPIServices(this.classLoader);
        if (this.cachedOpenAPI == null && this.apiDocAsString == null && !this.annotationScanner.anyAnnotatedClasses() && (this.openAPIScanner == null || this.openAPIScanner.getClasses() == null || this.openAPIScanner.getClasses().isEmpty())) {
            if (OpenAPIUtils.isDebugEnabled.test(tc)) {
                Tr.debug((TraceComponent)tc, (String)"Avoiding registration because no annotated classes nor pre-generated docs were found in the web module, and no configuration was set.", (Object[])new Object[0]);
            }
            return;
        }
        this.serviceRegistration = this.cc.getBundleContext().registerService(OASProvider.class, (Object)this, PROPS);
        if (OpenAPIUtils.isDebugEnabled.test(tc)) {
            Tr.debug((TraceComponent)tc, (String)("Register Service Registration Obj: " + this.serviceRegistration), (Object[])new Object[0]);
        }
    }

    public void unregisterOSGiService() {
        if (OpenAPIUtils.isDebugEnabled.test(tc)) {
            Tr.debug((TraceComponent)tc, (String)("Unregister Service Registration Obj: " + this.serviceRegistration), (Object[])new Object[0]);
        }
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
        this.serviceRegistration = null;
    }

    public List<OASProviderResult> getResults() {
        OASProviderResult result = new OASProviderResult(){
            static final long serialVersionUID = -7684731560592160519L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            /*
             * WARNING - void declaration
             */
            public OpenAPI getOpenAPI() {
                block6: {
                    if (OpenAPIWebProvider.this.cachedOpenAPI != null) {
                        return OpenAPIWebProvider.this.cachedOpenAPI;
                    }
                    if (OpenAPIWebProvider.this.apiDocAsString != null) {
                        OpenAPIWebProvider.this.cachedOpenAPI = OpenAPIWebProvider.this.process(OpenAPIWebProvider.this.apiDocAsString);
                        return OpenAPIWebProvider.this.cachedOpenAPI;
                    }
                    try {
                        if (OpenAPIWebProvider.this.openAPIReader != null || OpenAPIWebProvider.this.openAPIConfiguration != null && OpenAPIWebProvider.this.openAPIConfiguration.getOpenAPI() != null) {
                            if (!OpenAPIWebProvider.this.annotationScanner.isThirdPartyAPIsAccessible()) {
                                Tr.warning((TraceComponent)tc, (String)"THIRD_PARTY_API_NOT_ACCESSIBLE", (Object[])new Object[]{OpenAPIWebProvider.this});
                            }
                            BootstrappingHelper bh = new BootstrappingHelper(OpenAPIWebProvider.this.classLoader, OpenAPIWebProvider.this.annotationScanner.getURLMapping());
                            OpenAPIWebProvider.this.cachedOpenAPI = OpenAPIWebProvider.this.process(bh.getOpenAPI(OpenAPIWebProvider.this.openAPIConfiguration, OpenAPIWebProvider.this.openAPIReader, OpenAPIWebProvider.this.openAPIScanner));
                            return OpenAPIWebProvider.this.cachedOpenAPI;
                        }
                    }
                    catch (Throwable bh) {
                        void e;
                        FFDCFilter.processException((Throwable)bh, (String)"com.ibm.ws.openapi.OpenAPIWebProvider$1", (String)"187", (Object)this, (Object[])new Object[0]);
                        if (!OpenAPIUtils.isEventEnabled.test(tc)) break block6;
                        Tr.event((TraceComponent)tc, (String)("Could not process annotations for application: " + this + "\n" + e), (Object[])new Object[0]);
                    }
                }
                return null;
            }

            public String getDocument() {
                return null;
            }

            public OASProviderConfig getOASProviderConfig() {
                return OASProviderConfig.defaultConfig();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.openapi.OpenAPIWebProvider$1", 1.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi.internal.resources.OpenAPIMessages");
            }
        };
        return Arrays.asList(result);
    }

    private OpenAPI process(String apiDocAsString) {
        if (apiDocAsString == null) {
            return null;
        }
        OpenAPI openAPI = OpenAPIUtils.parseOpenAPI(apiDocAsString);
        return this.process(openAPI);
    }

    private OpenAPI process(OpenAPI openAPI) {
        if (openAPI == null) {
            return null;
        }
        this.processOpenAPI(openAPI);
        return openAPI;
    }

    @FFDCIgnore(value={MalformedURLException.class})
    public String getContextRoot() {
        String contextRoot;
        block2: {
            contextRoot = null;
            try {
                contextRoot = this.moduleURL.startsWith("/") ? this.moduleURL : new URL(this.moduleURL).getPath();
            }
            catch (MalformedURLException e) {
                if (!OpenAPIUtils.isEventEnabled.test(tc)) break block2;
                Tr.event((Object)this, (TraceComponent)tc, (String)"Couldn't create context root URL: ", (Object[])new Object[]{e});
            }
        }
        return contextRoot;
    }

    private void getOpenAPIServices(ClassLoader classLoader) {
        this.getOpenAPIConfiguration(classLoader);
        this.getOpenAPIReader(classLoader);
        this.getOpenAPIScanner(classLoader);
    }

    private void getOpenAPIConfiguration(ClassLoader classLoader) {
        this.openAPIConfiguration = null;
        OpenAPIConfigurationBuilder configurationBuilder = new OpenAPIConfigurationBuilderServiceLoader().load(classLoader, this.toString());
        if (configurationBuilder != null) {
            this.openAPIConfiguration = configurationBuilder.build(null);
        }
        if (OpenAPIUtils.isDebugEnabled.test(tc)) {
            StringBuilder sb = new StringBuilder();
            if (configurationBuilder == null) {
                sb.append("Did not find any OpenAPIConfigurationBuilder using the service loader for the " + this);
            } else {
                sb.append("Found the OpenAPIConfigurationBuilder implementation '" + configurationBuilder.getClass().getName() + "' specified by the " + this);
            }
            sb.append(" :: ");
            if (this.openAPIConfiguration == null) {
                sb.append("Did not find any OpenAPIConfiguration using the OpenAPIConfigurationBuilder for the " + this);
            } else {
                String configAsString = null;
                try {
                    configAsString = Yaml.mapper().writeValueAsString((Object)this.openAPIConfiguration);
                }
                catch (JsonProcessingException jsonProcessingException) {
                    FFDCFilter.processException((Throwable)jsonProcessingException, (String)"com.ibm.ws.openapi.OpenAPIWebProvider", (String)"270", (Object)this, (Object[])new Object[]{classLoader});
                    configAsString = "Failed to serialize the configuration!";
                }
                sb.append("Found the OpenAPIConfiguration '" + this.openAPIConfiguration.getClass().getName() + "' specified through builder by the " + this + " configuration: " + configAsString);
            }
            Tr.debug((TraceComponent)tc, (String)sb.toString(), (Object[])new Object[0]);
        }
        if (this.openAPIConfiguration == null) {
            this.openAPIConfiguration = new OpenAPIConfigurationClasspathLoader().load(classLoader, this.toString());
            if (OpenAPIUtils.isDebugEnabled.test(tc)) {
                String message = this.openAPIConfiguration == null ? "Did not find any OpenAPIConfiguration from the classpath " + this : "Found the OpenAPIConfiguration specified through classpath by the " + this;
                Tr.debug((TraceComponent)tc, (String)message, (Object[])new Object[0]);
            }
        }
        if (this.openAPIConfiguration != null) {
            Tr.audit((TraceComponent)tc, (String)"FOUND_PROGRAMMING_MODEL", (Object[])new Object[]{OpenAPIConfiguration.class.getSimpleName(), this});
        }
        if (this.openAPIConfiguration == null) {
            this.openAPIConfiguration = new SwaggerConfiguration();
        }
    }

    @FFDCIgnore(value={ClassNotFoundException.class})
    private void getOpenAPIReader(ClassLoader classLoader) {
        block19: {
            String readerClass;
            this.openAPIReader = null;
            this.openAPIReader = new OpenAPIReaderServiceLoader().load(classLoader, this.toString());
            if (OpenAPIUtils.isDebugEnabled.test(tc)) {
                if (this.openAPIReader != null) {
                    Tr.debug((TraceComponent)tc, (String)("Found the OpenAPIReader '" + this.openAPIReader.getClass().getName() + "' specified by the " + this), (Object[])new Object[0]);
                } else {
                    Tr.debug((TraceComponent)tc, (String)("Did not find any OpenAPIReader using the service loader for the " + this), (Object[])new Object[0]);
                }
            }
            if (this.openAPIReader == null && this.openAPIConfiguration != null && (readerClass = this.openAPIConfiguration.getReaderClass()) != null && !readerClass.trim().isEmpty()) {
                try {
                    Class<?> cls;
                    Object readerIns;
                    if (OpenAPIUtils.isDebugEnabled.test(tc)) {
                        Tr.debug((TraceComponent)tc, (String)("Trying to load the OpenAPIReader specified in the OpenAPIConfiguration: [OpenAPIConfiguration=" + this.openAPIConfiguration.getClass().getName() + ", OpenAPIReader=" + readerClass + "]"), (Object[])new Object[0]);
                    }
                    if ((readerIns = (cls = classLoader.loadClass(readerClass)).newInstance()) instanceof OpenAPIReader) {
                        this.openAPIReader = (OpenAPIReader)readerIns;
                        if (OpenAPIUtils.isDebugEnabled.test(tc)) {
                            Tr.debug((TraceComponent)tc, (String)("Loaded the OpenAPIReader specified in the OpenAPIConfiguration: [OpenAPIConfiguration=" + this.openAPIConfiguration.getClass().getName() + ", OpenAPIReader=" + readerClass + "]"), (Object[])new Object[0]);
                        }
                    }
                }
                catch (ClassNotFoundException e) {
                    if (OpenAPIUtils.isEventEnabled.test(tc)) {
                        Tr.event((Object)this, (TraceComponent)tc, (String)("Couldn't find the specified class " + readerClass + "."), (Object[])new Object[0]);
                    }
                    Tr.error((TraceComponent)tc, (String)"FAILED_FINDING_CLASS", (Object[])new Object[]{OpenAPIScanner.class.getSimpleName(), this, e.toString()});
                }
                catch (IllegalAccessException | InstantiationException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.openapi.OpenAPIWebProvider", (String)"341", (Object)this, (Object[])new Object[]{classLoader});
                    if (!OpenAPIUtils.isEventEnabled.test(tc)) break block19;
                    Tr.event((Object)this, (TraceComponent)tc, (String)("Failed to create an instance of the class " + readerClass + "."), (Object[])new Object[0]);
                }
            }
        }
        if (this.openAPIReader != null) {
            Tr.audit((TraceComponent)tc, (String)"FOUND_PROGRAMMING_MODEL", (Object[])new Object[]{OpenAPIReader.class.getSimpleName(), this});
        }
        if (this.openAPIReader == null) {
            OpenAPIReaderFactory factory = null;
            ServiceReference sr = this.cc.getBundleContext().getServiceReference(OpenAPIReaderFactory.class);
            if (sr != null) {
                factory = (OpenAPIReaderFactory)this.cc.getBundleContext().getService(sr);
            }
            if (factory == null) {
                if (OpenAPIUtils.isEventEnabled.test(tc)) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)"Couldn't find the implementation of the OpenAPIReaderFactory.", (Object[])new Object[0]);
                }
            } else {
                this.openAPIReader = factory.createReader();
            }
            if (this.openAPIReader == null && OpenAPIUtils.isEventEnabled.test(tc)) {
                Tr.event((Object)this, (TraceComponent)tc, (String)"Couldn't find the default implementation of OpenAPIReader.", (Object[])new Object[0]);
            }
        }
        if (this.openAPIReader != null) {
            this.openAPIReader.setConfiguration(this.openAPIConfiguration);
        }
    }

    @FFDCIgnore(value={ClassNotFoundException.class})
    private void getOpenAPIScanner(ClassLoader classLoader) {
        block15: {
            String scannerClass;
            this.openAPIScanner = null;
            this.openAPIScanner = new OpenAPIScannerServiceLoader().load(classLoader, this.toString());
            if (OpenAPIUtils.isDebugEnabled.test(tc)) {
                if (this.openAPIScanner != null) {
                    Tr.debug((TraceComponent)tc, (String)("Found the OpenAPIScanner specified by the " + this), (Object[])new Object[0]);
                } else {
                    Tr.debug((TraceComponent)tc, (String)("Did not find any OpenAPIScanner using the service loader for the " + this), (Object[])new Object[0]);
                }
            }
            if (this.openAPIScanner == null && this.openAPIConfiguration != null && (scannerClass = this.openAPIConfiguration.getScannerClass()) != null && !scannerClass.trim().isEmpty()) {
                if (OpenAPIUtils.isDebugEnabled.test(tc)) {
                    Tr.debug((TraceComponent)tc, (String)("Loading the OpenAPIScanner specified in the OpenAPIConfiguration: [ScannerClass=" + scannerClass + "]"), (Object[])new Object[0]);
                }
                try {
                    Class<?> cls = classLoader.loadClass(scannerClass);
                    Object scannerInstance = cls.newInstance();
                    if (scannerInstance instanceof OpenAPIScanner) {
                        this.openAPIScanner = (OpenAPIScanner)scannerInstance;
                        if (OpenAPIUtils.isDebugEnabled.test(tc)) {
                            Tr.debug((TraceComponent)tc, (String)("Loaded the OpenAPIScanner specified in the OpenAPIConfiguration: [ScannerClass=" + scannerClass + "]"), (Object[])new Object[0]);
                        }
                    }
                }
                catch (ClassNotFoundException e) {
                    if (OpenAPIUtils.isEventEnabled.test(tc)) {
                        Tr.event((Object)this, (TraceComponent)tc, (String)("Couldn't find the specified class " + scannerClass + "."), (Object[])new Object[0]);
                    }
                    Tr.error((TraceComponent)tc, (String)"FAILED_FINDING_CLASS", (Object[])new Object[]{OpenAPIReader.class.getSimpleName(), this, e.toString()});
                }
                catch (IllegalAccessException | InstantiationException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.openapi.OpenAPIWebProvider", (String)"417", (Object)this, (Object[])new Object[]{classLoader});
                    if (!OpenAPIUtils.isEventEnabled.test(tc)) break block15;
                    Tr.event((Object)this, (TraceComponent)tc, (String)("Failed to create an instance of the class " + scannerClass + "."), (Object[])new Object[0]);
                }
            }
        }
        if (this.openAPIScanner != null) {
            Tr.audit((TraceComponent)tc, (String)"FOUND_PROGRAMMING_MODEL", (Object[])new Object[]{OpenAPIScanner.class.getSimpleName(), this});
        }
        if (this.openAPIScanner == null) {
            if (OpenAPIUtils.isDebugEnabled.test(tc)) {
                Tr.debug((TraceComponent)tc, (String)"Creating a default instance of the OpenAPIScanner.", (Object[])new Object[0]);
            }
            this.openAPIScanner = new OpenAPIScanner(){
                static final long serialVersionUID = 8259997227904117705L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public Map<String, Object> getResources() {
                    return null;
                }

                public Set<Class<?>> getClasses() {
                    try {
                        return OpenAPIWebProvider.this.annotationScanner.getAnnotatedClasses();
                    }
                    catch (UnableToAdaptException unableToAdaptException) {
                        FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.openapi.OpenAPIWebProvider$2", (String)"444", (Object)this, (Object[])new Object[0]);
                        if (OpenAPIUtils.isEventEnabled.test(tc)) {
                            Tr.event((Object)this, (TraceComponent)tc, (String)"Failed to get the list of annotated classes.", (Object[])new Object[0]);
                        }
                        return null;
                    }
                }

                public void setConfiguration(OpenAPIConfiguration openAPIConfiguration) {
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.openapi.OpenAPIWebProvider$2", 2.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi.internal.resources.OpenAPIMessages");
                }
            };
        }
        if (this.openAPIScanner != null) {
            this.openAPIScanner.setConfiguration(this.openAPIConfiguration);
        }
    }

    private void processOpenAPI(OpenAPI openapi) {
        String contextRoot = this.getContextRoot();
        if (openapi == null || contextRoot == null || contextRoot.equals("/")) {
            return;
        }
        if (OpenAPIUtils.isContextRootNeeded(openapi, contextRoot)) {
            openapi.addServersItem(new Server().url(contextRoot));
        }
        if (this.nonDefaultHosts != null && !this.nonDefaultHosts.isEmpty()) {
            List servers = openapi.getServers();
            if (!OpenAPIUtils.isGlobalServerSpecified(openapi)) {
                for (String host : this.nonDefaultHosts) {
                    openapi.addServersItem(new Server().url(host));
                }
            } else {
                ArrayList<Server> newServers = new ArrayList<Server>();
                for (Server server : servers) {
                    String url = server.getUrl();
                    if (url == null || !url.startsWith("/")) continue;
                    for (int i = 0; i < this.nonDefaultHosts.size(); ++i) {
                        if (i == 0) {
                            server.setUrl(this.nonDefaultHosts.get(i) + url);
                            continue;
                        }
                        Server newServer = OpenAPIUtils.copyServer(server);
                        newServer.setUrl(this.nonDefaultHosts.get(i) + url);
                        newServers.add(newServer);
                    }
                }
                servers.addAll(newServers);
            }
        }
    }

    @Trivial
    public String toString() {
        StringBuilder sb = new StringBuilder("OpenAPIWebProvider={");
        if (this.moduleURL == null) {
            sb.append("moduleURL=null");
        } else {
            String contextRoot = this.getContextRoot();
            if (contextRoot != null) {
                sb.append("contextRoot=");
                sb.append(contextRoot);
            } else {
                sb.append("moduleURL=");
                sb.append(this.moduleURL);
            }
        }
        sb.append("}");
        return sb.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        PROPS.put("service.vendor", "IBM");
    }
}

