/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.openapi.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.annocache.AnnotationsBetaHelper;
import com.ibm.ws.container.service.annotations.WebAnnotations;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.openapi.internal.OpenAPIUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.anno.info.AnnotationInfo;
import com.ibm.wsspi.anno.info.ClassInfo;
import com.ibm.wsspi.anno.targets.AnnotationTargets_Targets;
import com.ibm.wsspi.webcontainer.metadata.WebModuleMetaData;
import com.ibm.wsspi.webcontainer.servlet.IServletConfig;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AnnotationScanner {
    private static final TraceComponent tc = Tr.register(AnnotationScanner.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi.internal.resources.OpenAPIMessages");
    private static final String JAX_RS_APPLICATION_CLASS_NAME = "javax.ws.rs.core.Application";
    private static final String JAX_RS_APPLICATION_INIT_PARAM = "javax.ws.rs.Application";
    private static final String JAX_RS_APP_PATH_ANNOTATION_CLASS_NAME = "javax.ws.rs.ApplicationPath";
    private static final String JAX_RS_PATH_ANNOTATION_CLASS_NAME = "javax.ws.rs.Path";
    private static final String OPENAPI_CALLBACK_ANNOTATION_CLASS_NAME = "io.swagger.oas.annotations.callbacks.Callback";
    private static final String OPENAPI_CONTACT_ANNOTATION_CLASS_NAME = "io.swagger.oas.annotations.info.Contact";
    private static final String OPENAPI_INFO_ANNOTATION_CLASS_NAME = "io.swagger.oas.annotations.info.Info";
    private static final String OPENAPI_LICENSE_ANNOTATION_CLASS_NAME = "io.swagger.oas.annotations.info.License";
    private static final String OPENAPI_LINK_ANNOTATION_CLASS_NAME = "io.swagger.oas.annotations.links.Link";
    private static final String OPENAPI_LINK_PAR_ANNOTATION_CLASS_NAME = "io.swagger.oas.annotations.links.LinkParameters";
    private static final String OPENAPI_ARRAY_SCHEMA_ANNOTATION_CLASS_NAME = "io.swagger.oas.annotations.media.ArraySchema";
    private static final String OPENAPI_SCHEMA_ANNOTATION_CLASS_NAME = "io.swagger.oas.annotations.media.Schema";
    private static final String OPENAPI_SECURITY_REQ_ANNOTATION_CLASS_NAME = "io.swagger.oas.annotations.security.SecurityRequirement";
    private static final String OPENAPI_SECURITY_SCHEME_ANNOTATION_CLASS_NAME = "io.swagger.oas.annotations.security.SecurityScheme";
    private static final String OPENAPI_TAGS_ANNOTATION_CLASS_NAME = "io.swagger.oas.annotations.tags.Tags";
    private static final String OPENAPI_DEFINITIONS_ANNOTATION_CLASS_NAME = "io.swagger.oas.annotations.OpenAPIDefinition";
    private static final List<String> ANNOTATION_CLASS_NAMES = Arrays.asList("javax.ws.rs.Path", "io.swagger.oas.annotations.callbacks.Callback", "io.swagger.oas.annotations.info.Contact", "io.swagger.oas.annotations.info.Info", "io.swagger.oas.annotations.info.License", "io.swagger.oas.annotations.links.Link", "io.swagger.oas.annotations.links.LinkParameters", "io.swagger.oas.annotations.media.ArraySchema", "io.swagger.oas.annotations.media.Schema", "io.swagger.oas.annotations.security.SecurityRequirement", "io.swagger.oas.annotations.security.SecurityScheme", "io.swagger.oas.annotations.tags.Tags", "io.swagger.oas.annotations.OpenAPIDefinition");
    private final ClassLoader webModuleClassLoader;
    private final WebAnnotations webAnnotations;
    private Set<Class<?>> annotatedClasses;
    private Set<Class<?>> scannedClasses;
    private String urlMapping;
    private final WebAppConfig appConfig;
    static final long serialVersionUID = 1731139460360693334L;

    public AnnotationScanner(ClassLoader classLoader, Container containerToAdapt) throws UnableToAdaptException {
        this.webModuleClassLoader = classLoader;
        this.webAnnotations = AnnotationsBetaHelper.getWebAnnotations((Container)containerToAdapt);
        this.appConfig = ((WebModuleMetaData)containerToAdapt.adapt(WebModuleMetaData.class)).getConfiguration();
    }

    /*
     * WARNING - void declaration
     */
    public boolean anyAnnotatedClasses() {
        try {
            return !this.getAnnotatedClasses().isEmpty();
        }
        catch (UnableToAdaptException unableToAdaptException) {
            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.openapi.internal.AnnotationScanner", (String)"90", (Object)this, (Object[])new Object[0]);
            if (OpenAPIUtils.isEventEnabled.test(tc)) {
                void u;
                Tr.event((TraceComponent)tc, (String)("Exception during annotation scanning: " + u.getMessage()), (Object[])new Object[0]);
            }
            return false;
        }
    }

    private String getUrlMappingFromServlet(IServletConfig sconfig) {
        if (sconfig.getMappings() != null && sconfig.getMappings().size() > 0) {
            String urlMapping = (String)sconfig.getMappings().get(0);
            if (!urlMapping.startsWith("/")) {
                urlMapping = "/" + urlMapping;
            }
            if (urlMapping.endsWith("/*")) {
                urlMapping = urlMapping.substring(0, urlMapping.length() - 2);
            }
            if (urlMapping.endsWith("/")) {
                urlMapping = urlMapping.substring(0, urlMapping.length() - 1);
            }
            if (OpenAPIUtils.isEventEnabled.test(tc)) {
                Tr.event((TraceComponent)tc, (String)("Found url mapping " + urlMapping + " in web.xml for " + sconfig.getServletName()), (Object[])new Object[0]);
            }
            return urlMapping;
        }
        return null;
    }

    private String getUrlMappingFromApp(String appName) throws UnableToAdaptException {
        AnnotationInfo aInf;
        ClassInfo cInf = this.webAnnotations.getClassInfo(appName);
        if (cInf != null && (aInf = cInf.getAnnotation(JAX_RS_APP_PATH_ANNOTATION_CLASS_NAME)) != null) {
            String annInfoVal = aInf.getValue("value").getStringValue();
            if (annInfoVal.isEmpty() || annInfoVal.equals("/")) {
                return "";
            }
            if (!annInfoVal.startsWith("/")) {
                annInfoVal = "/" + annInfoVal;
            }
            if (OpenAPIUtils.isEventEnabled.test(tc)) {
                Tr.event((TraceComponent)tc, (String)("Found url mapping " + annInfoVal + " in Application classs " + appName), (Object[])new Object[0]);
            }
            return annInfoVal;
        }
        return null;
    }

    private Set<String> getAllApplicationClasses() throws UnableToAdaptException {
        AnnotationTargets_Targets annotationTargets = this.webAnnotations.getAnnotationTargets();
        HashSet<String> applicationClasses = new HashSet<String>();
        applicationClasses.addAll(annotationTargets.getSubclassNames(JAX_RS_APPLICATION_CLASS_NAME));
        if (OpenAPIUtils.isEventEnabled.test(tc)) {
            Tr.event((TraceComponent)tc, (String)"Found application classes: ", (Object[])new Object[]{applicationClasses});
        }
        return applicationClasses;
    }

    private String getServletForDefaultApplication() {
        IServletConfig servletConfig = this.appConfig.getServletInfo(JAX_RS_APPLICATION_CLASS_NAME);
        if (servletConfig != null) {
            if (OpenAPIUtils.isEventEnabled.test(tc)) {
                Tr.event((TraceComponent)tc, (String)"Found servlet javax.ws.rs.core.Application", (Object[])new Object[0]);
            }
            return this.getUrlMappingFromServlet(servletConfig);
        }
        return null;
    }

    private String findServletMappingForApp(String appClassName) throws UnableToAdaptException {
        if (appClassName == null) {
            return null;
        }
        IServletConfig servletConfig = this.appConfig.getServletInfo(appClassName);
        if (servletConfig != null) {
            if (OpenAPIUtils.isEventEnabled.test(tc)) {
                Tr.event((TraceComponent)tc, (String)(appClassName + ": Found servlet " + servletConfig.getServletName() + " using servlet-name"), (Object[])new Object[0]);
            }
            return this.getUrlMappingFromServlet(servletConfig);
        }
        Iterator servletIterator = this.appConfig.getServletInfos();
        while (servletIterator.hasNext()) {
            servletConfig = (IServletConfig)servletIterator.next();
            String servletClass = servletConfig.getClassName();
            if (servletClass != null && servletClass.equals(appClassName)) {
                if (OpenAPIUtils.isEventEnabled.test(tc)) {
                    Tr.event((TraceComponent)tc, (String)(appClassName + ": Found servlet " + servletConfig.getServletName() + " using sevlet-class"), (Object[])new Object[0]);
                }
                return this.getUrlMappingFromServlet(servletConfig);
            }
            String initParam = servletConfig.getInitParameter(JAX_RS_APPLICATION_INIT_PARAM);
            if (initParam == null || !initParam.equals(appClassName)) continue;
            if (OpenAPIUtils.isEventEnabled.test(tc)) {
                Tr.event((TraceComponent)tc, (String)(appClassName + ": Found servlet " + servletConfig.getServletName() + " using init-param"), (Object[])new Object[0]);
            }
            return this.getUrlMappingFromServlet(servletConfig);
        }
        return this.getUrlMappingFromApp(appClassName);
    }

    /*
     * WARNING - void declaration
     */
    private synchronized Set<Class<?>> getAllAnnotatedClasses() throws UnableToAdaptException {
        if (this.annotatedClasses == null) {
            AnnotationTargets_Targets annotationTargets = this.webAnnotations.getAnnotationTargets();
            Set<Object> restAPIClasses = new HashSet();
            restAPIClasses = ANNOTATION_CLASS_NAMES.stream().flatMap(anno -> annotationTargets.getAnnotatedClasses(anno, AnnotationTargets_Targets.POLICY_SEED).stream()).collect(Collectors.toSet());
            if (OpenAPIUtils.isEventEnabled.test(tc)) {
                Tr.event((TraceComponent)tc, (String)"Found annotated classes: ", (Object[])new Object[]{restAPIClasses});
            }
            HashSet classes = new HashSet();
            for (String string : restAPIClasses) {
                try {
                    classes.add(this.webModuleClassLoader.loadClass(string));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    void e;
                    FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.openapi.internal.AnnotationScanner", (String)"233", (Object)this, (Object[])new Object[0]);
                    if (OpenAPIUtils.isEventEnabled.test(tc)) {
                        Tr.event((TraceComponent)tc, (String)("Failed to load class " + string + " returned from the annotation scanner."), (Object[])new Object[0]);
                    }
                    Tr.error((TraceComponent)tc, (String)"FAILED_FINDING_CLASS", (Object[])new Object[]{string, this.getClass().getName(), e.toString()});
                }
                catch (NoClassDefFoundError e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.openapi.internal.AnnotationScanner", (String)"238", (Object)this, (Object[])new Object[0]);
                    if (OpenAPIUtils.isEventEnabled.test(tc)) {
                        Tr.event((TraceComponent)tc, (String)("Failed to load class " + string + " returned from the annotation scanner."), (Object[])new Object[0]);
                    }
                    Tr.error((TraceComponent)tc, (String)"FAILED_FINDING_CLASS", (Object[])new Object[]{string, this.getClass().getName(), e.toString()});
                }
            }
            this.annotatedClasses = Collections.unmodifiableSet(classes);
        }
        return this.annotatedClasses;
    }

    public synchronized Set<Class<?>> getAnnotatedClasses() throws UnableToAdaptException {
        HashSet scanClasses = new HashSet();
        Set<Class<?>> annotated = this.getAllAnnotatedClasses();
        Set<String> appClassNames = this.getAllApplicationClasses();
        this.urlMapping = null;
        if (appClassNames.size() < 2) {
            String urlMapping = null;
            if (appClassNames.size() == 0) {
                if (OpenAPIUtils.isEventEnabled.test(tc)) {
                    Tr.event((TraceComponent)tc, (String)"Found no Application classes. Trying to find default app servlet", (Object[])new Object[0]);
                }
                urlMapping = this.getServletForDefaultApplication();
            }
            if (appClassNames.size() == 1) {
                if (OpenAPIUtils.isEventEnabled.test(tc)) {
                    Tr.event((TraceComponent)tc, (String)"Found one Application class. Trying to find url mapping", (Object[])new Object[0]);
                }
                urlMapping = this.findServletMappingForApp(appClassNames.iterator().next());
            }
            this.urlMapping = urlMapping;
            scanClasses.addAll(annotated);
        } else if (OpenAPIUtils.isEventEnabled.test(tc)) {
            Tr.event((TraceComponent)tc, (String)"Found multiple Application classes. This is not supported at this time.", (Object[])new Object[0]);
        }
        this.scannedClasses = Collections.unmodifiableSet(scanClasses);
        if (OpenAPIUtils.isEventEnabled.test(tc)) {
            Tr.event((TraceComponent)tc, (String)"Finished scanning for annotated classes", (Object[])new Object[0]);
        }
        return this.scannedClasses;
    }

    public String getURLMapping() {
        return this.urlMapping;
    }

    @FFDCIgnore(value={ClassNotFoundException.class})
    public boolean isThirdPartyAPIsAccessible() {
        try {
            this.webModuleClassLoader.loadClass(OPENAPI_INFO_ANNOTATION_CLASS_NAME);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

