/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.openapi.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.openapi.internal.CustomCSSWABUpdater;
import com.ibm.ws.openapi.internal.OpenAPIUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.MalformedLocationException;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.location.WsResource;
import io.swagger.oas.models.OpenAPI;
import io.swagger.oas.models.info.Info;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public final class CustomCSSProcessor {
    private static final TraceComponent tc = Tr.register(CustomCSSProcessor.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi.internal.resources.OpenAPIMessages");
    private static final String IBM_CSS_EXTENSION_KEY = "x-ibm-css";
    private static final String CUSTOM_CSS_SECTION_START = ".swagger-ui .headerbar ";
    private static final String CUSTOM_CSS_SECTION_END = "}";
    private final CustomCSSWABUpdater updater;
    private volatile String customCSSURL = null;
    private final ConcurrentLinkedQueue<CSSUpdate> cssUpdates = new ConcurrentLinkedQueue();
    static final long serialVersionUID = -8008938689054777477L;

    public CustomCSSProcessor() {
        this.updater = new CustomCSSWABUpdater();
    }

    @FFDCIgnore(value={IOException.class, SecurityException.class, MalformedLocationException.class, IllegalArgumentException.class})
    public void process(OpenAPI openAPI, WsLocationAdmin locationAdminProvider, ScheduledExecutorService executor) {
        String cssLocation = this.getCSSLocation(openAPI);
        if (cssLocation != null) {
            boolean cssProcessed;
            block15: {
                cssProcessed = false;
                try {
                    WsResource resource = locationAdminProvider.resolveResource(cssLocation);
                    String uri = resource.toExternalURI().toString();
                    if (!uri.equals(this.customCSSURL)) {
                        try {
                            this.customCSSURL = uri;
                            InputStream is = resource.get();
                            String content = this.getCSSSections(is);
                            if (content != null) {
                                HashMap<String, Object> cssData = new HashMap<String, Object>();
                                cssData.put("header-css-url", uri);
                                cssData.put("header-css-content", content);
                                CSSUpdate update = new CSSUpdate();
                                update.updateData = cssData;
                                this.cssUpdates.add(update);
                                cssProcessed = true;
                                break block15;
                            }
                            Tr.warning((TraceComponent)tc, (String)"CSS_SECTION_NOT_FOUND", (Object[])new Object[]{uri});
                        }
                        catch (IOException ioe) {
                            Tr.warning((TraceComponent)tc, (String)"CSS_NOT_PROCESSED", (Object[])new Object[]{uri, ioe.getClass().getName(), ioe.getMessage()});
                        }
                        catch (SecurityException se) {
                            Tr.warning((TraceComponent)tc, (String)"CSS_NOT_PROCESSED", (Object[])new Object[]{uri, se.getClass().getName(), se.getMessage()});
                        }
                        break block15;
                    }
                    if (OpenAPIUtils.isDebugEnabled.test(tc)) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("CSS location didn't change. Skip processing : customCSSURL=" + this.customCSSURL), (Object[])new Object[0]);
                    }
                    cssProcessed = true;
                }
                catch (MalformedLocationException mle) {
                    Tr.warning((TraceComponent)tc, (String)"CSS_NOT_PROCESSED", (Object[])new Object[]{cssLocation, ((Object)((Object)mle)).getClass().getName(), mle.getMessage()});
                }
                catch (IllegalArgumentException iae) {
                    Tr.warning((TraceComponent)tc, (String)"CSS_NOT_PROCESSED", (Object[])new Object[]{cssLocation, iae.getClass().getName(), iae.getMessage()});
                }
            }
            if (!cssProcessed) {
                if (OpenAPIUtils.isDebugEnabled.test(tc)) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"CSS was not processed - error occurred. So restore to default.", (Object[])new Object[0]);
                }
                this.cssUpdates.add(new CSSUpdate());
            }
        } else if (this.customCSSURL != null) {
            if (OpenAPIUtils.isDebugEnabled.test(tc)) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Restore to default and reset customCSSURL=" + this.customCSSURL), (Object[])new Object[0]);
            }
            this.cssUpdates.add(new CSSUpdate());
            this.customCSSURL = null;
        }
        this.processCSSUpdates(executor);
    }

    public void restoreDefaultAtStartup(ScheduledExecutorService executor) {
        if (OpenAPIUtils.isDebugEnabled.test(tc)) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("CustomCSSProcessor : restore to default at startup : executor=" + executor), (Object[])new Object[0]);
        }
        if (executor == null) {
            return;
        }
        this.cssUpdates.add(new CSSUpdate());
        this.processCSSUpdates(executor);
    }

    private void processCSSUpdates(ScheduledExecutorService executor) {
        if (this.cssUpdates.size() > 0) {
            final CustomCSSProcessor cssUpdator = this;
            Runnable bundleUpdater = new Runnable(){
                static final long serialVersionUID = 2239647437089744815L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    CustomCSSProcessor customCSSProcessor = cssUpdator;
                    synchronized (customCSSProcessor) {
                        Iterator it = CustomCSSProcessor.this.cssUpdates.iterator();
                        while (it.hasNext()) {
                            CSSUpdate update = (CSSUpdate)it.next();
                            if (update.updateData != null) {
                                CustomCSSProcessor.this.updater.update(update.updateData);
                            } else {
                                CustomCSSProcessor.this.updater.restoreDefaults();
                            }
                            it.remove();
                        }
                    }
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.openapi.internal.CustomCSSProcessor$1", 1.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi.internal.resources.OpenAPIMessages");
                }
            };
            executor.execute(bundleUpdater);
        }
    }

    private String getCSSLocation(OpenAPI openAPI) {
        Object cssObject;
        Map extensions;
        Info info;
        Info info2 = info = openAPI != null ? openAPI.getInfo() : null;
        if (info != null && (extensions = info.getExtensions()) != null && (cssObject = extensions.get(IBM_CSS_EXTENSION_KEY)) instanceof String) {
            return (String)cssObject;
        }
        return null;
    }

    private String getCSSSections(InputStream is) throws IOException {
        int endIndex;
        String content = this.getContent(is);
        StringBuilder cssSections = new StringBuilder();
        boolean foundCSSSection = false;
        int startIndex = content.indexOf(CUSTOM_CSS_SECTION_START, 0);
        while (startIndex != -1 && (endIndex = content.indexOf(CUSTOM_CSS_SECTION_END, startIndex)) != -1) {
            cssSections.append(content.substring(startIndex, endIndex + 1));
            foundCSSSection = true;
            startIndex = content.indexOf(CUSTOM_CSS_SECTION_START, endIndex + 1);
        }
        return foundCSSSection ? cssSections.toString() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getContent(InputStream is) throws IOException {
        try (Reader reader = null;){
            int c;
            reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            StringBuilder builder = new StringBuilder();
            while ((c = reader.read()) != -1) {
                builder.append((char)c);
            }
            String string = builder.toString();
            return string;
        }
    }

    public void serverStopping() {
        this.updater.serverStopping();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public class CSSUpdate {
        Map<String, Object> updateData;
        static final long serialVersionUID = -1312893110253514518L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.openapi.internal.CustomCSSProcessor$CSSUpdate", CSSUpdate.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi.internal.resources.OpenAPIMessages");
        }
    }
}

