/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.openapi.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.openapi.OpenAPIWebProvider;
import com.ibm.ws.openapi.internal.OpenAPIUtils;
import com.ibm.ws.openapi.internal.config.OpenAPIModuleConfigListener;
import com.ibm.ws.openapi.internal.config.OpenAPIWebModuleDoc;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.openapi.OASProvider;
import com.ibm.wsspi.openapi.OASProviderConfig;
import com.ibm.wsspi.openapi.OASProviderResult;
import io.swagger.oas.models.OpenAPI;
import io.swagger.parser.OpenAPIParser;
import io.swagger.parser.models.SwaggerParseResult;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class OASProviderWrapper {
    private static final TraceComponent tc = Tr.register(OASProviderWrapper.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi.internal.resources.OpenAPIMessages");
    private static final String IBM_PRIVATE_EXTENSION_NAME = "x-ibm-private";
    private boolean processed;
    private boolean isValid = true;
    private final OASProvider provider;
    private final boolean isWebProvider;
    private final Map<OASProviderConfig, OpenAPI> openAPIByConfig = new HashMap<OASProviderConfig, OpenAPI>();
    private final Set<String> jsonPathKeys = new HashSet<String>();
    private Future<Boolean> future;
    private OASProviderConfig defaultConfig;
    private final AtomicReference<ComponentContext> context;
    static final long serialVersionUID = -5637837060401067395L;

    public OASProviderWrapper(AtomicReference<ComponentContext> context, OASProvider provider) {
        this.context = context;
        this.provider = provider;
        this.isWebProvider = provider instanceof OpenAPIWebProvider;
    }

    public OASProvider getOpenAPIProvider() {
        return this.provider;
    }

    public String getContextRoot() {
        return this.provider.getContextRoot();
    }

    public boolean isWebProvider() {
        return this.isWebProvider;
    }

    public Future<Boolean> getFuture() {
        return this.future;
    }

    public void setFuture(Future<Boolean> future) {
        this.future = future;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setValidity(boolean isValid) {
        this.isValid = isValid;
    }

    public synchronized OpenAPI getOpenAPI() {
        return this.getOpenAPI(null);
    }

    public synchronized OpenAPI getOpenAPI(OASProviderConfig config) {
        if (!this.processed) {
            if (OpenAPIUtils.isDebugEnabled.test(tc)) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Started processing the provider: " + this.provider), (Object[])new Object[0]);
            }
            this.processResults();
            if (OpenAPIUtils.isDebugEnabled.test(tc)) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Finished processing the provider: " + this.provider), (Object[])new Object[0]);
            }
            this.processed = true;
        }
        if (config == null) {
            config = this.defaultConfig;
        }
        return this.openAPIByConfig.get(config);
    }

    private void processResults() {
        List results = this.provider.getResults();
        if (OpenAPIUtils.isDebugEnabled.test(tc)) {
            String rString = results == null ? "null" : OpenAPIUtils.stringify(results);
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Results provided by the provider " + this.provider + " : " + rString), (Object[])new Object[0]);
        }
        if (results == null || results.isEmpty()) {
            return;
        }
        OASProviderConfig dconfig = ((OASProviderResult)results.get(0)).getOASProviderConfig();
        this.defaultConfig = dconfig != null ? dconfig : OASProviderConfig.defaultConfig();
        results.stream().filter(Objects::nonNull).forEach(r -> {
            OASProviderConfig config = r.getOASProviderConfig() == null ? OASProviderConfig.defaultConfig() : r.getOASProviderConfig();
            OpenAPI openAPI = r.getOpenAPI();
            String document = r.getDocument();
            if (openAPI == null && document != null) {
                openAPI = this.createOpenAPI(document);
            }
            if (openAPI == null) {
                if (OpenAPIUtils.isEventEnabled.test(tc)) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)("Retrieved Open API object is null for the provider " + this.provider + "\n config: " + OpenAPIUtils.stringify(config) + " \n document:" + document), (Object[])new Object[0]);
                }
                Tr.warning((TraceComponent)tc, (String)"OPENAPI_IS_NULL", (Object[])new Object[]{this.provider});
            }
            this.openAPIByConfig.put(config, openAPI);
        });
    }

    private OpenAPI createOpenAPI(String document) {
        SwaggerParseResult parseResult = new OpenAPIParser().readContents(document, null, null);
        OpenAPI openAPI = null;
        if (parseResult != null) {
            openAPI = parseResult.getOpenAPI();
            if (parseResult.getMessages() != null && OpenAPIUtils.isEventEnabled.test(tc)) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("Error messages while parsing: " + String.join((CharSequence)", ", parseResult.getMessages())), (Object[])new Object[0]);
            }
        } else if (OpenAPIUtils.isEventEnabled.test(tc)) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("Failed to read the document: " + document), (Object[])new Object[0]);
        }
        return openAPI;
    }

    public Set<String> getJsonPathKeys() {
        return this.jsonPathKeys;
    }

    public boolean isPublic() {
        Map exts;
        String contextRoot = this.getOpenAPIProvider().getContextRoot();
        OpenAPIWebModuleDoc configElement = this.getConfigElement(contextRoot);
        if (configElement != null) {
            if (OpenAPIUtils.isEventEnabled.test(tc)) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("oasproviderwrapper.ispublic configElement=" + configElement), (Object[])new Object[0]);
            }
            return configElement.isPublic();
        }
        OpenAPI model = this.getOpenAPI();
        if (model != null && (exts = model.getExtensions()) != null) {
            Object o;
            if (OpenAPIUtils.isEventEnabled.test(tc)) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("oasproviderwrapper.ispublic extensions=" + exts), (Object[])new Object[0]);
            }
            if ((o = exts.get(IBM_PRIVATE_EXTENSION_NAME)) instanceof Boolean) {
                Boolean isPrivate = (Boolean)o;
                return isPrivate == false;
            }
        }
        if (OpenAPIUtils.isEventEnabled.test(tc)) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("oasproviderwrapper.ispublic configElement=null, no extension, getOpenAPIProvider().isPublic()=" + this.getOpenAPIProvider().isPublic()), (Object[])new Object[0]);
        }
        return this.getOpenAPIProvider().isPublic();
    }

    private OpenAPIWebModuleDoc getConfigElement(String contextRoot) {
        Map<String, OpenAPIWebModuleDoc> config = this.getWebModuleConfig();
        if (config == null) {
            return null;
        }
        return config.get(contextRoot);
    }

    private Map<String, OpenAPIWebModuleDoc> getWebModuleConfig() {
        OpenAPIModuleConfigListener oasConfig = this.getOASModuleConfig();
        if (oasConfig == null) {
            return null;
        }
        return oasConfig.getWebModuleConfig();
    }

    private OpenAPIModuleConfigListener getOASModuleConfig() {
        ServiceReference sr = this.context.get().getBundleContext().getServiceReference(OpenAPIModuleConfigListener.class);
        OpenAPIModuleConfigListener openAPIModuleConfigListener = null;
        if (sr != null) {
            openAPIModuleConfigListener = (OpenAPIModuleConfigListener)this.context.get().getBundleContext().getService(sr);
        }
        if (openAPIModuleConfigListener == null && OpenAPIUtils.isEventEnabled.test(tc)) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"Couldn't find openapi.webModuleDoc service", (Object[])new Object[0]);
        }
        return openAPIModuleConfigListener;
    }
}

