/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.openapi.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.openapi.OASProviderConfig;
import io.swagger.oas.models.OpenAPI;
import io.swagger.oas.models.PathItem;
import io.swagger.oas.models.Paths;
import io.swagger.oas.models.info.Info;
import io.swagger.oas.models.servers.Server;
import io.swagger.parser.OpenAPIParser;
import io.swagger.parser.models.SwaggerParseResult;
import io.swagger.util.ObjectMapperFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class OpenAPIUtils {
    private static final TraceComponent tc = Tr.register(OpenAPIUtils.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi.internal.resources.OpenAPIMessages");
    private static final String OA_INFO_TITLE = "Liberty REST APIs";
    private static final String OA_INFO_DESCRIPTION = "Discover REST APIs available within Liberty";
    private static final String OA_INFO_VERSION = "1.0.0";
    public static final Predicate<TraceComponent> isDebugEnabled = tc -> TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
    public static final Predicate<TraceComponent> isEventEnabled = tc -> TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled();
    public static final Predicate<TraceComponent> isDumpEnabled = tc -> TraceComponent.isAnyTracingEnabled() && tc.isDumpEnabled();
    static final long serialVersionUID = -8389473866475916292L;

    @FFDCIgnore(value={IOException.class})
    public static String getAPIDocFromStream(InputStream is) {
        try {
            String string = IOUtils.toString((InputStream)is, (String)"UTF-8");
            return string;
        }
        catch (IOException ioe) {
            if (isEventEnabled.test(tc)) {
                Tr.event((TraceComponent)tc, (String)("Exception when reading: " + ioe.getMessage()), (Object[])new Object[0]);
            }
        }
        finally {
            block13: {
                try {
                    is.close();
                }
                catch (IOException ioe) {
                    if (!isEventEnabled.test(tc)) break block13;
                    Tr.event((TraceComponent)tc, (String)("Exception when closing: " + ioe.getMessage()), (Object[])new Object[0]);
                }
            }
        }
        return null;
    }

    @FFDCIgnore(value={IOException.class})
    public static String getAPIDocFromFile(File file) {
        try {
            return FileUtils.readFileToString((File)file, (String)"UTF-8");
        }
        catch (IOException ioe) {
            if (isEventEnabled.test(tc)) {
                Tr.event((TraceComponent)tc, (String)("Exception when reading: " + ioe.getMessage()), (Object[])new Object[0]);
            }
            return null;
        }
    }

    @FFDCIgnore(value={MalformedURLException.class, IOException.class})
    public static String getAPIDocumentFromURL(String url) {
        try {
            URL urlDoc = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)urlDoc.openConnection();
            connection.setRequestMethod("GET");
            String acceptValue = url.endsWith("json") ? "application/json" : "application/yaml";
            connection.setRequestProperty("Accept", acceptValue);
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                return OpenAPIUtils.getAPIDocFromStream(connection.getInputStream());
            }
            if (isEventEnabled.test(tc)) {
                Tr.event((TraceComponent)tc, (String)("Did not find document in " + url + ".  ResponseCode: " + responseCode), (Object[])new Object[0]);
            }
        }
        catch (MalformedURLException mfe) {
            if (isEventEnabled.test(tc)) {
                Tr.event((TraceComponent)tc, (String)("Exception: " + mfe.getMessage()), (Object[])new Object[0]);
            }
            return null;
        }
        catch (IOException ioe) {
            if (isEventEnabled.test(tc)) {
                Tr.event((TraceComponent)tc, (String)("Exception: " + ioe.getMessage()), (Object[])new Object[0]);
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static OpenAPI parseOpenAPI(String openapi) {
        block4: {
            if (openapi == null) {
                return null;
            }
            try {
                SwaggerParseResult parseResult = new OpenAPIParser().readContents(openapi, null, null);
                if (parseResult != null) {
                    return parseResult.getOpenAPI();
                }
            }
            catch (Exception parseResult) {
                void se;
                FFDCFilter.processException((Throwable)parseResult, (String)"com.ibm.ws.openapi.internal.OpenAPIUtils", (String)"130", null, (Object[])new Object[]{openapi});
                if (!isEventEnabled.test(tc)) break block4;
                Tr.event((TraceComponent)tc, (String)("Exception occurred while trying to read document : \n exception=" + se), (Object[])new Object[0]);
            }
        }
        return null;
    }

    public static String normalizeContextRoot(String contextRoot) {
        if (contextRoot != null && !contextRoot.trim().isEmpty()) {
            if ("/*".equals(contextRoot)) {
                contextRoot = "/";
            } else if (contextRoot.endsWith("/*")) {
                contextRoot = contextRoot.substring(0, contextRoot.length() - 2);
            } else if (contextRoot.endsWith("/")) {
                contextRoot = contextRoot.substring(0, contextRoot.length() - 1);
            }
        }
        return contextRoot;
    }

    public static String getOsgiServiceErrorMessage(Class<?> aClass, String serviceName) {
        return TraceNLS.getFormattedMessage(aClass, (String)"com.ibm.ws.openapi.internal.resources.OpenAPIMessages", (String)"OSGI_SERVICE_ERROR", (Object[])new Object[]{serviceName}, (String)"CWWKO1600E: The {0} OSGi service is not available.");
    }

    public static boolean isContextRootNeeded(OpenAPI openapi, String contextRoot) {
        if (OpenAPIUtils.isGlobalServerSpecified(openapi)) {
            return false;
        }
        Paths paths = openapi.getPaths();
        if (paths != null && !paths.isEmpty()) {
            String path = (String)paths.keySet().iterator().next();
            List pathServers = ((PathItem)paths.get((Object)path)).getServers();
            if (!path.startsWith(contextRoot) && (pathServers == null || pathServers.isEmpty())) {
                return true;
            }
        }
        return false;
    }

    public static boolean isGlobalServerSpecified(OpenAPI openapi) {
        return openapi.getServers() != null && !openapi.getServers().isEmpty();
    }

    public static Server copyServer(Server server) {
        Server s = new Server();
        s.setDescription(server.getDescription());
        s.setExtensions(server.getExtensions());
        s.setVariables(server.getVariables());
        s.setUrl(server.getUrl());
        return s;
    }

    public static boolean isNullOrWhitespace(String value) {
        if (value == null) {
            return true;
        }
        for (int i = 0; i < value.length(); ++i) {
            if (Character.isWhitespace(value.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static OpenAPI createDefaultOpenAPI() {
        return new OpenAPI().info(new Info().title(OA_INFO_TITLE).description(OA_INFO_DESCRIPTION).version(OA_INFO_VERSION)).servers(Collections.emptyList());
    }

    public static Info ensureValidInfo(Info info) {
        if (info == null) {
            info = new Info();
        }
        if (info.getTitle() == null || info.getTitle().isEmpty()) {
            info.setTitle(OA_INFO_TITLE);
        }
        if (info.getVersion() == null || info.getVersion().isEmpty()) {
            info.setVersion(OA_INFO_VERSION);
        }
        return info;
    }

    public static String getCompactYamlDocument(OpenAPI openAPI) {
        return OpenAPIUtils.handleSerializingException(o -> ObjectMapperFactory.createYaml().writeValueAsString(o), openAPI);
    }

    public static String getPrettyYamlDocument(OpenAPI openAPI) {
        return OpenAPIUtils.handleSerializingException(o -> ObjectMapperFactory.createYaml().writer((PrettyPrinter)new DefaultPrettyPrinter()).writeValueAsString(o), openAPI);
    }

    public static String getCompactJsonDocument(OpenAPI openAPI) {
        return OpenAPIUtils.handleSerializingException(o -> ObjectMapperFactory.createJson().writeValueAsString(o), openAPI);
    }

    public static String getPrettyJsonDocument(OpenAPI openAPI) {
        return OpenAPIUtils.handleSerializingException(o -> ObjectMapperFactory.createJson().writer((PrettyPrinter)new DefaultPrettyPrinter()).writeValueAsString(o), openAPI);
    }

    public static String stringify(List<?> list) {
        return list == null ? "null" : list.stream().map(i -> i == null ? "null" : i.toString()).collect(Collectors.joining(", ", "[", "]"));
    }

    public static String stringify(OASProviderConfig config) {
        return "[" + config.getLanguage() + "]";
    }

    /*
     * WARNING - void declaration
     */
    private static String handleSerializingException(FunctionWithExceptions<OpenAPI, String, JsonProcessingException> func, OpenAPI openAPI) {
        String doc;
        block2: {
            doc = null;
            try {
                doc = func.apply(openAPI);
            }
            catch (JsonProcessingException jsonProcessingException) {
                void e;
                FFDCFilter.processException((Throwable)jsonProcessingException, (String)"com.ibm.ws.openapi.internal.OpenAPIUtils", (String)"256", null, (Object[])new Object[]{func, openAPI});
                if (!isEventEnabled.test(tc)) break block2;
                Tr.event((TraceComponent)tc, (String)("Exception occurred while trying to convert OpenAPI object to String. \n exception: " + e), (Object[])new Object[0]);
            }
        }
        return doc;
    }

    public static void copyOpenAPIObjectExtensions(OpenAPI copyFrom, OpenAPI copyTo) {
        if (copyFrom == null || copyTo == null) {
            return;
        }
        Map extensionsToCopy = copyFrom.getExtensions();
        if (extensionsToCopy != null) {
            for (String key : extensionsToCopy.keySet()) {
                copyTo.addExtension(key, extensionsToCopy.get(key));
            }
        }
    }

    public static InputStream getUrlAsStream(URL url, String acceptValue) throws IOException {
        int responseCode;
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        if (acceptValue != null && !acceptValue.trim().isEmpty()) {
            connection.setRequestProperty("Accept", acceptValue);
        }
        if ((responseCode = connection.getResponseCode()) == 200) {
            return connection.getInputStream();
        }
        if (isDebugEnabled.test(tc)) {
            Tr.debug((TraceComponent)tc, (String)("Did not find resource at " + url + ".  ResponseCode: " + responseCode), (Object[])new Object[0]);
        }
        return null;
    }

    @FunctionalInterface
    public static interface FunctionWithExceptions<T, R, E extends Exception> {
        public R apply(T var1) throws E;
    }
}

