/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.openapi.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.openapi.internal.OpenAPIUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.swagger.oas.models.OpenAPI;
import io.swagger.oas.models.servers.Server;
import java.util.ArrayList;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ServerInfo
implements Cloneable {
    private static final TraceComponent tc = Tr.register(ServerInfo.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi.internal.resources.OpenAPIMessages");
    private int httpPort = -1;
    private int httpsPort = -1;
    private String host;
    private String customHttpUrl = null;
    private String customHttpsUrl = null;
    private String proxyPath = null;
    static final long serialVersionUID = 6900286354626395157L;

    public ServerInfo(String host, int httpPort, int httpsPort) {
        this.host = host;
        this.httpPort = httpPort;
        this.httpsPort = httpsPort;
    }

    public ServerInfo(ServerInfo serverInfo) {
        this.host = serverInfo.host;
        this.httpPort = serverInfo.httpPort;
        this.httpsPort = serverInfo.httpsPort;
        this.customHttpUrl = serverInfo.customHttpUrl;
        this.customHttpsUrl = serverInfo.customHttpsUrl;
        this.proxyPath = serverInfo.proxyPath;
    }

    public String getCustomHttpsUrl() {
        return this.customHttpsUrl;
    }

    public void setCustomHttpsUrl(String customHttpsUrl) {
        this.customHttpsUrl = customHttpsUrl;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    public void setHttpsPort(int httpsPort) {
        this.httpsPort = httpsPort;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getHTTPServerURL() {
        if (this.proxyPath == null || this.proxyPath.isEmpty()) {
            return this.httpPort < 1 ? null : "http://" + this.host + ":" + this.httpPort;
        }
        return this.httpPort < 1 ? null : "http://" + this.host + ":" + this.httpPort + this.proxyPath;
    }

    public String getHTTPSServerURL() {
        if (this.proxyPath == null || this.proxyPath.isEmpty()) {
            return this.httpsPort < 1 ? null : "https://" + this.host + ":" + this.httpsPort;
        }
        return this.httpsPort < 1 ? null : "https://" + this.host + ":" + this.httpsPort + this.proxyPath;
    }

    public String getCustomHttpUrl() {
        return this.customHttpUrl;
    }

    public void setCustomHttpUrl(String customHttpUrl) {
        this.customHttpUrl = customHttpUrl;
    }

    public void updateServers(OpenAPI openAPI) {
        String serversString;
        if (OpenAPIUtils.isDebugEnabled.test(tc)) {
            serversString = OpenAPIUtils.stringify(openAPI.getServers());
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Updating the servers list. Old value: \n" + serversString), (Object[])new Object[0]);
        }
        openAPI.setServers(new ArrayList());
        if (this.customHttpUrl != null) {
            openAPI.addServersItem(new Server().url(this.customHttpUrl));
        } else if (this.getHTTPServerURL() != null) {
            openAPI.addServersItem(new Server().url(this.getHTTPServerURL()));
        }
        if (this.getCustomHttpsUrl() != null) {
            openAPI.addServersItem(new Server().url(this.customHttpsUrl));
        } else if (this.getHTTPSServerURL() != null) {
            openAPI.addServersItem(new Server().url(this.getHTTPSServerURL()));
        }
        if (OpenAPIUtils.isDebugEnabled.test(tc)) {
            serversString = OpenAPIUtils.stringify(openAPI.getServers());
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Updated the servers list. New value: \n" + serversString), (Object[])new Object[0]);
        }
    }

    public String toString() {
        return "ServerInfo [host=" + this.host + ", httpPort=" + this.httpPort + ", httpsPort=" + this.httpsPort + ", customHttpUrl=" + this.customHttpUrl + ", customHttpsUrl=" + this.customHttpsUrl + ", proxyPath=" + this.proxyPath + "]";
    }

    public Object clone() throws CloneNotSupportedException {
        super.clone();
        return new ServerInfo(this);
    }

    public String getProxyPath() {
        return this.proxyPath;
    }

    public void setProxyPath(String proxyPath) {
        this.proxyPath = proxyPath;
    }
}

