/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.openapi.internal.bootstrapping;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.openapi.internal.OpenAPIUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.swagger.oas.integration.OpenAPIConfiguration;
import io.swagger.oas.integration.OpenAPIReader;
import io.swagger.oas.integration.OpenAPIScanner;
import io.swagger.oas.models.OpenAPI;
import io.swagger.oas.models.Paths;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class BootstrappingHelper {
    private static final TraceComponent tc = Tr.register(BootstrappingHelper.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi.internal.resources.OpenAPIMessages");
    private final ClassLoader classLoader;
    private final String urlMapping;
    static final long serialVersionUID = 1069240754766499287L;

    public BootstrappingHelper(ClassLoader classLoader, String urlMapping) {
        this.classLoader = classLoader;
        this.urlMapping = urlMapping;
    }

    public synchronized OpenAPI getOpenAPI(OpenAPIConfiguration configuration, OpenAPIReader reader, OpenAPIScanner scanner) {
        if (configuration != null) {
            if (Boolean.TRUE.equals(configuration.isScanningDisabled())) {
                return configuration.getOpenAPI();
            }
            if (reader == null) {
                Tr.debug((TraceComponent)tc, (String)"Did not find an implementation of OpenAPIReader, but scanning was enabled", (Object[])new Object[0]);
                return null;
            }
            if (Boolean.TRUE.equals(configuration.isReadAllResources())) {
                return this.getOpenAPI(reader, scanner.getClasses(), scanner.getResources());
            }
            if (configuration.getResourcePackages() != null || configuration.getResourceClasses() != null) {
                HashSet acceptableClasses = new HashSet();
                if (scanner.getClasses() != null && !scanner.getClasses().isEmpty()) {
                    if (configuration.getResourceClasses() != null) {
                        acceptableClasses.addAll(scanner.getClasses().stream().filter(c -> configuration.getResourceClasses().contains(c.getName())).collect(Collectors.toSet()));
                    }
                    if (configuration.getResourcePackages() != null) {
                        for (String pkg : configuration.getResourcePackages()) {
                            if (pkg.isEmpty()) continue;
                            for (Class cls : scanner.getClasses()) {
                                if (!cls.getName().startsWith(pkg)) continue;
                                acceptableClasses.add(cls);
                            }
                        }
                    }
                }
                return this.getOpenAPI(reader, acceptableClasses, scanner.getResources());
            }
        }
        return this.getOpenAPI(reader, scanner.getClasses(), scanner.getResources());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OpenAPI getOpenAPI(OpenAPIReader reader, Set<Class<?>> classes, Map<String, Object> resources) {
        AtomicReference<ClassLoader> classLoaderRef = BootstrappingHelper.getContextClassLoader();
        try {
            if (classLoaderRef != null) {
                BootstrappingHelper.setContextClassLoader(this.classLoader);
            } else if (OpenAPIUtils.isEventEnabled.test(tc)) {
                Tr.event((TraceComponent)tc, (String)"The current thread's context ClassLoader cannot be set to the web module's ClassLoader.", (Object[])new Object[0]);
            }
            OpenAPI openAPI = reader.read(classes, resources);
            if (openAPI != null && this.urlMapping != null) {
                Paths oldPaths;
                if (OpenAPIUtils.isEventEnabled.test(tc)) {
                    Tr.event((TraceComponent)tc, (String)("Appending URL mapping to all the paths: " + this.urlMapping), (Object[])new Object[0]);
                }
                if ((oldPaths = openAPI.getPaths()) != null && !oldPaths.isEmpty()) {
                    Paths paths = new Paths();
                    paths.setExtensions(oldPaths.getExtensions());
                    oldPaths.forEach((path, pathItem) -> paths.addPathItem(this.urlMapping + path, pathItem));
                    openAPI.setPaths(paths);
                }
            }
            OpenAPI openAPI2 = openAPI;
            return openAPI2;
        }
        finally {
            if (classLoaderRef != null) {
                BootstrappingHelper.setContextClassLoader(classLoaderRef.get());
            }
        }
    }

    private static AtomicReference<ClassLoader> getContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<AtomicReference<ClassLoader>>(){
            static final long serialVersionUID = 2521028290573624925L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public AtomicReference<ClassLoader> run() {
                try {
                    return new AtomicReference<ClassLoader>(Thread.currentThread().getContextClassLoader());
                }
                catch (SecurityException securityException) {
                    FFDCFilter.processException((Throwable)securityException, (String)"com.ibm.ws.openapi.internal.bootstrapping.BootstrappingHelper$1", (String)"126", (Object)this, (Object[])new Object[0]);
                    return null;
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.openapi.internal.bootstrapping.BootstrappingHelper$1", 1.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi.internal.resources.OpenAPIMessages");
            }
        });
    }

    private static void setContextClassLoader(final ClassLoader cl) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){
            static final long serialVersionUID = 606302802852192379L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Void run() {
                try {
                    Thread.currentThread().setContextClassLoader(cl);
                }
                catch (SecurityException securityException) {
                    FFDCFilter.processException((Throwable)securityException, (String)"com.ibm.ws.openapi.internal.bootstrapping.BootstrappingHelper$2", (String)"139", (Object)this, (Object[])new Object[0]);
                }
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.openapi.internal.bootstrapping.BootstrappingHelper$2", 2.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi.internal.resources.OpenAPIMessages");
            }
        });
    }
}

