/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.openapi.internal.bootstrapping;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.openapi.internal.bootstrapping.OpenAPIServiceLoader;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.swagger.oas.integration.OpenAPIConfiguration;
import io.swagger.util.Json;
import io.swagger.util.Yaml;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public final class OpenAPIConfigurationClasspathLoader
implements OpenAPIServiceLoader<OpenAPIConfiguration> {
    private final List<String> classpathFiles = Arrays.asList("openapi-configuration.yaml", "openapi-configuration.json", "openapi-configuration.yml");
    static final long serialVersionUID = 4670278943988269555L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Override
    public OpenAPIConfiguration load(ClassLoader cl, String moduleName) {
        String configurationAsString = null;
        for (String fileName : this.classpathFiles) {
            try {
                URL resource = this.getClass().getResource(fileName);
                if (resource == null || (configurationAsString = this.readInputStreamToString(resource.openStream())) == null || configurationAsString.trim().isEmpty()) continue;
                return this.deserializeConfiguration(fileName, configurationAsString);
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.openapi.internal.bootstrapping.OpenAPIConfigurationClasspathLoader", (String)"53", (Object)this, (Object[])new Object[]{cl, moduleName});
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={IOException.class})
    private String readInputStreamToString(InputStream stream) {
        StringBuffer sb = new StringBuffer();
        BufferedReader in = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
        try {
            String inputLine;
            while ((inputLine = in.readLine()) != null) {
                sb.append(inputLine).append("\n");
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        return sb.toString();
    }

    private OpenAPIConfiguration deserializeConfiguration(String path, String configurationAsString) {
        try {
            if (path.toLowerCase().endsWith("json")) {
                return (OpenAPIConfiguration)Json.mapper().readValue(configurationAsString, OpenAPIConfiguration.class);
            }
            return (OpenAPIConfiguration)Yaml.mapper().readValue(configurationAsString, OpenAPIConfiguration.class);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.openapi.internal.bootstrapping.OpenAPIConfigurationClasspathLoader", (String)"91", (Object)this, (Object[])new Object[]{path, configurationAsString});
            return null;
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.openapi.internal.bootstrapping.OpenAPIConfigurationClasspathLoader", OpenAPIConfigurationClasspathLoader.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi.internal.resources.OpenAPIMessages");
    }
}

