/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.openapi.internal.bootstrapping;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.openapi.internal.OpenAPIUtils;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

public interface OpenAPIServiceLoader<T> {
    public static final TraceComponent tc = Tr.register(OpenAPIServiceLoader.class);

    public T load(ClassLoader var1, String var2);

    @FFDCIgnore(value={RuntimeException.class, ServiceConfigurationError.class, NoClassDefFoundError.class})
    default public T loadOpenAPIService(ClassLoader cl, Class<T> clazz, String moduleName) {
        try {
            ServiceLoader<T> serviceLoader = ServiceLoader.load(clazz, cl);
            Iterator<T> providers = serviceLoader.iterator();
            if (providers.hasNext()) {
                return providers.next();
            }
        }
        catch (NoClassDefFoundError e) {
            if (OpenAPIUtils.isEventEnabled.test(tc)) {
                Tr.event((TraceComponent)tc, (String)("Error loading OpenAPI service " + clazz.getName() + "for " + moduleName + " due to " + e.toString()), (Object[])new Object[0]);
            }
            Tr.error((TraceComponent)tc, (String)"FAILED_FINDING_CLASS", (Object[])new Object[]{clazz.getSimpleName(), moduleName, e.toString()});
            return null;
        }
        catch (Throwable e) {
            if (OpenAPIUtils.isEventEnabled.test(tc)) {
                Tr.event((TraceComponent)tc, (String)("Error loading OpenAPI service " + clazz.getName() + "for " + moduleName + " due to " + e), (Object[])new Object[0]);
            }
            Tr.error((TraceComponent)tc, (String)"FAILED_LOADING_SERVICE", (Object[])new Object[]{clazz.getSimpleName(), moduleName, e.toString()});
            return null;
        }
        return null;
    }
}

