/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.openapi.internal.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.openapi.internal.OpenAPIUtils;
import com.ibm.ws.openapi.internal.config.OpenAPIWebModuleDocListener;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={OpenAPIWebModuleDoc.class}, configurationPid={"com.ibm.ws.openapi.webModuleDoc"}, configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true, property={"service.vendor=IBM"})
public class OpenAPIWebModuleDoc {
    private static final TraceComponent tc = Tr.register(OpenAPIWebModuleDoc.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi.internal.resources.OpenAPIMessages");
    private static Set<OpenAPIWebModuleDocListener> listeners = new HashSet<OpenAPIWebModuleDocListener>();
    private static final String CONFIG_CONTEXT_ROOT = "contextRoot";
    private static final String CONFIG_ENABLED = "enabled";
    private static final String CONFIG_PUBLIC = "public";
    private String contextRoot;
    private boolean enabled;
    private boolean isPublic;
    static final long serialVersionUID = 247035877679123418L;

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> properties) {
        if (OpenAPIUtils.isDebugEnabled.test(tc)) {
            Tr.debug((TraceComponent)tc, (String)"Activate webModuleDoc configuration", (Object[])new Object[0]);
        }
        this.processWebModuleDoc(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Modified
    protected void modified(Map<String, Object> properties) throws IOException {
        String oldContextRoot = this.contextRoot;
        this.processWebModuleDoc(properties);
        Set<OpenAPIWebModuleDocListener> set = listeners;
        synchronized (set) {
            for (OpenAPIWebModuleDocListener listener : listeners) {
                listener.modifyOpenAPIWebModuleDoc(this, oldContextRoot);
            }
        }
    }

    private void processWebModuleDoc(Map<String, Object> properties) {
        if (OpenAPIUtils.isDebugEnabled.test(tc)) {
            Tr.debug((TraceComponent)tc, (String)("Process webModuleDoc properties=" + properties), (Object[])new Object[0]);
        }
        this.contextRoot = (String)properties.get(CONFIG_CONTEXT_ROOT);
        this.enabled = (Boolean)properties.get(CONFIG_ENABLED);
        this.isPublic = (Boolean)properties.get(CONFIG_PUBLIC);
    }

    @Deactivate
    protected void deactivate(ComponentContext context, int reason) {
        if (OpenAPIUtils.isDebugEnabled.test(tc)) {
            Tr.debug((TraceComponent)tc, (String)"Deactivate webModuleDoc configuration", (Object[])new Object[0]);
        }
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addListener(OpenAPIWebModuleDocListener newListener) {
        Set<OpenAPIWebModuleDocListener> set = listeners;
        synchronized (set) {
            return listeners.add(newListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeListener(OpenAPIWebModuleDocListener newListener) {
        Set<OpenAPIWebModuleDocListener> set = listeners;
        synchronized (set) {
            return listeners.remove(newListener);
        }
    }

    @Trivial
    public String toString() {
        StringBuilder sb = new StringBuilder("OpenAPIWebModuleDoc={");
        sb.append("contextRoot=").append(this.contextRoot);
        sb.append(", enabled=").append(this.enabled);
        sb.append(", public=").append(this.isPublic);
        sb.append("}");
        return sb.toString();
    }
}

