/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.openapi.internal.module;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.app.deploy.WebModuleInfo;
import com.ibm.ws.container.service.metadata.MetaDataEvent;
import com.ibm.ws.container.service.metadata.MetaDataException;
import com.ibm.ws.container.service.metadata.ModuleMetaDataListener;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.openapi.OpenAPIWebProvider;
import com.ibm.ws.openapi.internal.OpenAPIUtils;
import com.ibm.ws.openapi.internal.config.OpenAPIWebModuleDoc;
import com.ibm.ws.openapi.internal.config.OpenAPIWebModuleDocListener;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.adaptable.module.adapters.ContainerAdapter;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.overlay.OverlayContainer;
import com.ibm.wsspi.http.VirtualHost;
import com.ibm.wsspi.http.VirtualHostListener;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.webcontainer.metadata.WebModuleMetaData;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.osgi.framework.Bundle;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={ModuleMetaDataListener.class, ContainerAdapter.class, VirtualHostListener.class}, immediate=true, property={"service.vendor=IBM", "toType=com.ibm.ws.openapi.OpenAPIWebProvider"})
public class OpenAPIModuleListener
implements ModuleMetaDataListener,
ContainerAdapter<OpenAPIWebProvider>,
VirtualHostListener,
OpenAPIWebModuleDocListener {
    private static final TraceComponent tc = Tr.register(OpenAPIModuleListener.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi.internal.resources.OpenAPIMessages");
    private final String DEFAULT_OPENAPI_YAML_LOCATION = "META-INF/openapi.yaml";
    private final String DEFAULT_OPENAPI_YML_LOCATION = "META-INF/openapi.yml";
    private final String DEFAULT_OPENAPI_JSON_LOCATION = "META-INF/openapi.json";
    private final String DEFAULT_SWAGGER_YAML_LOCATION = "META-INF/swagger.yaml";
    private final String DEFAULT_SWAGGER_YML_LOCATION = "META-INF/swagger.yml";
    private final String DEFAULT_SWAGGER_JSON_LOCATION = "META-INF/swagger.json";
    ConcurrentHashMap<String, OpenAPIWebModuleDoc> webModuleDocsConfig = new ConcurrentHashMap();
    private ComponentContext context;
    private static final String KEY_EXECUTOR_SERVICE_REF = "executorService";
    private final AtomicServiceReference<ScheduledExecutorService> executorServiceRef = new AtomicServiceReference("executorService");
    private final ConcurrentHashMap<String, OpenAPIWebProvider> webAPIProviders = new ConcurrentHashMap();
    private static final List<String> contextRootsToIgnore = new ArrayList<String>();
    private ScheduledFuture<?> scheduledWabProcessor;
    static final long serialVersionUID = 5394151782203190796L;

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> properties) {
        this.context = context;
        this.executorServiceRef.activate(context);
        this.scheduledWabProcessor = this.getExecutorService().scheduleWithFixedDelay(new Runnable(){
            static final long serialVersionUID = -7235829459307797995L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            /*
             * WARNING - void declaration
             */
            @Override
            public void run() {
                try {
                    OpenAPIModuleListener.this.processWABs();
                }
                catch (InvalidSyntaxException invalidSyntaxException) {
                    void e;
                    FFDCFilter.processException((Throwable)invalidSyntaxException, (String)"com.ibm.ws.openapi.internal.module.OpenAPIModuleListener$1", (String)"131", (Object)this, (Object[])new Object[0]);
                    if (OpenAPIUtils.isEventEnabled.test(tc)) {
                        Tr.event((TraceComponent)tc, (String)("Exception while processing WABs: " + e.getMessage()), (Object[])new Object[0]);
                    }
                    throw new RuntimeException((Throwable)e);
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.openapi.internal.module.OpenAPIModuleListener$1", 1.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi.internal.resources.OpenAPIMessages");
            }
        }, 2L, 1L, TimeUnit.SECONDS);
        this.getExecutorService().schedule(new Runnable(){
            static final long serialVersionUID = 8236138154238921703L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public void run() {
                if (OpenAPIUtils.isDebugEnabled.test(tc)) {
                    Tr.debug((TraceComponent)tc, (String)"Running fail-safe routine to cleanup scheduler", (Object[])new Object[0]);
                }
                OpenAPIModuleListener.this.cancelScheduler();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.openapi.internal.module.OpenAPIModuleListener$2", 2.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi.internal.resources.OpenAPIMessages");
            }
        }, 60L, TimeUnit.SECONDS);
        OpenAPIWebModuleDoc.addListener(this);
    }

    @Deactivate
    protected void deactivate(ComponentContext context, int reason) {
        OpenAPIWebModuleDoc.removeListener(this);
        this.executorServiceRef.deactivate(context);
        this.context = null;
    }

    @Reference(name="executorService", service=ScheduledExecutorService.class)
    protected void setExecutorService(ServiceReference<ScheduledExecutorService> ref) {
        this.executorServiceRef.setReference(ref);
    }

    protected void unsetExecutorService(ServiceReference<ScheduledExecutorService> ref) {
        this.executorServiceRef.unsetReference(ref);
    }

    private ScheduledExecutorService getExecutorService() {
        ScheduledExecutorService service = (ScheduledExecutorService)this.executorServiceRef.getService();
        if (service == null) {
            throw new IllegalStateException(OpenAPIUtils.getOsgiServiceErrorMessage(this.getClass(), "ScheduledExecutorService"));
        }
        return service;
    }

    @Reference(service=OpenAPIWebModuleDoc.class, name="openAPIWebModuleDoc", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY)
    protected void setOpenAPIWebModuleDoc(OpenAPIWebModuleDoc openAPIWebModuleDoc) {
        this.webModuleDocsConfig.put(openAPIWebModuleDoc.getContextRoot(), openAPIWebModuleDoc);
        this.processConfigToProviderAssociation(openAPIWebModuleDoc);
    }

    private void processConfigToProviderAssociation(OpenAPIWebModuleDoc webModuleDoc) {
        String contextRoot = webModuleDoc.getContextRoot();
        OpenAPIWebProvider webProvider = this.getWebProviderFromRoot(contextRoot);
        if (webProvider != null) {
            webProvider.setIsPublic(webModuleDoc.isPublic());
            webProvider.setEnabled(webModuleDoc.getEnabled());
        }
    }

    @Override
    public void modifyOpenAPIWebModuleDoc(OpenAPIWebModuleDoc webModuleDoc, String oldContextRoot) {
        String newContextRoot = webModuleDoc.getContextRoot();
        if (!oldContextRoot.equals(newContextRoot)) {
            OpenAPIWebModuleDoc webModDoc;
            if (OpenAPIUtils.isEventEnabled.test(tc)) {
                Tr.event((TraceComponent)tc, (String)("Changing the association of " + webModuleDoc + " from " + oldContextRoot + " to " + newContextRoot), (Object[])new Object[0]);
            }
            if ((webModDoc = this.webModuleDocsConfig.get(oldContextRoot)) != null && webModDoc.equals(webModuleDoc)) {
                OpenAPIWebProvider webProvider = this.getWebProviderFromRoot(oldContextRoot);
                if (webProvider != null) {
                    webProvider.setIsPublic(true);
                    webProvider.setEnabled(true);
                }
                this.webModuleDocsConfig.remove(oldContextRoot);
            }
            this.webModuleDocsConfig.put(newContextRoot, webModuleDoc);
        }
        this.processConfigToProviderAssociation(webModuleDoc);
    }

    protected void unsetOpenAPIWebModuleDoc(OpenAPIWebModuleDoc openAPIWebModuleDoc) {
        String contextRoot = openAPIWebModuleDoc.getContextRoot();
        this.webModuleDocsConfig.remove(contextRoot);
        OpenAPIWebProvider webProvider = this.getWebProviderFromRoot(contextRoot);
        if (webProvider != null) {
            webProvider.setIsPublic(true);
            webProvider.setEnabled(true);
        }
    }

    public void moduleMetaDataCreated(MetaDataEvent<ModuleMetaData> event) throws MetaDataException {
        if (event.getMetaData() instanceof WebModuleMetaData) {
            String contextRoot = ((WebModuleMetaData)event.getMetaData()).getConfiguration().getContextRoot();
            if (OpenAPIUtils.isEventEnabled.test(tc)) {
                Tr.event((TraceComponent)tc, (String)("WebModule metadata created for module " + ((ModuleMetaData)event.getMetaData()).getJ2EEName() + " | context root " + contextRoot + " | in app " + ((ModuleMetaData)event.getMetaData()).getJ2EEName().getApplication()), (Object[])new Object[0]);
            }
            this.processModule(contextRoot, event.getContainer());
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean processModule(String contextRoot, Container container) {
        OpenAPIWebProvider webProvider;
        for (String ignore : contextRootsToIgnore) {
            if (!contextRoot.equals(ignore)) continue;
            if (OpenAPIUtils.isDebugEnabled.test(tc)) {
                Tr.debug((TraceComponent)tc, (String)("Matched ignored root: " + ignore), (Object[])new Object[0]);
            }
            return true;
        }
        try {
            webProvider = (OpenAPIWebProvider)container.adapt(OpenAPIWebProvider.class);
        }
        catch (UnableToAdaptException ignore) {
            void e;
            FFDCFilter.processException((Throwable)ignore, (String)"com.ibm.ws.openapi.internal.module.OpenAPIModuleListener", (String)"281", (Object)this, (Object[])new Object[]{contextRoot, container});
            throw new RuntimeException((Throwable)e);
        }
        if (webProvider == null) {
            if (OpenAPIUtils.isEventEnabled.test(tc)) {
                Tr.event((TraceComponent)tc, (String)("Unable to adapt contextRoot " + contextRoot), (Object[])new Object[0]);
            }
            return false;
        }
        OpenAPIWebProvider oldWebProvider = this.webAPIProviders.putIfAbsent(contextRoot, webProvider);
        if (oldWebProvider != null) {
            webProvider = oldWebProvider;
        }
        if (OpenAPIUtils.isEventEnabled.test(tc)) {
            Tr.event((TraceComponent)tc, (String)("Added into the map {" + contextRoot + "," + webProvider + "}"), (Object[])new Object[0]);
        }
        return true;
    }

    public void moduleMetaDataDestroyed(MetaDataEvent<ModuleMetaData> event) {
        if (event.getMetaData() instanceof WebModuleMetaData) {
            String contextRoot = ((WebModuleMetaData)event.getMetaData()).getConfiguration().getContextRoot();
            if (OpenAPIUtils.isEventEnabled.test(tc)) {
                Tr.event((TraceComponent)tc, (String)("WebModule metadata destroyed for module " + ((ModuleMetaData)event.getMetaData()).getJ2EEName() + " | context root " + contextRoot + " | in app " + ((ModuleMetaData)event.getMetaData()).getJ2EEName().getApplication()), (Object[])new Object[0]);
            }
            OpenAPIWebProvider webProvider = this.webAPIProviders.remove(contextRoot);
            if (OpenAPIUtils.isEventEnabled.test(tc)) {
                Tr.event((TraceComponent)tc, (String)("Removed from map {" + contextRoot + "," + webProvider + "}"), (Object[])new Object[0]);
            }
            if (webProvider != null) {
                webProvider.setEnabled(false);
            }
        }
    }

    public OpenAPIWebProvider adapt(Container root, OverlayContainer rootOverlay, ArtifactContainer artifactContainer, Container containerToAdapt) throws UnableToAdaptException {
        Entry myEntry = this.getEntry("META-INF/openapi.yaml", containerToAdapt);
        if (myEntry == null) {
            myEntry = this.getEntry("META-INF/openapi.yml", containerToAdapt);
        }
        if (myEntry == null) {
            myEntry = this.getEntry("META-INF/openapi.json", containerToAdapt);
        }
        WebModuleInfo moduleInfo = (WebModuleInfo)rootOverlay.getFromNonPersistentCache(artifactContainer.getPath(), WebModuleInfo.class);
        return new OpenAPIWebProvider(this.context, myEntry == null ? null : (InputStream)myEntry.adapt(InputStream.class), moduleInfo.getClassLoader(), containerToAdapt);
    }

    private OpenAPIWebProvider getWebProviderFromRoot(String contextRoot) {
        return this.webAPIProviders.get(contextRoot);
    }

    public void contextRootAdded(String contextRoot, VirtualHost virtualHost) {
        OpenAPIWebProvider webProvider = this.getWebProviderFromRoot(contextRoot = OpenAPIUtils.normalizeContextRoot(contextRoot));
        if (webProvider != null) {
            OpenAPIWebModuleDoc config;
            String moduleURL = virtualHost.getUrlString(contextRoot, false);
            if (OpenAPIUtils.isDebugEnabled.test(tc)) {
                Tr.debug((TraceComponent)tc, (String)("About to update moduleURL: " + moduleURL), (Object[])new Object[0]);
            }
            webProvider.setModuleURL(moduleURL.endsWith("/") ? moduleURL.substring(0, moduleURL.length() - 1) : moduleURL);
            if (!"default_host".equals(virtualHost.getName())) {
                ArrayList<String> hosts = new ArrayList<String>();
                hosts.add(moduleURL.substring(0, moduleURL.lastIndexOf(contextRoot)));
                String securedModuleURL = virtualHost.getUrlString(contextRoot, true);
                String securedHost = securedModuleURL.substring(0, securedModuleURL.lastIndexOf(contextRoot));
                if (!hosts.contains(securedHost)) {
                    hosts.add(securedHost);
                }
                webProvider.setNonDefaultHosts(hosts);
            }
            if ((config = this.webModuleDocsConfig.get(contextRoot)) != null) {
                if (OpenAPIUtils.isEventEnabled.test(tc)) {
                    Tr.event((TraceComponent)tc, (String)("Found an existing configuration for contextRoot=" + contextRoot + ".  Update web provider obj."), (Object[])new Object[0]);
                }
                webProvider.setIsPublic(config.isPublic());
                webProvider.setEnabled(config.getEnabled());
            } else {
                if (OpenAPIUtils.isEventEnabled.test(tc)) {
                    Tr.event((TraceComponent)tc, (String)"No existing configuration found, just enable the web provider obj.", (Object[])new Object[0]);
                }
                webProvider.setEnabled(true);
            }
        }
    }

    public void contextRootRemoved(String contextRoot, VirtualHost virtualHost) {
    }

    private Entry getEntry(String pathAndName, Container containerToAdapt) {
        Entry myEntry = containerToAdapt.getEntry(pathAndName);
        if (OpenAPIUtils.isDebugEnabled.test(tc)) {
            if (myEntry != null) {
                Tr.debug((TraceComponent)tc, (String)("Found " + pathAndName + ", with size: " + myEntry.getSize()), (Object[])new Object[0]);
            } else {
                Tr.debug((TraceComponent)tc, (String)(pathAndName + " was not found."), (Object[])new Object[0]);
            }
        }
        return myEntry;
    }

    protected void processWABs() throws InvalidSyntaxException {
        if (this.context == null) {
            return;
        }
        ServiceReference[] refs = this.context.getBundleContext().getServiceReferences(Bundle.class.getName(), "(installed.wab.contextRoot=*)");
        if (refs != null) {
            for (ServiceReference ref : refs) {
                String contextRoot = (String)ref.getProperty("installed.wab.contextRoot");
                Container container = (Container)ref.getProperty("installed.wab.container");
                OpenAPIWebProvider webProvider = this.getWebProviderFromRoot(contextRoot);
                if (webProvider != null) continue;
                boolean processedModule = this.processModule(contextRoot, container);
                if (!processedModule) {
                    return;
                }
                webProvider = this.getWebProviderFromRoot(contextRoot);
                if (webProvider == null) continue;
                webProvider.setModuleURL(contextRoot);
                webProvider.setEnabled(true);
            }
        }
        this.getExecutorService().execute(new Runnable(){
            static final long serialVersionUID = -1130990026118992437L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public void run() {
                if (OpenAPIUtils.isEventEnabled.test(tc)) {
                    Tr.event((TraceComponent)tc, (String)"Finished processing WABs, so cleaning up scheduler", (Object[])new Object[0]);
                }
                OpenAPIModuleListener.this.cancelScheduler();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.openapi.internal.module.OpenAPIModuleListener$3", 3.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi.internal.resources.OpenAPIMessages");
            }
        });
    }

    private void cancelScheduler() {
        if (!this.scheduledWabProcessor.isCancelled()) {
            this.scheduledWabProcessor.cancel(true);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        contextRootsToIgnore.add("/ibm/api");
        contextRootsToIgnore.add("/ibm/api/explorer");
        contextRootsToIgnore.add("/IBMJMXConnectorREST");
    }
}

