/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.openapi.internal.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.openapi.internal.utils.OpenAPIModelVisitor;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.swagger.oas.models.Components;
import io.swagger.oas.models.ExternalDocumentation;
import io.swagger.oas.models.OpenAPI;
import io.swagger.oas.models.Operation;
import io.swagger.oas.models.PathItem;
import io.swagger.oas.models.Paths;
import io.swagger.oas.models.callbacks.Callback;
import io.swagger.oas.models.examples.Example;
import io.swagger.oas.models.headers.Header;
import io.swagger.oas.models.info.Contact;
import io.swagger.oas.models.info.Info;
import io.swagger.oas.models.info.License;
import io.swagger.oas.models.links.Link;
import io.swagger.oas.models.media.ArraySchema;
import io.swagger.oas.models.media.ComposedSchema;
import io.swagger.oas.models.media.Content;
import io.swagger.oas.models.media.Discriminator;
import io.swagger.oas.models.media.Encoding;
import io.swagger.oas.models.media.MediaType;
import io.swagger.oas.models.media.Schema;
import io.swagger.oas.models.media.XML;
import io.swagger.oas.models.parameters.Parameter;
import io.swagger.oas.models.parameters.RequestBody;
import io.swagger.oas.models.responses.ApiResponse;
import io.swagger.oas.models.responses.ApiResponses;
import io.swagger.oas.models.security.OAuthFlow;
import io.swagger.oas.models.security.OAuthFlows;
import io.swagger.oas.models.security.Scopes;
import io.swagger.oas.models.security.SecurityRequirement;
import io.swagger.oas.models.security.SecurityScheme;
import io.swagger.oas.models.servers.Server;
import io.swagger.oas.models.servers.ServerVariable;
import io.swagger.oas.models.servers.ServerVariables;
import io.swagger.oas.models.tags.Tag;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public final class OpenAPIModelWalker {
    private final OpenAPI openAPI;
    static final long serialVersionUID = 1928100338867285622L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public OpenAPIModelWalker(OpenAPI openAPI) {
        this.openAPI = openAPI;
    }

    public void accept(OpenAPIModelVisitor visitor) {
        if (visitor != null) {
            new Walker(this.openAPI, visitor).traverseOpenAPI();
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.openapi.internal.utils.OpenAPIModelWalker", OpenAPIModelWalker.class, null, null);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static final class Walker
    implements Context {
        private final OpenAPI openAPI;
        private final OpenAPIModelVisitor visitor;
        private final Deque<Object> ancestors = new ArrayDeque<Object>();
        private final IdentityHashMap<Object, Object> traversedObjects = new IdentityHashMap();
        static final long serialVersionUID = -1847337019613371831L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public Walker(OpenAPI openAPI, OpenAPIModelVisitor visitor) {
            this.openAPI = openAPI;
            this.visitor = visitor;
        }

        @Override
        public OpenAPI getModel() {
            return this.openAPI;
        }

        @Override
        public Object getParent() {
            return this.ancestors.peek();
        }

        public boolean isTraversed(Object o) {
            if (o == null) {
                return true;
            }
            return this.traversedObjects.put(o, o) != null;
        }

        public void traverseOpenAPI() {
            List tags;
            List servers;
            List security;
            Paths paths;
            Info info;
            ExternalDocumentation extDocs;
            Map extensions;
            this.visitor.visitOpenAPI(this);
            this.ancestors.push(this.openAPI);
            Components components = this.openAPI.getComponents();
            if (components != null) {
                this.traverseComponents(components);
            }
            if ((extensions = this.openAPI.getExtensions()) != null) {
                extensions.forEach((k, v) -> {
                    if (k != null && v != null) {
                        this.traverseExtension((String)k, v);
                    }
                });
            }
            if ((extDocs = this.openAPI.getExternalDocs()) != null) {
                this.traverseExternalDocs(extDocs);
            }
            if ((info = this.openAPI.getInfo()) != null) {
                this.traverseInfo(info);
            }
            if ((paths = this.openAPI.getPaths()) != null) {
                this.traversePaths(paths);
            }
            if ((security = this.openAPI.getSecurity()) != null) {
                security.stream().forEach(v -> this.traverseSecurityRequirement((SecurityRequirement)v));
            }
            if ((servers = this.openAPI.getServers()) != null) {
                servers.stream().forEach(v -> this.traverseServer((Server)v));
            }
            if ((tags = this.openAPI.getTags()) != null) {
                tags.stream().forEach(v -> this.traverseTag((Tag)v));
            }
            this.ancestors.pop();
            this.ancestors.clear();
            this.traversedObjects.clear();
        }

        public void traverseComponents(Components components) {
            Map schemes;
            Map schemas;
            Map responses;
            Map requestBodies;
            Map parameters;
            Map links;
            Map headers;
            Map extensions;
            Map examples;
            if (this.isTraversed(components)) {
                return;
            }
            this.visitor.visitComponents(this, components);
            this.ancestors.push(components);
            Map callbacks = components.getCallbacks();
            if (callbacks != null) {
                callbacks.forEach((k, v) -> this.traverseCallback((String)k, (Callback)v));
            }
            if ((examples = components.getExamples()) != null) {
                examples.forEach((k, v) -> this.traverseExample((String)k, (Example)v));
            }
            if ((extensions = components.getExtensions()) != null) {
                extensions.forEach((k, v) -> this.traverseExtension((String)k, v));
            }
            if ((headers = components.getHeaders()) != null) {
                headers.forEach((k, v) -> this.traverseHeader((String)k, (Header)v));
            }
            if ((links = components.getLinks()) != null) {
                links.forEach((k, v) -> this.traverseLink((String)k, (Link)v));
            }
            if ((parameters = components.getParameters()) != null) {
                parameters.forEach((k, v) -> this.traverseParameter((String)k, (Parameter)v));
            }
            if ((requestBodies = components.getRequestBodies()) != null) {
                requestBodies.forEach((k, v) -> this.traverseRequestBody((String)k, (RequestBody)v));
            }
            if ((responses = components.getResponses()) != null) {
                responses.forEach((k, v) -> this.traverseResponse((String)k, (ApiResponse)v));
            }
            if ((schemas = components.getSchemas()) != null) {
                schemas.forEach((k, v) -> this.traverseSchema((String)k, (Schema<?>)v));
            }
            if ((schemes = components.getSecuritySchemes()) != null) {
                schemes.forEach((k, v) -> this.traverseSecurityScheme((String)k, (SecurityScheme)v));
            }
            this.ancestors.pop();
        }

        public void traverseCallback(String key, Callback callback) {
            if (this.isTraversed(callback)) {
                return;
            }
            this.visitor.visitCallback(this, key, callback);
            this.ancestors.push(callback);
            Map extensions = callback.getExtensions();
            if (extensions != null) {
                extensions.forEach((k, v) -> this.traverseExtension((String)k, v));
            }
            callback.forEach((k, v) -> this.traversePathItem((String)k, (PathItem)v));
            this.ancestors.pop();
        }

        public void traversePathItem(String key, PathItem item) {
            List servers;
            if (this.isTraversed(item)) {
                return;
            }
            this.visitor.visitPathItem(this, key, item);
            this.ancestors.push(item);
            Map extensions = item.getExtensions();
            if (extensions != null) {
                extensions.forEach((k, v) -> this.traverseExtension((String)k, v));
            }
            Operation[] operations = new Operation[]{item.getDelete(), item.getGet(), item.getHead(), item.getOptions(), item.getPatch(), item.getPost(), item.getPut(), item.getTrace()};
            Arrays.stream(operations).forEach(v -> this.traverseOperation((Operation)v));
            List parameters = item.getParameters();
            if (parameters != null) {
                parameters.stream().forEach(v -> this.traverseParameter(null, (Parameter)v));
            }
            if ((servers = item.getServers()) != null) {
                servers.stream().forEach(v -> this.traverseServer((Server)v));
            }
            this.ancestors.pop();
        }

        public void traverseOperation(Operation operation) {
            List servers;
            List security;
            ApiResponses responses;
            RequestBody rb;
            List parameters;
            ExternalDocumentation extDocs;
            Map extensions;
            if (this.isTraversed(operation)) {
                return;
            }
            this.visitor.visitOperation(this, operation);
            this.ancestors.push(operation);
            Map callbacks = operation.getCallbacks();
            if (callbacks != null) {
                callbacks.forEach((k, v) -> this.traverseCallback((String)k, (Callback)v));
            }
            if ((extensions = operation.getExtensions()) != null) {
                extensions.forEach((k, v) -> this.traverseExtension((String)k, v));
            }
            if ((extDocs = operation.getExternalDocs()) != null) {
                this.traverseExternalDocs(extDocs);
            }
            if ((parameters = operation.getParameters()) != null) {
                parameters.stream().forEach(v -> this.traverseParameter(null, (Parameter)v));
            }
            if ((rb = operation.getRequestBody()) != null) {
                this.traverseRequestBody(null, rb);
            }
            if ((responses = operation.getResponses()) != null) {
                this.traverseResponses(responses);
            }
            if ((security = operation.getSecurity()) != null) {
                security.stream().forEach(v -> this.traverseSecurityRequirement((SecurityRequirement)v));
            }
            if ((servers = operation.getServers()) != null) {
                servers.stream().forEach(v -> this.traverseServer((Server)v));
            }
            this.ancestors.pop();
        }

        public void traverseExample(String key, Example example) {
            if (this.isTraversed(example)) {
                return;
            }
            if (key != null) {
                this.visitor.visitExample(this, key, example);
            } else {
                this.visitor.visitExample(this, example);
            }
            this.ancestors.push(example);
            Map extensions = example.getExtensions();
            if (extensions != null) {
                extensions.forEach((k, v) -> this.traverseExtension((String)k, v));
            }
            this.ancestors.pop();
        }

        public void traverseHeader(String key, Header header) {
            Schema schema;
            Map extensions;
            Map examples;
            if (this.isTraversed(header)) {
                return;
            }
            this.visitor.visitHeader(this, key, header);
            this.ancestors.push(header);
            Content content = header.getContent();
            if (content != null) {
                content.forEach((k, v) -> this.traverseMediaType((String)k, (MediaType)v));
            }
            if ((examples = header.getExamples()) != null) {
                examples.forEach((k, v) -> this.traverseExample((String)k, (Example)v));
            }
            if ((extensions = header.getExtensions()) != null) {
                extensions.forEach((k, v) -> this.traverseExtension((String)k, v));
            }
            if ((schema = header.getSchema()) != null) {
                this.traverseSchema(null, schema);
            }
            this.ancestors.pop();
        }

        public void traverseMediaType(String key, MediaType mediaType) {
            Schema schema;
            Map extensions;
            Map examples;
            if (this.isTraversed(mediaType)) {
                return;
            }
            this.visitor.visitMediaType(this, key, mediaType);
            this.ancestors.push(mediaType);
            Map encoding = mediaType.getEncoding();
            if (encoding != null) {
                encoding.forEach((k, v) -> this.traverseEncoding((String)k, (Encoding)v));
            }
            if ((examples = mediaType.getExamples()) != null) {
                examples.forEach((k, v) -> this.traverseExample((String)k, (Example)v));
            }
            if ((extensions = mediaType.getExtensions()) != null) {
                extensions.forEach((k, v) -> this.traverseExtension((String)k, v));
            }
            if ((schema = mediaType.getSchema()) != null) {
                this.traverseSchema(null, schema);
            }
            this.ancestors.pop();
        }

        public void traverseEncoding(String key, Encoding encoding) {
            Map headers;
            if (this.isTraversed(encoding)) {
                return;
            }
            this.visitor.visitEncoding(this, key, encoding);
            this.ancestors.push(encoding);
            Map extensions = encoding.getExtensions();
            if (extensions != null) {
                extensions.forEach((k, v) -> this.traverseExtension((String)k, v));
            }
            if ((headers = encoding.getHeaders()) != null) {
                headers.forEach((k, v) -> this.traverseHeader((String)k, (Header)v));
            }
            this.ancestors.pop();
        }

        public void traverseLink(String key, Link link) {
            Server server;
            Map headers;
            if (this.isTraversed(link)) {
                return;
            }
            this.visitor.visitLink(this, key, link);
            this.ancestors.push(link);
            Map extensions = link.getExtensions();
            if (extensions != null) {
                extensions.forEach((k, v) -> this.traverseExtension((String)k, v));
            }
            if ((headers = link.getHeaders()) != null) {
                headers.forEach((k, v) -> this.traverseHeader((String)k, (Header)v));
            }
            if ((server = link.getServer()) != null) {
                this.traverseServer(server);
            }
            this.ancestors.pop();
        }

        public void traverseParameter(String key, Parameter p) {
            Schema schema;
            Map extensions;
            Map examples;
            if (this.isTraversed(p)) {
                return;
            }
            if (key != null) {
                this.visitor.visitParameter(this, key, p);
            } else {
                this.visitor.visitParameter(this, p);
            }
            this.ancestors.push(p);
            Content content = p.getContent();
            if (content != null) {
                content.forEach((k, v) -> this.traverseMediaType((String)k, (MediaType)v));
            }
            if ((examples = p.getExamples()) != null) {
                examples.forEach((k, v) -> this.traverseExample((String)k, (Example)v));
            }
            if ((extensions = p.getExtensions()) != null) {
                extensions.forEach((k, v) -> this.traverseExtension((String)k, v));
            }
            if ((schema = p.getSchema()) != null) {
                this.traverseSchema(null, schema);
            }
            this.ancestors.pop();
        }

        public void traverseRequestBody(String key, RequestBody rb) {
            Map extensions;
            if (this.isTraversed(rb)) {
                return;
            }
            if (key != null) {
                this.visitor.visitRequestBody(this, key, rb);
            } else {
                this.visitor.visitRequestBody(this, rb);
            }
            this.ancestors.push(rb);
            Content content = rb.getContent();
            if (content != null) {
                content.forEach((k, v) -> this.traverseMediaType((String)k, (MediaType)v));
            }
            if ((extensions = rb.getExtensions()) != null) {
                extensions.forEach((k, v) -> this.traverseExtension((String)k, v));
            }
            this.ancestors.pop();
        }

        public void traverseResponses(ApiResponses responses) {
            if (this.isTraversed(responses)) {
                return;
            }
            this.visitor.visitResponses(this, responses);
            this.ancestors.push(responses);
            responses.forEach((k, v) -> this.traverseResponse((String)k, (ApiResponse)v));
            ApiResponse defaultResponse = responses.getDefault();
            if (defaultResponse != null) {
                this.traverseResponse("default", defaultResponse);
            }
            this.ancestors.pop();
        }

        public void traverseResponse(String key, ApiResponse response) {
            Map links;
            Map headers;
            Map extensions;
            if (this.isTraversed(response)) {
                return;
            }
            this.visitor.visitResponse(this, key, response);
            this.ancestors.push(response);
            Content content = response.getContent();
            if (content != null) {
                content.forEach((k, v) -> this.traverseMediaType((String)k, (MediaType)v));
            }
            if ((extensions = response.getExtensions()) != null) {
                extensions.forEach((k, v) -> this.traverseExtension((String)k, v));
            }
            if ((headers = response.getHeaders()) != null) {
                headers.forEach((k, v) -> this.traverseHeader((String)k, (Header)v));
            }
            if ((links = response.getLinks()) != null) {
                links.forEach((k, v) -> this.traverseLink((String)k, (Link)v));
            }
            this.ancestors.pop();
        }

        public void traverseSchema(String key, Schema<?> schema) {
            List<Schema> nestedSchemas;
            XML xml;
            Map schemas;
            Schema notSchema;
            ExternalDocumentation extDocs;
            Map extensions;
            Discriminator d;
            if (this.isTraversed(schema)) {
                return;
            }
            if (key != null) {
                this.visitor.visitSchema(this, key, schema);
            } else {
                this.visitor.visitSchema(this, schema);
            }
            this.ancestors.push(schema);
            Schema addProps = schema.getAdditionalProperties();
            if (addProps != null) {
                this.traverseSchema(key, addProps);
            }
            if ((d = schema.getDiscriminator()) != null) {
                this.traverseDiscriminator(d);
            }
            if ((extensions = schema.getExtensions()) != null) {
                extensions.forEach((k, v) -> this.traverseExtension((String)k, v));
            }
            if ((extDocs = schema.getExternalDocs()) != null) {
                this.traverseExternalDocs(extDocs);
            }
            if ((notSchema = schema.getNot()) != null) {
                this.traverseSchema(key, notSchema);
            }
            if ((schemas = schema.getProperties()) != null) {
                schemas.forEach((k, v) -> this.traverseSchema((String)k, (Schema<?>)v));
            }
            if ((xml = schema.getXml()) != null) {
                this.traverseXML(xml);
            }
            if (schema instanceof ArraySchema) {
                ArraySchema arraySchema = (ArraySchema)schema;
                Schema items = arraySchema.getItems();
                nestedSchemas = items != null ? Collections.singletonList(items) : null;
            } else if (schema instanceof ComposedSchema) {
                List oneOf;
                List anyOf;
                ComposedSchema composedSchema = (ComposedSchema)schema;
                ArrayList<Schema> _nestedSchemas = new ArrayList<Schema>();
                List allOf = composedSchema.getAllOf();
                if (allOf != null) {
                    _nestedSchemas.addAll(allOf);
                }
                if ((anyOf = composedSchema.getAnyOf()) != null) {
                    _nestedSchemas.addAll(anyOf);
                }
                if ((oneOf = composedSchema.getOneOf()) != null) {
                    _nestedSchemas.addAll(oneOf);
                }
                nestedSchemas = !_nestedSchemas.isEmpty() ? _nestedSchemas : null;
            } else {
                nestedSchemas = null;
            }
            if (nestedSchemas != null) {
                nestedSchemas.stream().forEach(v -> this.traverseSchema(null, (Schema<?>)v));
            }
            this.ancestors.pop();
        }

        public void traverseDiscriminator(Discriminator d) {
            if (this.isTraversed(d)) {
                return;
            }
            this.visitor.visitDiscriminator(this, d);
        }

        public void traverseXML(XML xml) {
            if (this.isTraversed(xml)) {
                return;
            }
            this.visitor.visitXML(this, xml);
            this.ancestors.push(xml);
            Map extensions = xml.getExtensions();
            if (extensions != null) {
                extensions.forEach((k, v) -> this.traverseExtension((String)k, v));
            }
            this.ancestors.pop();
        }

        public void traverseSecurityScheme(String key, SecurityScheme scheme) {
            OAuthFlows authFlows;
            if (this.isTraversed(scheme)) {
                return;
            }
            this.visitor.visitSecurityScheme(this, key, scheme);
            this.ancestors.push(scheme);
            Map extensions = scheme.getExtensions();
            if (extensions != null) {
                extensions.forEach((k, v) -> this.traverseExtension((String)k, v));
            }
            if ((authFlows = scheme.getFlows()) != null) {
                this.traverseOAuthFlows(authFlows);
            }
            this.ancestors.pop();
        }

        public void traverseOAuthFlows(OAuthFlows authFlows) {
            if (this.isTraversed(authFlows)) {
                return;
            }
            this.visitor.visitOAuthFlows(this, authFlows);
            this.ancestors.push(authFlows);
            Map extensions = authFlows.getExtensions();
            if (extensions != null) {
                extensions.forEach((k, v) -> this.traverseExtension((String)k, v));
            }
            OAuthFlow[] _authFlows = new OAuthFlow[]{authFlows.getAuthorizationCode(), authFlows.getClientCredentials(), authFlows.getImplicit(), authFlows.getPassword()};
            Arrays.stream(_authFlows).forEach(v -> this.traverseOAuthFlow((OAuthFlow)v));
            this.ancestors.pop();
        }

        public void traverseOAuthFlow(OAuthFlow authFlow) {
            Scopes scopes;
            if (this.isTraversed(authFlow)) {
                return;
            }
            this.visitor.visitOAuthFlow(this, authFlow);
            this.ancestors.push(authFlow);
            Map extensions = authFlow.getExtensions();
            if (extensions != null) {
                extensions.forEach((k, v) -> this.traverseExtension((String)k, v));
            }
            if ((scopes = authFlow.getScopes()) != null) {
                this.traverseScopes(scopes);
            }
            this.ancestors.pop();
        }

        public void traverseScopes(Scopes scopes) {
            if (this.isTraversed(scopes)) {
                return;
            }
            this.visitor.visitScopes(this, scopes);
            this.ancestors.push(scopes);
            Map extensions = scopes.getExtensions();
            if (extensions != null) {
                extensions.forEach((k, v) -> this.traverseExtension((String)k, v));
            }
            this.ancestors.pop();
        }

        public void traverseExtension(String key, Object extension) {
            this.visitor.visitExtension(this, key, extension);
        }

        public void traverseExternalDocs(ExternalDocumentation extDocs) {
            if (this.isTraversed(extDocs)) {
                return;
            }
            this.visitor.visitExternalDocumentation(this, extDocs);
            this.ancestors.push(extDocs);
            Map extensions = extDocs.getExtensions();
            if (extensions != null) {
                extensions.forEach((k, v) -> this.traverseExtension((String)k, v));
            }
            this.ancestors.pop();
        }

        public void traverseInfo(Info info) {
            License license;
            Map extensions;
            if (this.isTraversed(info)) {
                return;
            }
            this.visitor.visitInfo(this, info);
            this.ancestors.push(info);
            Contact contact = info.getContact();
            if (contact != null) {
                this.traverseContact(contact);
            }
            if ((extensions = info.getExtensions()) != null) {
                extensions.forEach((k, v) -> this.traverseExtension((String)k, v));
            }
            if ((license = info.getLicense()) != null) {
                this.traverseLicense(license);
            }
            this.ancestors.pop();
        }

        public void traverseContact(Contact contact) {
            if (this.isTraversed(contact)) {
                return;
            }
            this.visitor.visitContact(this, contact);
            this.ancestors.push(contact);
            Map extensions = contact.getExtensions();
            if (extensions != null) {
                extensions.forEach((k, v) -> this.traverseExtension((String)k, v));
            }
            this.ancestors.pop();
        }

        public void traverseLicense(License license) {
            if (this.isTraversed(license)) {
                return;
            }
            this.visitor.visitLicense(this, license);
            this.ancestors.push(license);
            Map extensions = license.getExtensions();
            if (extensions != null) {
                extensions.forEach((k, v) -> this.traverseExtension((String)k, v));
            }
            this.ancestors.pop();
        }

        public void traversePaths(Paths paths) {
            if (this.isTraversed(paths)) {
                return;
            }
            this.visitor.visitPaths(this, paths);
            this.ancestors.push(paths);
            paths.forEach((k, v) -> this.traversePathItem((String)k, (PathItem)v));
            Map extensions = paths.getExtensions();
            if (extensions != null) {
                extensions.forEach((k, v) -> this.traverseExtension((String)k, v));
            }
            this.ancestors.pop();
        }

        public void traverseSecurityRequirement(SecurityRequirement sr) {
            if (this.isTraversed(sr)) {
                return;
            }
            this.visitor.visitSecurityRequirement(this, sr);
        }

        public void traverseServer(Server server) {
            ServerVariables svs;
            if (this.isTraversed(server)) {
                return;
            }
            this.visitor.visitServer(this, server);
            this.ancestors.push(server);
            Map extensions = server.getExtensions();
            if (extensions != null) {
                extensions.forEach((k, v) -> this.traverseExtension((String)k, v));
            }
            if ((svs = server.getVariables()) != null) {
                this.traverseServerVariables(svs);
            }
            this.ancestors.pop();
        }

        public void traverseServerVariables(ServerVariables svs) {
            if (this.isTraversed(svs)) {
                return;
            }
            this.visitor.visitServerVariables(this, svs);
            this.ancestors.push(svs);
            svs.forEach((k, v) -> this.traverseServerVariable((String)k, (ServerVariable)v));
            Map extensions = svs.getExtensions();
            if (extensions != null) {
                extensions.forEach((k, v) -> this.traverseExtension((String)k, v));
            }
            this.ancestors.pop();
        }

        public void traverseServerVariable(String key, ServerVariable sv) {
            if (this.isTraversed(sv)) {
                return;
            }
            this.visitor.visitServerVariable(this, key, sv);
            this.ancestors.push(sv);
            Map extensions = sv.getExtensions();
            if (extensions != null) {
                extensions.forEach((k, v) -> this.traverseExtension((String)k, v));
            }
            this.ancestors.pop();
        }

        public void traverseTag(Tag tag) {
            ExternalDocumentation extDocs;
            if (this.isTraversed(tag)) {
                return;
            }
            this.visitor.visitTag(this, tag);
            this.ancestors.push(tag);
            Map extensions = tag.getExtensions();
            if (extensions != null) {
                extensions.forEach((k, v) -> this.traverseExtension((String)k, v));
            }
            if ((extDocs = tag.getExternalDocs()) != null) {
                this.traverseExternalDocs(extDocs);
            }
            this.ancestors.pop();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.openapi.internal.utils.OpenAPIModelWalker$Walker", Walker.class, null, null);
        }
    }

    public static interface Context {
        public OpenAPI getModel();

        public Object getParent();
    }
}

