/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.openapi.internal.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.openapi.internal.OpenAPIUtils;
import com.ibm.ws.openapi.internal.ServerInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ProxySupportUtil {
    private static final String HTTP_HEADER_REFERER = "Referer";
    private static TraceComponent tc = Tr.register(ProxySupportUtil.class, null, null);
    static final long serialVersionUID = 3192863582090101658L;

    @FFDCIgnore(value={MalformedURLException.class})
    private static URL extractURL(HttpServletRequest request) {
        URL url;
        block7: {
            String urlString;
            String refererHeader = request.getHeader(HTTP_HEADER_REFERER);
            if (refererHeader != null) {
                if (OpenAPIUtils.isDebugEnabled.test(tc)) {
                    Tr.debug((TraceComponent)tc, (String)("Using referer header to generate servers: " + refererHeader), (Object[])new Object[0]);
                }
                String string = refererHeader = refererHeader.endsWith("/") ? refererHeader.substring(0, refererHeader.length() - 1) : refererHeader;
                if (!refererHeader.endsWith("/explorer") && !refererHeader.endsWith("/docs")) {
                    refererHeader = null;
                }
                urlString = refererHeader != null ? refererHeader : request.getRequestURL().toString();
            } else {
                urlString = request.getRequestURL().toString();
                if (OpenAPIUtils.isDebugEnabled.test(tc)) {
                    Tr.debug((TraceComponent)tc, (String)("Using request url to generate servers: " + urlString), (Object[])new Object[0]);
                }
            }
            url = null;
            try {
                url = new URL(urlString);
            }
            catch (MalformedURLException e) {
                if (!OpenAPIUtils.isDebugEnabled.test(tc)) break block7;
                Tr.event((TraceComponent)tc, (String)("Failed to create URL for " + urlString + ": " + e.getMessage()), (Object[])new Object[0]);
            }
        }
        return url;
    }

    public static void processRequest(HttpServletRequest request, ServerInfo serverInfo) {
        URL url = ProxySupportUtil.extractURL(request);
        if (url == null) {
            return;
        }
        serverInfo.setHost(url.getHost());
        Integer port = url.getPort() == -1 ? url.getDefaultPort() : url.getPort();
        if (port.intValue() != serverInfo.getHttpPort() && port.intValue() != serverInfo.getHttpsPort()) {
            if ("https".equalsIgnoreCase(url.getProtocol())) {
                serverInfo.setHttpPort(-1);
                serverInfo.setHttpsPort(port);
            } else {
                serverInfo.setHttpPort(port);
                serverInfo.setHttpsPort(-1);
            }
        }
    }
}

