/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.openapi.internal.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.openapi.internal.utils.OpenAPIModelWalker;
import com.ibm.ws.openapi.internal.validation.OASValidationResult;
import com.ibm.ws.openapi.internal.validation.RuntimeExpressionUtils;
import com.ibm.ws.openapi.internal.validation.TypeValidator;
import com.ibm.ws.openapi.internal.validation.ValidationHelper;
import com.ibm.ws.openapi.internal.validation.ValidatorUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.swagger.oas.models.PathItem;
import io.swagger.oas.models.callbacks.Callback;
import java.util.List;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CallbackValidator
extends TypeValidator<Callback> {
    private static final TraceComponent tc = Tr.register(CallbackValidator.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi.internal.validation.resources.ValidationMessages");
    private static final CallbackValidator INSTANCE = new CallbackValidator();
    static final long serialVersionUID = 4396959369008569565L;

    public static CallbackValidator getInstance() {
        return INSTANCE;
    }

    private CallbackValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, Callback t) {
        for (String urlTemplate : t.keySet()) {
            Object pathItem;
            String message;
            if (urlTemplate.isEmpty()) {
                message = Tr.formatMessage((TraceComponent)tc, (String)"callbackURLTemplateEmpty", (Object[])new Object[0]);
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
                continue;
            }
            List<String> vars = RuntimeExpressionUtils.extractURLVars(urlTemplate);
            if (vars == null) {
                message = Tr.formatMessage((TraceComponent)tc, (String)"callbackInvalidSubstitutionVariables", (Object[])new Object[]{urlTemplate});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
            } else {
                for (String v : vars) {
                    if (RuntimeExpressionUtils.isRuntimeExpression(v)) continue;
                    message = Tr.formatMessage((TraceComponent)tc, (String)"callbackMustBeRuntimeExpression", (Object[])new Object[]{v});
                    helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
                }
                String buildURL = urlTemplate;
                for (String v : vars) {
                    String templateVar = "{" + v + "}";
                    buildURL = buildURL.replace(templateVar, "e");
                }
                if (!ValidatorUtils.isValidURL(buildURL)) {
                    message = Tr.formatMessage((TraceComponent)tc, (String)"callbackInvalidURL", (Object[])new Object[]{urlTemplate});
                    helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
                }
            }
            if ((pathItem = t.get((Object)urlTemplate)) instanceof PathItem) continue;
            message = Tr.formatMessage((TraceComponent)tc, (String)"callbackInvalidPathItem", (Object[])new Object[]{urlTemplate});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
        }
    }
}

