/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.openapi.internal.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.openapi.internal.utils.OpenAPIModelWalker;
import com.ibm.ws.openapi.internal.validation.OASValidationResult;
import com.ibm.ws.openapi.internal.validation.TypeValidator;
import com.ibm.ws.openapi.internal.validation.ValidationHelper;
import com.ibm.ws.openapi.internal.validation.ValidatorUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.swagger.oas.models.info.Contact;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ContactValidator
extends TypeValidator<Contact> {
    private static final TraceComponent tc = Tr.register(ContactValidator.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi.internal.validation.resources.ValidationMessages");
    private static final ContactValidator INSTANCE = new ContactValidator();
    static final long serialVersionUID = -7037731633308792129L;

    public static ContactValidator getInstance() {
        return INSTANCE;
    }

    private ContactValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, Contact t) {
        String message;
        if (t.getUrl() != null && !ValidatorUtils.isValidURL(t.getUrl())) {
            message = Tr.formatMessage((TraceComponent)tc, (String)"contactInvalidURL", (Object[])new Object[]{t.getUrl()});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
        }
        if (t.getEmail() != null && !ValidatorUtils.isValidEmailAddress(t.getEmail())) {
            message = Tr.formatMessage((TraceComponent)tc, (String)"contactInvalidEmail", (Object[])new Object[]{t.getEmail()});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, null, message));
        }
    }
}

