/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.openapi.internal.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.openapi.internal.utils.OpenAPIModelWalker;
import com.ibm.ws.openapi.internal.validation.ContactValidator;
import com.ibm.ws.openapi.internal.validation.OASValidationResult;
import com.ibm.ws.openapi.internal.validation.TypeValidator;
import com.ibm.ws.openapi.internal.validation.ValidationHelper;
import com.ibm.ws.openapi.internal.validation.ValidatorUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.swagger.oas.models.examples.Example;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ExampleValidator
extends TypeValidator<Example> {
    private static final TraceComponent tc = Tr.register(ContactValidator.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi.internal.validation.resources.ValidationMessages");
    private static final ExampleValidator INSTANCE = new ExampleValidator();
    static final long serialVersionUID = 6604721118239626630L;

    public static ExampleValidator getInstance() {
        return INSTANCE;
    }

    private ExampleValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, Example t) {
        String reference = t.get$ref();
        if (reference != null && !reference.isEmpty()) {
            ValidatorUtils.referenceValidatorHelper(reference, t, helper, context, key);
            return;
        }
        if (t.getValue() != null && t.getExternalValue() != null && !t.getExternalValue().isEmpty()) {
            String message = Tr.formatMessage((TraceComponent)tc, (String)"exampleOnlyValueOrExternalValue", (Object[])new Object[]{key});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.WARNING, null, message));
        }
    }
}

